/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreReader;
import org.wso2.carbon.registry.core.Resource;

public class PAPPolicyStoreManager {
    private static final Log log = LogFactory.getLog(PAPPolicyStoreManager.class);
    private PAPPolicyStore store = new PAPPolicyStore();
    private PAPPolicyStoreReader storeReader = new PAPPolicyStoreReader(this.store);

    public void addOrUpdatePolicy(PolicyDTO policy) throws EntitlementException {
        this.store.addOrUpdatePolicy(policy, "/repository/identity/entitlement/policy/pap/");
    }

    public void removePolicy(String policyId) throws EntitlementException {
        this.store.removePolicy(policyId);
    }

    public String[] getPolicyIds() throws EntitlementException {
        return this.store.getAllPolicyIds();
    }

    public PolicyDTO getPolicy(String policyId) throws EntitlementException {
        return this.storeReader.readPolicyDTO(policyId);
    }

    public boolean isExistPolicy(String policyId) {
        return this.storeReader.isExistPolicy(policyId);
    }

    public PolicyDTO getLightPolicy(String policyId) throws EntitlementException {
        return this.storeReader.readLightPolicyDTO(policyId);
    }

    public PolicyDTO getMetaDataPolicy(String policyId) throws EntitlementException {
        return this.storeReader.readMetaDataPolicyDTO(policyId);
    }

    public PolicyDTO getPolicy(Resource resource) throws EntitlementException {
        return this.storeReader.readPolicyDTO(resource);
    }

    public PolicyDTO[] getAllLightPolicyDTOs() throws EntitlementException {
        return this.storeReader.readAllLightPolicyDTOs();
    }
}

