/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.PolicyAttributeBuilder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PAPPolicyStore {
    private static final Log log = LogFactory.getLog(PAPPolicyStore.class);
    private Registry registry;

    public PAPPolicyStore() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        this.registry = EntitlementServiceComponent.getGovernanceRegistry(tenantId);
    }

    public PAPPolicyStore(Registry registry) throws EntitlementException {
        if (registry == null) {
            log.error((Object)"Registry reference not set");
            throw new EntitlementException("Registry reference not set");
        }
        this.registry = registry;
    }

    public String[] getAllPolicyIds() throws EntitlementException {
        String path = null;
        Collection collection = null;
        ArrayList<String> resources = new ArrayList<String>();
        String[] children = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving all entitlement policies");
        }
        try {
            path = "/repository/identity/entitlement/policy/pap/";
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            for (String child : children = collection.getChildren()) {
                String[] resourcePath = child.split("/");
                if (resourcePath == null || resourcePath.length <= 0) continue;
                resources.add(resourcePath[resourcePath.length - 1]);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving all entitlement policy identifiers from PAP policy store", (Throwable)e);
            throw new EntitlementException("Error while retrieving entitlement policy identifiers from PAP policy store");
        }
        return resources.toArray(new String[resources.size()]);
    }

    public Resource getPolicy(String policyId, String collection) throws EntitlementException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving entitlement policy");
        }
        try {
            path = collection + policyId;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            return this.registry.get(path);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving entitlement policy " + policyId + " PAP policy store"), (Throwable)e);
            throw new EntitlementException("Error while retrieving entitlement policy " + policyId + " PAP policy store");
        }
    }

    public void addOrUpdatePolicy(PolicyDTO policy, String policyPath) throws EntitlementException {
        this.addOrUpdatePolicy(policy, policy.getPolicyId(), policyPath);
    }

    public void addOrUpdatePolicy(PolicyDTO policy, String policyId, String policyPath) throws EntitlementException {
        String path = null;
        Resource resource = null;
        boolean newPolicy = false;
        OMElement omElement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating or updating entitlement policy");
        }
        if (policy == null || policyId == null) {
            log.error((Object)"Error while creating or updating entitlement policy: Policy DTO or Policy Id can not be null");
            throw new EntitlementException("Invalid Entitlement Policy. Policy or policyId can not be Null");
        }
        try {
            String[] policyMetaData;
            path = policyPath + policyId;
            resource = this.registry.resourceExists(path) ? this.registry.get(path) : this.registry.newResource();
            Collection policyCollection = this.registry.resourceExists(policyPath) ? (Collection)this.registry.get(policyPath) : this.registry.newCollection();
            if (policy.getPolicyOrder() > 0) {
                String noOfPolicies = policyCollection.getProperty("maxPolicyOrder");
                if (noOfPolicies != null && Integer.parseInt(noOfPolicies) < policy.getPolicyOrder()) {
                    policyCollection.setProperty("maxPolicyOrder", Integer.toString(policy.getPolicyOrder()));
                    this.registry.put(policyPath, (Resource)policyCollection);
                }
                resource.setProperty("policyOrder", Integer.toString(policy.getPolicyOrder()));
            } else {
                String previousOrder = resource.getProperty("policyOrder");
                if (previousOrder == null) {
                    if (policyCollection != null) {
                        int policyOrder = 1;
                        String noOfPolicies = policyCollection.getProperty("maxPolicyOrder");
                        if (noOfPolicies != null) {
                            policyOrder += Integer.parseInt(noOfPolicies);
                        }
                        policyCollection.setProperty("maxPolicyOrder", Integer.toString(policyOrder));
                        resource.setProperty("policyOrder", Integer.toString(policyOrder));
                    }
                    this.registry.put(policyPath, (Resource)policyCollection);
                }
            }
            if (StringUtils.isNotBlank((String)policy.getPolicy())) {
                resource.setContent((Object)policy.getPolicy());
                newPolicy = true;
                PolicyAttributeBuilder policyAttributeBuilder = new PolicyAttributeBuilder(policy.getPolicy());
                Properties properties = policyAttributeBuilder.getPolicyMetaDataFromPolicy();
                Properties resourceProperties = new Properties();
                for (Object o : properties.keySet()) {
                    String key = o.toString();
                    resourceProperties.put(key, Collections.singletonList(properties.get(key)));
                }
                resource.setProperties(resourceProperties);
            }
            resource.setProperty("isActive", Boolean.toString(policy.isActive()));
            resource.setProperty("promoted", Boolean.toString(policy.isPromote()));
            if (policy.getVersion() != null) {
                resource.setProperty("version", policy.getVersion());
            }
            resource.setProperty("lastModifiedTime", Long.toString(System.currentTimeMillis()));
            resource.setProperty("lastModifiedUser", CarbonContext.getThreadLocalCarbonContext().getUsername());
            if (policy.getPolicyType() != null && policy.getPolicyType().trim().length() > 0) {
                resource.setProperty("policyType", policy.getPolicyType());
            } else {
                try {
                    if (newPolicy) {
                        omElement = AXIOMUtil.stringToOM((String)policy.getPolicy());
                        resource.setProperty("policyType", omElement.getLocalName());
                    }
                }
                catch (XMLStreamException e) {
                    policy.setPolicyType("Policy");
                    log.warn((Object)"Policy Type can not be found. Default type is set");
                }
            }
            if (omElement != null) {
                Iterator iterator2;
                Iterator iterator1 = omElement.getChildrenWithLocalName("policyIdReferences");
                if (iterator1 != null) {
                    String policyReferences = "";
                    while (iterator1.hasNext()) {
                        OMElement policyReference = (OMElement)iterator1.next();
                        if (!"".equals(policyReferences)) {
                            policyReferences = policyReferences + "," + policyReference.getText();
                            continue;
                        }
                        policyReferences = policyReference.getText();
                    }
                    resource.setProperty("policyIdReferences", policyReferences);
                }
                if ((iterator2 = omElement.getChildrenWithLocalName("policySetIdReferences")) != null) {
                    String policySetReferences = "";
                    while (iterator1.hasNext()) {
                        OMElement policySetReference = (OMElement)iterator2.next();
                        if (!"".equals(policySetReferences)) {
                            policySetReferences = policySetReferences + "," + policySetReference.getText();
                            continue;
                        }
                        policySetReferences = policySetReference.getText();
                    }
                    resource.setProperty("policySetIdReferences", policySetReferences);
                }
            }
            String policyEditor = resource.getProperty("policyEditor");
            if (newPolicy && policyEditor != null) {
                resource.removeProperty("policyEditor");
            }
            if (policy.getPolicyEditor() != null && policy.getPolicyEditor().trim().length() > 0) {
                resource.setProperty("policyEditor", policy.getPolicyEditor().trim());
            }
            if ((policyMetaData = policy.getPolicyEditorData()) != null && policyMetaData.length > 0) {
                String BasicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
                if (newPolicy && BasicPolicyEditorMetaDataAmount != null) {
                    int amount = Integer.parseInt(BasicPolicyEditorMetaDataAmount);
                    for (int i = 0; i < amount; ++i) {
                        resource.removeProperty("basicPolicyEditorMetaData" + i);
                    }
                    resource.removeProperty("NoOfBasicPolicyEditorMetaData");
                }
                int i = 0;
                for (String policyData : policyMetaData) {
                    if (policyData != null && !"".equals(policyData)) {
                        resource.setProperty("basicPolicyEditorMetaData" + i, policyData);
                    }
                    ++i;
                }
                resource.setProperty("NoOfBasicPolicyEditorMetaData", Integer.toString(i));
            }
            this.registry.put(path, resource);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while adding or updating entitlement policy " + policyId + " in policy store"), (Throwable)e);
            throw new EntitlementException("Error while adding or updating entitlement policy in policy store");
        }
    }

    public void removePolicy(String policyId) throws EntitlementException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing entitlement policy");
        }
        try {
            path = "/repository/identity/entitlement/policy/pap/" + policyId;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return;
            }
            this.registry.delete(path);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while removing entitlement policy " + policyId + " from PAP policy store"), (Throwable)e);
            throw new EntitlementException("Error while removing policy " + policyId + " from PAP policy store");
        }
    }
}

