/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap.store;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicySet;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.xacml2.OnlyOneApplicablePolicyAlg;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.PolicyFinderModule;
import org.wso2.balana.finder.PolicyFinderResult;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.collection.DefaultPolicyCollection;

public class PAPPolicyFinder
extends PolicyFinderModule {
    private static final Log log = LogFactory.getLog(PAPPolicyFinder.class);
    private PAPPolicyStoreReader policyReader;
    private DefaultPolicyCollection policies;
    private List<String> policyIds;
    private PolicyFinder policyFinder;
    private int maxInMemoryPolicies = 5;

    public PAPPolicyFinder(PAPPolicyStoreReader policyReader) {
        this.policyReader = policyReader;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        this.policyFinder = finder;
        try {
            OnlyOneApplicablePolicyAlg algorithm = new OnlyOneApplicablePolicyAlg();
            this.initPolicyIds();
            this.policies = new DefaultPolicyCollection((PolicyCombiningAlgorithm)algorithm, 0);
        }
        catch (EntitlementException e) {
            log.error((Object)"Error while initializing PAPPolicyFinder", (Throwable)e);
        }
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        this.policies.getPolicies().clear();
        AbstractPolicy policy = null;
        try {
            AbstractPolicy policyFromStore = this.policyReader.readPolicy(idReference.toString(), this.policyFinder);
            if (policyFromStore != null) {
                if (type == 0) {
                    if (policyFromStore instanceof Policy) {
                        policy = policyFromStore;
                        this.policies.addPolicy(policy);
                    }
                } else if (policyFromStore instanceof PolicySet) {
                    policy = policyFromStore;
                    this.policies.addPolicy(policy);
                }
            }
        }
        catch (EntitlementException e) {
            log.error((Object)e);
        }
        if (policy == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        this.policies.getPolicies().clear();
        ArrayList<AbstractPolicy> list = new ArrayList<AbstractPolicy>();
        try {
            AbstractPolicy policy;
            for (String policyId : this.policyIds) {
                if (list.size() == this.maxInMemoryPolicies) break;
                AbstractPolicy policy2 = null;
                try {
                    policy2 = this.policyReader.readPolicy(policyId, this.policyFinder);
                }
                catch (EntitlementException e) {
                    log.error((Object)e);
                }
                if (policy2 == null) continue;
                this.policies.addPolicy(policy2);
                MatchResult match = policy2.match(context);
                int result = match.getResult();
                if (result == 2) {
                    log.error((Object)match.getStatus().getMessage());
                    throw new EntitlementException(match.getStatus().getMessage());
                }
                if (result != 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matching XACML policy found " + policy2.getId().toString()));
                }
                list.add(policy2);
            }
            if ((policy = this.policies.getEffectivePolicy(list)) == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (EntitlementException e) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, e.getMessage());
            return new PolicyFinderResult(status);
        }
    }

    public void setPolicyIds(List<String> policyIds) {
        this.policyIds = policyIds;
    }

    public void initPolicyIds() throws EntitlementException {
        PolicyDTO[] policyDTOs;
        this.policyIds = new ArrayList<String>();
        for (PolicyDTO dto : policyDTOs = this.policyReader.readAllLightPolicyDTOs()) {
            if (!dto.isActive()) continue;
            this.policyIds.add(dto.getPolicyId());
        }
    }
}

