/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.dto.EntitlementFinderDataHolder;
import org.wso2.carbon.identity.entitlement.dto.EntitlementTreeNodeDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinderModule;

public class EntitlementDataFinder {
    private static Log log = LogFactory.getLog(EntitlementDataFinder.class);
    Set<EntitlementDataFinderModule> dataFinderModules = new HashSet<EntitlementDataFinderModule>();
    int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();

    public EntitlementDataFinder() {
        Map<EntitlementDataFinderModule, Properties> metaDataFinderConfigs = EntitlementServiceComponent.getEntitlementConfig().getPolicyEntitlementDataFinders();
        if (metaDataFinderConfigs != null && !metaDataFinderConfigs.isEmpty()) {
            this.dataFinderModules = metaDataFinderConfigs.keySet();
        }
    }

    public EntitlementFinderDataHolder[] getEntitlementDataModules() {
        ArrayList<EntitlementFinderDataHolder> dataHolders = new ArrayList<EntitlementFinderDataHolder>();
        for (EntitlementDataFinderModule module : this.dataFinderModules) {
            Set<String> supportedCategories;
            Set<String> applicationIds;
            EntitlementFinderDataHolder holder = new EntitlementFinderDataHolder();
            String name = module.getModuleName();
            if (name == null || name.trim().length() == 0) {
                name = module.getClass().getName();
            }
            if ((applicationIds = module.getRelatedApplications()) == null) {
                applicationIds = new HashSet<String>();
            }
            if ((supportedCategories = module.getSupportedCategories()) == null) {
                supportedCategories = new HashSet<String>();
            }
            holder.setName(name);
            holder.setApplicationIds(applicationIds.toArray(new String[applicationIds.size()]));
            holder.setFullPathSupported(module.isFullPathSupported());
            holder.setHierarchicalLevels(module.getSupportedHierarchicalLevels());
            holder.setHierarchicalTree(module.isHierarchicalTree());
            holder.setAllApplicationRelated(module.isAllApplicationRelated());
            holder.setSupportedCategory(supportedCategories.toArray(new String[supportedCategories.size()]));
            holder.setSearchSupported(module.isSearchSupported());
            dataHolders.add(holder);
        }
        return dataHolders.toArray(new EntitlementFinderDataHolder[dataHolders.size()]);
    }

    public EntitlementTreeNodeDTO getEntitlementData(String dataModule, String category, String regex, int level, int limit) {
        for (EntitlementDataFinderModule module : this.dataFinderModules) {
            if (dataModule == null || !dataModule.trim().equalsIgnoreCase(module.getModuleName())) continue;
            try {
                if (level == 0) {
                    return module.getEntitlementData(category, regex, limit);
                }
                return module.getEntitlementDataByLevel(category, level);
            }
            catch (Exception e) {
                log.error((Object)("Error while retrieving entitlement data by " + dataModule), (Throwable)e);
            }
        }
        return new EntitlementTreeNodeDTO();
    }
}

