/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinder;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreManager;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisher;
import org.wso2.carbon.identity.entitlement.policy.store.DefaultPolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManager;
import org.wso2.carbon.identity.entitlement.policy.version.DefaultPolicyVersionManager;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;

public class EntitlementAdminEngine {
    private static final Object lock = new Object();
    private static ConcurrentHashMap<String, EntitlementAdminEngine> entitlementAdminEngines = new ConcurrentHashMap();
    private static Log log = LogFactory.getLog(EntitlementAdminEngine.class);
    private PolicyPublisher policyPublisher;
    private PolicyVersionManager versionManager;
    private EntitlementDataFinder entitlementDataFinder = new EntitlementDataFinder();
    private PolicyDataStore policyDataStore;
    private PolicyStoreManager policyStoreManager;
    private PAPPolicyStoreManager papPolicyStoreManager;
    private Set<PAPStatusDataHandler> papStatusDataHandlers;

    public EntitlementAdminEngine() {
        this.policyPublisher = new PolicyPublisher();
        this.papPolicyStoreManager = new PAPPolicyStoreManager();
        Map<PolicyVersionManager, Properties> versionManagers = EntitlementServiceComponent.getEntitlementConfig().getPolicyVersionModule();
        this.versionManager = versionManagers != null && versionManagers.size() > 0 ? versionManagers.entrySet().iterator().next().getKey() : new DefaultPolicyVersionManager();
        Map<PolicyDataStore, Properties> dataStoreModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyDataStore();
        this.policyDataStore = dataStoreModules != null && dataStoreModules.size() > 0 ? dataStoreModules.entrySet().iterator().next().getKey() : new DefaultPolicyDataStore();
        Map<PAPStatusDataHandler, Properties> statusDataHandlers = EntitlementServiceComponent.getEntitlementConfig().getPapStatusDataHandlers();
        this.papStatusDataHandlers = statusDataHandlers.keySet();
        this.policyPublisher.setPapStatusDataHandlers(this.papStatusDataHandlers);
        this.policyStoreManager = new PolicyStoreManager(this.policyDataStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntitlementAdminEngine getInstance() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (!entitlementAdminEngines.containsKey(Integer.toString(tenantId))) {
            Object object = lock;
            synchronized (object) {
                if (!entitlementAdminEngines.containsKey(Integer.toString(tenantId))) {
                    entitlementAdminEngines.put(Integer.toString(tenantId), new EntitlementAdminEngine());
                }
            }
        }
        return entitlementAdminEngines.get(Integer.toString(tenantId));
    }

    public PolicyPublisher getPolicyPublisher() {
        return this.policyPublisher;
    }

    public PolicyVersionManager getVersionManager() {
        return this.versionManager;
    }

    public EntitlementDataFinder getEntitlementDataFinder() {
        return this.entitlementDataFinder;
    }

    public PolicyDataStore getPolicyDataStore() {
        return this.policyDataStore;
    }

    public PolicyStoreManager getPolicyStoreManager() {
        return this.policyStoreManager;
    }

    public PAPPolicyStoreManager getPapPolicyStoreManager() {
        return this.papPolicyStoreManager;
    }

    public Set<PAPStatusDataHandler> getPapStatusDataHandlers() {
        return this.papStatusDataHandlers;
    }
}

