/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.dto.EntitlementTreeNodeDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinderModule;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;

public class CarbonEntitlementDataFinder
implements EntitlementDataFinderModule {
    private static final String MODULE_NAME = "Carbon Attribute Finder Module";
    private static final String SUBJECT_CATEGORY = "Subject";
    private static final String ACTION_CATEGORY = "Action";
    private static final String RESOURCE_CATEGORY = "Resource";
    private Registry registry;
    private String[] defaultActions = new String[]{"read", "write", "delete", "edit"};

    @Override
    public void init(Properties properties) throws Exception {
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public Set<String> getRelatedApplications() {
        return null;
    }

    @Override
    public Set<String> getSupportedCategories() {
        HashSet<String> set = new HashSet<String>();
        set.add(SUBJECT_CATEGORY);
        set.add(ACTION_CATEGORY);
        set.add(RESOURCE_CATEGORY);
        return set;
    }

    @Override
    public EntitlementTreeNodeDTO getEntitlementData(String category, String regex, int limit) throws Exception {
        this.registry = EntitlementServiceComponent.getRegistryService().getSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (RESOURCE_CATEGORY.equalsIgnoreCase(category)) {
            EntitlementTreeNodeDTO nodeDTO = new EntitlementTreeNodeDTO("/");
            this.getChildResources(nodeDTO, "_system");
            return nodeDTO;
        }
        if (ACTION_CATEGORY.equalsIgnoreCase(category)) {
            EntitlementTreeNodeDTO nodeDTO = new EntitlementTreeNodeDTO("");
            for (String action : this.defaultActions) {
                EntitlementTreeNodeDTO childNode = new EntitlementTreeNodeDTO(action);
                nodeDTO.addChildNode(childNode);
            }
            return nodeDTO;
        }
        if (SUBJECT_CATEGORY.equalsIgnoreCase(category)) {
            String[] roleNames;
            EntitlementTreeNodeDTO nodeDTO = new EntitlementTreeNodeDTO("");
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserStoreManager userStoreManager = EntitlementServiceComponent.getRealmservice().getTenantUserRealm(tenantId).getUserStoreManager();
            for (String roleName : roleNames = ((AbstractUserStoreManager)userStoreManager).getRoleNames(regex, limit, false, true, true)) {
                if ("system/wso2.anonymous.role".equals(roleName)) continue;
                EntitlementTreeNodeDTO childNode = new EntitlementTreeNodeDTO(roleName);
                nodeDTO.addChildNode(childNode);
            }
            return nodeDTO;
        }
        return null;
    }

    @Override
    public EntitlementTreeNodeDTO getEntitlementDataByLevel(String category, int level) throws Exception {
        return null;
    }

    @Override
    public int getSupportedHierarchicalLevels() {
        return 0;
    }

    @Override
    public boolean isFullPathSupported() {
        return true;
    }

    @Override
    public boolean isHierarchicalTree() {
        return true;
    }

    @Override
    public boolean isAllApplicationRelated() {
        return true;
    }

    @Override
    public boolean isSearchSupported() {
        return true;
    }

    private EntitlementTreeNodeDTO getChildResources(EntitlementTreeNodeDTO node, String parentResource) throws RegistryException {
        if (this.registry.resourceExists(parentResource)) {
            String[] resourcePath = parentResource.split("/");
            EntitlementTreeNodeDTO childNode = new EntitlementTreeNodeDTO(resourcePath[resourcePath.length - 1]);
            node.addChildNode(childNode);
            Resource root = this.registry.get(parentResource);
            if (root instanceof Collection) {
                String[] resources;
                Collection collection = (Collection)root;
                for (String resource : resources = collection.getChildren()) {
                    this.getChildResources(childNode, resource);
                }
            }
        }
        return node;
    }
}

