/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.listener;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class CacheClearingUserOperationListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(CacheClearingUserOperationListener.class);

    public int getExecutionOrderId() {
        return 6;
    }

    public boolean doPostDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post delete user operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post set user claim value operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post set user claim values operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostDeleteUserClaimValues(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post delete user claim values operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostDeleteUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post delete user claim value operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post add role operation for role " + roleName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostDeleteRole(String roleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post delete role operation for role " + roleName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostUpdateRoleName(String roleName, String newRoleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post update role operation for role " + roleName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post update user operation for role " + roleName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entitlement cache on post update role operation for user " + userName));
        }
        this.clearCarbonAttributeCache();
        return true;
    }

    private void clearCarbonAttributeCache() {
        CarbonAttributeFinder finder = EntitlementEngine.getInstance().getCarbonAttributeFinder();
        if (finder == null) {
            return;
        }
        finder.clearAttributeCache();
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                pipAttributeFinder.clearCache();
            }
        }
    }
}

