/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementExtensionBuilder;
import org.xml.sax.SAXException;

public class SchemaBuilder
implements Runnable {
    private static Log log = LogFactory.getLog(SchemaBuilder.class);
    private EntitlementConfigHolder configHolder;

    public SchemaBuilder(EntitlementConfigHolder configHolder) {
        this.configHolder = configHolder;
    }

    @Override
    public void run() {
        try {
            this.buildPolicySchema();
            log.info((Object)"XACML policy schema loaded successfully.");
        }
        catch (Exception e) {
            this.configHolder.getEngineProperties().setProperty("PDP.SchemaValidation.Enable", "false");
            log.warn((Object)"Error while loading policy schema. Schema validation will be disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPolicySchema() throws SAXException {
        String[] schemaNSs;
        if (!"true".equalsIgnoreCase((String)this.configHolder.getEngineProperties().get("PDP.SchemaValidation.Enable"))) {
            log.warn((Object)"PDP schema validation disabled.");
            return;
        }
        for (String schemaNS : schemaNSs = new String[]{"urn:oasis:names:tc:xacml:1.0:policy", "urn:oasis:names:tc:xacml:2.0:policy:schema:os", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17"}) {
            String schemaFile = "urn:oasis:names:tc:xacml:1.0:policy".equals(schemaNS) ? "xacml1.xsd" : ("urn:oasis:names:tc:xacml:2.0:policy:schema:os".equals(schemaNS) ? "xacml2.xsd" : "xacml3.xsd");
            InputStream schemaFileStream = EntitlementExtensionBuilder.class.getResourceAsStream("/" + schemaFile);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(new StreamSource(schemaFileStream));
                this.configHolder.getPolicySchemaMap().put(schemaNS, schema);
            }
            finally {
                IdentityIOStreamUtils.closeInputStream((InputStream)schemaFileStream);
            }
        }
    }
}

