/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementService;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementExtensionBuilder;
import org.wso2.carbon.identity.entitlement.internal.SchemaBuilder;
import org.wso2.carbon.identity.entitlement.listener.CacheClearingUserOperationListener;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementService;
import org.wso2.carbon.identity.entitlement.thrift.ThriftEntitlementServiceImpl;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

@Component(name="identity.entitlement.component", immediate=true)
public class EntitlementServiceComponent {
    public static final String PDP_CONFIG_FILE_PATH = "org.wso2.balana.PDPConfigFile";
    private static final String ENHANCED_XACML_LOADING_SYSTEM_PROPERTY = "enableEnhancedXACMLLoading";
    private static final Log log = LogFactory.getLog(EntitlementServiceComponent.class);
    private static RegistryService registryService = null;
    private static RealmService realmservice;
    private static NotificationSender notificationSender;
    private ThriftAuthenticatorService thriftAuthenticationService;
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    public static EntitlementConfigHolder getEntitlementConfig() {
        return EntitlementConfigHolder.getInstance();
    }

    public static RealmService getRealmservice() {
        return realmservice;
    }

    public static void setRealmservice(RealmService realmservice) {
        EntitlementServiceComponent.realmservice = realmservice;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Entitlement bundle");
        }
        EntitlementServiceComponent.registryService = registryService;
    }

    public static Registry getGovernanceRegistry(int tenantId) {
        try {
            return registryService.getGovernanceSystemRegistry(tenantId);
        }
        catch (RegistryException registryException) {
            return null;
        }
    }

    public static NotificationSender getNotificationSender() {
        return notificationSender;
    }

    @Reference(name="carbon.identity.notification.mgt", service=NotificationSender.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetNotificationSender")
    protected void setNotificationSender(NotificationSender notificationSender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting notification sender in Entitlement bundle");
        }
        EntitlementServiceComponent.notificationSender = notificationSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Entitlement bundle is activated");
        }
        try {
            EntitlementExtensionBuilder builder = new EntitlementExtensionBuilder();
            builder.setBundleContext(ctxt.getBundleContext());
            builder.buildEntitlementConfig(EntitlementConfigHolder.getInstance());
            boolean balanaConfig = Boolean.parseBoolean((String)EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().get("PDP.Balana.Config.Enable"));
            String configProperty = System.getProperty(PDP_CONFIG_FILE_PATH);
            if (balanaConfig && configProperty == null) {
                String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "security" + File.separator + "balana-config.xml";
                System.setProperty(PDP_CONFIG_FILE_PATH, configFilePath);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting org.wso2.balana.PDPConfigFile property to " + System.getProperty(PDP_CONFIG_FILE_PATH)));
            }
            new Thread(new SchemaBuilder(EntitlementConfigHolder.getInstance())).start();
            PAPPolicyStore papPolicyStore = new PAPPolicyStore((Registry)registryService.getGovernanceSystemRegistry());
            String startUpPolicyAdding = EntitlementConfigHolder.getInstance().getEngineProperties().getProperty("PAP.Policy.Add.Start.Enable");
            ArrayList<String> policyIdList = new ArrayList();
            if (papPolicyStore != null && ArrayUtils.isNotEmpty((Object[])papPolicyStore.getAllPolicyIds())) {
                String[] allPolicyIds = papPolicyStore.getAllPolicyIds();
                policyIdList = Arrays.asList(allPolicyIds);
            }
            if (startUpPolicyAdding != null && Boolean.parseBoolean(startUpPolicyAdding)) {
                Object[] fileList;
                File policyFolder = null;
                String policyPathFromConfig = EntitlementConfigHolder.getInstance().getEngineProperties().getProperty("PAP.Policy.Add.Start.Policy.File.Path");
                if (StringUtils.isNotBlank((String)policyPathFromConfig)) {
                    policyFolder = new File(policyPathFromConfig);
                }
                if (policyFolder != null && !policyFolder.exists()) {
                    log.warn((Object)"Defined policy directory location is not exit. Therefore using default policy location");
                }
                if (policyPathFromConfig == null || policyFolder != null && !policyFolder.exists()) {
                    policyFolder = new File(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "identity" + File.separator + "policies" + File.separator + "xacml");
                }
                boolean customPolicies = false;
                if (policyFolder != null && policyFolder.exists() && ArrayUtils.isNotEmpty((Object[])(fileList = policyFolder.listFiles()))) {
                    if (Boolean.parseBoolean(System.getProperty(ENHANCED_XACML_LOADING_SYSTEM_PROPERTY))) {
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                            carbonContext.setTenantId(-1234);
                            carbonContext.setTenantDomain("carbon.super");
                            long startTime = System.currentTimeMillis();
                            customPolicies = this.addPolicyFiles(policyIdList, (File[])fileList);
                            long endTime = (System.currentTimeMillis() - startTime) / 1000L;
                            log.info((Object)("XACML Policies loaded in " + endTime + " sec"));
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    } else {
                        customPolicies = this.addPolicyFiles(policyIdList, (File[])fileList);
                    }
                }
                if (!customPolicies) {
                    EntitlementUtil.addSamplePolicies((Registry)registryService.getGovernanceSystemRegistry());
                }
            }
            CacheClearingUserOperationListener pipUserOperationListener = new CacheClearingUserOperationListener();
            ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)pipUserOperationListener, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registering notification sender on user operations");
            }
            ThriftEntitlementServiceImpl.init(this.thriftAuthenticationService);
            this.startThriftServices();
            EntitlementService entitlementService = new EntitlementService();
            ctxt.getBundleContext().registerService(EntitlementService.class.getName(), (Object)entitlementService, null);
        }
        catch (Throwable throwable) {
            log.error((Object)"Failed to initialize Entitlement Service", throwable);
        }
    }

    private boolean addPolicyFiles(List<String> policyIdList, File[] fileList) throws IOException {
        boolean customPolicies = false;
        for (File policyFile : fileList) {
            if (!policyFile.isFile()) continue;
            PolicyDTO policyDTO = new PolicyDTO();
            policyDTO.setPolicy(FileUtils.readFileToString((File)policyFile));
            if (!policyIdList.contains(policyDTO.getPolicyId())) {
                try {
                    EntitlementUtil.addFilesystemPolicy(policyDTO, (Registry)registryService.getGovernanceSystemRegistry(), true);
                }
                catch (Exception e) {
                    log.error((Object)"Error while adding XACML policies", (Throwable)e);
                }
            }
            customPolicies = true;
        }
        return customPolicies;
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Entitlement bundle is deactivated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Entitlement bundle");
        }
        EntitlementServiceComponent.registryService = null;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm set in Entitlement bundle");
        }
        realmservice = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm unset in Entitlement bundle");
        }
        realmservice = null;
    }

    @Reference(name="org.wso2.carbon.identity.thrift.authentication.internal.ThriftAuthenticationServiceComponent", service=ThriftAuthenticatorService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetThriftAuthenticationService")
    protected void setThriftAuthenticationService(ThriftAuthenticatorService authenticationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ThriftAuthenticatorService set in Entitlement bundle");
        }
        this.thriftAuthenticationService = authenticationService;
    }

    protected void unsetThriftAuthenticationService(ThriftAuthenticatorService authenticationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ThriftAuthenticatorService unset in Entitlement bundle");
        }
        this.thriftAuthenticationService = null;
    }

    private void startThriftServices() throws Exception {
        this.startThriftEntitlementService();
    }

    private void startThriftEntitlementService() throws Exception {
        try {
            IdentityUtil.populateProperties();
            String thriftEnabled = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.EnableThriftService");
            if (thriftEnabled != null && Boolean.parseBoolean(thriftEnabled)) {
                TSSLTransportFactory.TSSLTransportParameters transportParam = new TSSLTransportFactory.TSSLTransportParameters();
                String keystorePath = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.KeyStore.Location");
                String keystorePassword = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.KeyStore.Password");
                transportParam.setKeyStore(keystorePath, keystorePassword);
                int receivePort = this.readThriftReceivePort();
                int clientTimeOut = Integer.parseInt(IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.ClientTimeout"));
                TServerSocket serverTransport = TSSLTransportFactory.getServerSocket((int)receivePort, (int)clientTimeOut, (InetAddress)this.getHostAddress(this.readThriftHostName()), (TSSLTransportFactory.TSSLTransportParameters)transportParam);
                EntitlementService.Processor<ThriftEntitlementServiceImpl> processor = new EntitlementService.Processor<ThriftEntitlementServiceImpl>(new ThriftEntitlementServiceImpl());
                TThreadPoolServer server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(processor));
                ServerRunnable serverThread = new ServerRunnable((TServer)server);
                this.executor.submit(serverThread);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Started thrift entitlement service at port:" + receivePort));
                }
            }
        }
        catch (TTransportException e) {
            String transportErrorMsg = "Error in initializing thrift transport";
            log.error((Object)transportErrorMsg, (Throwable)e);
            throw new Exception(transportErrorMsg);
        }
        catch (UnknownHostException e) {
            String hostErrorMsg = "Error in obtaining host name";
            log.error((Object)hostErrorMsg, (Throwable)e);
            throw new Exception(hostErrorMsg);
        }
    }

    private int readThriftReceivePort() {
        int port = -1;
        String portValue = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.ReceivePort");
        port = portValue.contains("${") && portValue.contains("}") ? CarbonUtils.getPortFromServerConfig((String)portValue) : Integer.parseInt(portValue);
        return port;
    }

    private InetAddress getHostAddress(String host) throws UnknownHostException {
        String[] splittedString = host.split("\\.");
        if (splittedString.length == 4) {
            try {
                Integer.parseInt(splittedString[0]);
                Integer.parseInt(splittedString[1]);
                Integer.parseInt(splittedString[2]);
                Integer.parseInt(splittedString[3]);
                byte[] byteAddress = new byte[4];
                for (int i = 0; i < splittedString.length; ++i) {
                    byteAddress[i] = Integer.parseInt(splittedString[i]) > 127 ? Integer.valueOf(Integer.parseInt(splittedString[i]) - 256).byteValue() : Byte.parseByte(splittedString[i]);
                }
                return InetAddress.getByAddress(byteAddress);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return InetAddress.getByName(host);
    }

    private String readThriftHostName() throws SocketException {
        String thriftHostName = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.ThriftHostName");
        if (thriftHostName != null) {
            return thriftHostName;
        }
        return NetworkUtils.getLocalHostname();
    }

    protected void unsetNotificationSender(NotificationSender notificationSender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting notification sender in Entitlement bundle");
        }
        EntitlementServiceComponent.notificationSender = null;
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configCtxtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService set in EntitlementServiceComponent bundle.");
        }
        EntitlementConfigHolder.getInstance().setConfigurationContextService(configCtxtService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unset in EntitlementServiceComponent bundle.");
        }
        EntitlementConfigHolder.getInstance().setConfigurationContextService(null);
    }

    private static class ServerRunnable
    implements Runnable {
        TServer server;

        public ServerRunnable(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

