/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinderModule;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.collection.PolicyCollection;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PostPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PublisherVerificationModule;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManageModule;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;

public class EntitlementExtensionBuilder {
    public static final String PDP_SCHEMA_VALIDATION = "PDP.SchemaValidation.Enable";
    private static final String ENTITLEMENT_CONFIG = "entitlement.properties";
    private static final Log log = LogFactory.getLog(EntitlementExtensionBuilder.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void buildEntitlementConfig(EntitlementConfigHolder holder) throws Exception {
        Properties properties = this.loadProperties();
        if (properties != null) {
            this.populateEntitlementAttributes(properties, holder);
            this.populatePDPExtensions(properties, holder);
            this.populateAttributeFinders(properties, holder);
            this.populateEntitlementDataFinders(properties, holder);
            this.populateResourceFinders(properties, holder);
            this.populatePolicyPublishers(properties, holder);
            this.populatePolicyFinders(properties, holder);
            this.populatePolicyCollection(properties, holder);
            this.populatePolicyStoreModule(properties, holder);
            this.populatePolicyDataStore(properties, holder);
            this.populatePolicyVersionModule(properties, holder);
            this.populatePolicyPostPublishers(properties, holder);
            this.populateAdminNotificationHandlers(properties, holder);
            this.populatePublisherVerificationHandler(properties, holder);
        }
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        InputStream inStream = null;
        String warningMessage = null;
        File pipConfigXml = new File(IdentityUtil.getIdentityConfigDirPath(), ENTITLEMENT_CONFIG);
        try {
            URL url;
            if (pipConfigXml.exists()) {
                inStream = new FileInputStream(pipConfigXml);
            } else if (this.bundleContext != null) {
                url = this.bundleContext.getBundle().getResource(ENTITLEMENT_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource entitlement.properties or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(ENTITLEMENT_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "PIP Config Builder could not find resource entitlement.properties or user does not have sufficient permission to access the resource.";
                }
            }
            if (inStream == null) {
                log.warn(warningMessage);
                url = null;
                return url;
            }
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw e;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while closing input stream ", (Throwable)e);
            }
        }
        return properties;
    }

    private void populateEntitlementAttributes(Properties properties, EntitlementConfigHolder holder) {
        Properties pdpProperties = new Properties();
        this.setProperty(properties, pdpProperties, "PDP.OnDemangPolicyLoading.Enable");
        this.setProperty(properties, pdpProperties, "PDP.OnDemangPolicyLoading.MaxInMemoryPolicies");
        this.setProperty(properties, pdpProperties, "PDP.DecisionCaching.Enable");
        this.setProperty(properties, pdpProperties, "PDP.DecisionCaching.CachingInterval");
        this.setProperty(properties, pdpProperties, "PDP.AttributeCaching.Enable");
        this.setProperty(properties, pdpProperties, "PDP.AttributeCaching.CachingInterval");
        this.setProperty(properties, pdpProperties, "PDP.ResourceCaching.Enable");
        this.setProperty(properties, pdpProperties, "PDP.DecisionCaching.CachingInterval");
        this.setProperty(properties, pdpProperties, "PDP.Enable");
        this.setProperty(properties, pdpProperties, "PAP.Enable");
        this.setProperty(properties, pdpProperties, "PDP.Balana.Config.Enable");
        this.setProperty(properties, pdpProperties, "PDP.Multiple.Decision.Profile.Enable");
        this.setProperty(properties, pdpProperties, "PDP.References.MaxPolicyEntries");
        this.setProperty(properties, pdpProperties, "PAP.Policy.Add.Start.Policy.File.Path");
        this.setProperty(properties, pdpProperties, "PAP.Policy.Id.Regexp.Pattern");
        this.setProperty(properties, pdpProperties, "PDP.Global.Policy.Combining.Algorithm");
        this.setProperty(properties, pdpProperties, "PAP.Items.Per.Page");
        this.setProperty(properties, pdpProperties, "PAP.Policy.Add.Start.Enable");
        this.setProperty(properties, pdpProperties, PDP_SCHEMA_VALIDATION);
        this.setProperty(properties, pdpProperties, "Entitlement.Engine.CachingInterval");
        this.setProperty(properties, pdpProperties, "PDP.Registry.Level.Policy.Cache.Clear");
        this.setProperty(properties, pdpProperties, "PDP.PolicyCaching.CachingInterval");
        this.setProperty(properties, pdpProperties, "JSON.Shorten.Form.Enabled");
        holder.setEngineProperties(pdpProperties);
    }

    private void setProperty(Properties inProp, Properties outProp, String name) {
        String value = inProp.getProperty(name);
        if (value != null) {
            outProp.setProperty(name, value.trim());
        }
    }

    private void populateAttributeFinders(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PIPAttributeFinder designator = null;
        while (properties.getProperty("PIP.AttributeDesignators.Designator." + i) != null) {
            String className = properties.getProperty("PIP.AttributeDesignators.Designator." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            designator = (PIPAttributeFinder)clazz.newInstance();
            int j = 1;
            Properties designatorProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                designatorProps.put(props[0], props[1]);
            }
            designator.init(designatorProps);
            holder.addDesignators(designator, designatorProps);
        }
    }

    private void populateResourceFinders(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PIPResourceFinder resource = null;
        while (properties.getProperty("PIP.ResourceFinders.Finder." + i) != null) {
            String className = properties.getProperty("PIP.ResourceFinders.Finder." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            resource = (PIPResourceFinder)clazz.newInstance();
            int j = 1;
            Properties resourceProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                resourceProps.put(props[0], props[1]);
            }
            resource.init(resourceProps);
            holder.addResourceFinders(resource, resourceProps);
        }
    }

    private void populatePDPExtensions(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PIPExtension extension = null;
        while (properties.getProperty("PDP.Extensions.Extension." + i) != null) {
            String className = properties.getProperty("PDP.Extensions.Extension." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            extension = (PIPExtension)clazz.newInstance();
            int j = 1;
            Properties extensionProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                extensionProps.put(props[0], props[1]);
            }
            extension.init(extensionProps);
            holder.addExtensions(extension, extensionProps);
        }
    }

    private void populatePolicyFinders(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PolicyFinderModule finderModule = null;
        while (properties.getProperty("PDP.Policy.Finder." + i) != null) {
            String className = properties.getProperty("PDP.Policy.Finder." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            finderModule = (PolicyFinderModule)clazz.newInstance();
            int j = 1;
            Properties finderModuleProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                finderModuleProps.put(props[0], props[1]);
            }
            finderModule.init(finderModuleProps);
            if (finderModule instanceof PolicyStoreManageModule) {
                holder.addPolicyStore((PolicyStoreManageModule)finderModule, finderModuleProps);
            }
            holder.addPolicyFinderModule(finderModule, finderModuleProps);
        }
    }

    private void populatePolicyCollection(Properties properties, EntitlementConfigHolder holder) throws Exception {
        PolicyCollection collection = null;
        if (properties.getProperty("PDP.Policy.Collection") != null) {
            String className = properties.getProperty("PDP.Policy.Collection");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            collection = (PolicyCollection)clazz.newInstance();
            int j = 1;
            Properties collectionProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                collectionProps.put(props[0], props[1]);
            }
            collection.init(collectionProps);
            holder.addPolicyCollection(collection, collectionProps);
        }
    }

    private void populatePolicyStoreModule(Properties properties, EntitlementConfigHolder holder) throws Exception {
        PolicyStoreManageModule policyStoreStore = null;
        if (properties.getProperty("PDP.Policy.Store.Module") != null) {
            String className = properties.getProperty("PDP.Policy.Store.Module");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            policyStoreStore = (PolicyStoreManageModule)clazz.newInstance();
            int j = 1;
            Properties storeProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                storeProps.put(props[0], props[1]);
            }
            policyStoreStore.init(storeProps);
            holder.addPolicyStore(policyStoreStore, storeProps);
        }
    }

    private void populatePolicyDataStore(Properties properties, EntitlementConfigHolder holder) throws Exception {
        PolicyDataStore policyDataStore = null;
        if (properties.getProperty("PDP.Policy.Data.Store.Module") != null) {
            String className = properties.getProperty("PDP.Policy.Data.Store.Module");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            policyDataStore = (PolicyDataStore)clazz.newInstance();
            int j = 1;
            Properties storeProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                storeProps.put(props[0], props[1]);
            }
            policyDataStore.init(storeProps);
            holder.addPolicyDataStore(policyDataStore, storeProps);
        }
    }

    private void populateEntitlementDataFinders(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        EntitlementDataFinderModule metadata = null;
        while (properties.getProperty("PAP.Entitlement.Data.Finder." + i) != null) {
            String className = properties.getProperty("PAP.Entitlement.Data.Finder." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            metadata = (EntitlementDataFinderModule)clazz.newInstance();
            int j = 1;
            Properties metadataProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String value = properties.getProperty(className + "." + j++);
                metadataProps.put(value.substring(0, value.indexOf(",")), value.substring(value.indexOf(",") + 1));
            }
            metadata.init(metadataProps);
            holder.addPolicyEntitlementDataFinder(metadata, metadataProps);
        }
    }

    private void populatePolicyPublishers(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PolicyPublisherModule publisher = null;
        while (properties.getProperty("PAP.Policy.Publisher.Module." + i) != null) {
            String className = properties.getProperty("PAP.Policy.Publisher.Module." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            publisher = (PolicyPublisherModule)clazz.newInstance();
            int j = 1;
            Properties publisherProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                publisherProps.put(props[0], props[1]);
            }
            publisher.init(publisherProps);
            holder.addPolicyPublisherModule(publisher, publisherProps);
        }
    }

    private void populatePolicyVersionModule(Properties properties, EntitlementConfigHolder holder) throws Exception {
        PolicyVersionManager versionManager = null;
        if (properties.getProperty("PAP.Policy.Version.Module") != null) {
            String className = properties.getProperty("PAP.Policy.Version.Module");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            versionManager = (PolicyVersionManager)clazz.newInstance();
            int j = 1;
            Properties storeProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                storeProps.put(props[0], props[1]);
            }
            versionManager.init(storeProps);
            holder.addPolicyVersionModule(versionManager, storeProps);
        }
    }

    private void populatePolicyPostPublishers(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PostPublisherModule postPublisherModule = null;
        while (properties.getProperty("PAP.Policy.Post.Publisher.Module." + i) != null) {
            String className = properties.getProperty("PAP.Policy.Post.Publisher.Module." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            postPublisherModule = (PostPublisherModule)clazz.newInstance();
            int j = 1;
            Properties publisherProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                publisherProps.put(props[0], props[1]);
            }
            postPublisherModule.init(publisherProps);
            holder.addPolicyPostPublisherModule(postPublisherModule, publisherProps);
        }
    }

    private void populatePublisherVerificationHandler(Properties properties, EntitlementConfigHolder holder) throws Exception {
        PublisherVerificationModule verificationModule = null;
        if (properties.getProperty("PAP.Policy.Publisher.Verification.Handler") != null) {
            String className = properties.getProperty("PAP.Policy.Publisher.Verification.Handler");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            verificationModule = (PublisherVerificationModule)clazz.newInstance();
            int j = 1;
            Properties storeProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                storeProps.put(props[0], props[1]);
            }
            verificationModule.init(storeProps);
            holder.addPublisherVerificationModule(verificationModule, storeProps);
        }
    }

    private void populateAdminNotificationHandlers(Properties properties, EntitlementConfigHolder holder) throws Exception {
        int i = 1;
        PAPStatusDataHandler handler = null;
        while (properties.getProperty("PAP.Status.Data.Handler." + i) != null) {
            String className = properties.getProperty("PAP.Status.Data.Handler." + i++);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            handler = (PAPStatusDataHandler)clazz.newInstance();
            int j = 1;
            Properties publisherProps = new Properties();
            while (properties.getProperty(className + "." + j) != null) {
                String[] props = properties.getProperty(className + "." + j++).split(",");
                publisherProps.put(props[0], props[1]);
            }
            handler.init(publisherProps);
            holder.addNotificationHandler(handler, publisherProps);
        }
    }
}

