/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.validation.Schema;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinderModule;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.collection.PolicyCollection;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PostPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PublisherVerificationModule;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManageModule;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;
import org.wso2.carbon.utils.ConfigurationContextService;

public class EntitlementConfigHolder {
    private Map<PIPExtension, Properties> extensions = new HashMap<PIPExtension, Properties>();
    private Map<PIPAttributeFinder, Properties> designators = new HashMap<PIPAttributeFinder, Properties>();
    private Map<PIPResourceFinder, Properties> resourceFinders = new HashMap<PIPResourceFinder, Properties>();
    private Map<EntitlementDataFinderModule, Properties> policyEntitlementDataFinders = new HashMap<EntitlementDataFinderModule, Properties>();
    private Map<PolicyPublisherModule, Properties> policyPublisherModules = new HashMap<PolicyPublisherModule, Properties>();
    private Map<PostPublisherModule, Properties> policyPostPublisherModules = new HashMap<PostPublisherModule, Properties>();
    private Map<PublisherVerificationModule, Properties> publisherVerificationModule = new HashMap<PublisherVerificationModule, Properties>();
    private Map<PolicyFinderModule, Properties> policyFinderModules = new HashMap<PolicyFinderModule, Properties>();
    private Map<PolicyCollection, Properties> policyCollections = new HashMap<PolicyCollection, Properties>();
    private Map<PAPStatusDataHandler, Properties> papStatusDataHandlers = new HashMap<PAPStatusDataHandler, Properties>();
    private Map<PolicyStoreManageModule, Properties> policyStore = new HashMap<PolicyStoreManageModule, Properties>();
    private Map<PolicyDataStore, Properties> policyDataStore = new HashMap<PolicyDataStore, Properties>();
    private Map<PolicyVersionManager, Properties> policyVersionModule = new HashMap<PolicyVersionManager, Properties>();
    private Map<String, Schema> policySchemaMap = new HashMap<String, Schema>();
    private Properties engineProperties;
    private Map<String, List<PublisherDataHolder>> modulePropertyHolderMap = new HashMap<String, List<PublisherDataHolder>>();
    private ConfigurationContextService configurationContextService;
    private static EntitlementConfigHolder instance = new EntitlementConfigHolder();

    private EntitlementConfigHolder() {
    }

    public static EntitlementConfigHolder getInstance() {
        return instance;
    }

    public Map<PIPExtension, Properties> getExtensions() {
        return this.extensions;
    }

    public void addExtensions(PIPExtension extension, Properties properties) {
        this.extensions.put(extension, properties);
    }

    public Map<PIPAttributeFinder, Properties> getDesignators() {
        return this.designators;
    }

    public void addDesignators(PIPAttributeFinder attributeFinder, Properties properties) {
        this.designators.put(attributeFinder, properties);
    }

    public Map<PIPResourceFinder, Properties> getResourceFinders() {
        return this.resourceFinders;
    }

    public void addResourceFinders(PIPResourceFinder resourceFinder, Properties properties) {
        this.resourceFinders.put(resourceFinder, properties);
    }

    public Map<EntitlementDataFinderModule, Properties> getPolicyEntitlementDataFinders() {
        return this.policyEntitlementDataFinders;
    }

    public void addPolicyEntitlementDataFinder(EntitlementDataFinderModule metaDataFinderModule, Properties properties) {
        this.policyEntitlementDataFinders.put(metaDataFinderModule, properties);
    }

    public Properties getEngineProperties() {
        return this.engineProperties;
    }

    public void setEngineProperties(Properties engineProperties) {
        this.engineProperties = engineProperties;
    }

    public Map<String, Schema> getPolicySchemaMap() {
        return this.policySchemaMap;
    }

    public void setPolicySchema(String schemaNS, Schema schema) {
        this.policySchemaMap.put(schemaNS, schema);
    }

    public Map<PolicyPublisherModule, Properties> getPolicyPublisherModules() {
        return this.policyPublisherModules;
    }

    public void addPolicyPublisherModule(PolicyPublisherModule policyPublisherModules, Properties properties) {
        this.policyPublisherModules.put(policyPublisherModules, properties);
    }

    public List<PublisherDataHolder> getModulePropertyHolders(String type) {
        return this.modulePropertyHolderMap.get(type);
    }

    public void addModulePropertyHolder(String type, PublisherDataHolder holder) {
        if (this.modulePropertyHolderMap.get(type) == null) {
            ArrayList<PublisherDataHolder> holders = new ArrayList<PublisherDataHolder>();
            holders.add(holder);
            this.modulePropertyHolderMap.put(type, holders);
        } else {
            this.modulePropertyHolderMap.get(type).add(holder);
        }
    }

    public Map<PolicyFinderModule, Properties> getPolicyFinderModules() {
        return this.policyFinderModules;
    }

    public void addPolicyFinderModule(PolicyFinderModule policyFinderModule, Properties properties) {
        this.policyFinderModules.put(policyFinderModule, properties);
    }

    public Map<PolicyCollection, Properties> getPolicyCollections() {
        return this.policyCollections;
    }

    public void addPolicyCollection(PolicyCollection collection, Properties properties) {
        this.policyCollections.put(collection, properties);
    }

    public Map<PolicyStoreManageModule, Properties> getPolicyStore() {
        return this.policyStore;
    }

    public void addPolicyStore(PolicyStoreManageModule policyStoreStore, Properties properties) {
        this.policyStore.put(policyStoreStore, properties);
    }

    public Map<PostPublisherModule, Properties> getPolicyPostPublisherModules() {
        return this.policyPostPublisherModules;
    }

    public void addPolicyPostPublisherModule(PostPublisherModule postPublisherModule, Properties properties) {
        this.policyPostPublisherModules.put(postPublisherModule, properties);
    }

    public Map<PublisherVerificationModule, Properties> getPublisherVerificationModule() {
        return this.publisherVerificationModule;
    }

    public void addPublisherVerificationModule(PublisherVerificationModule publisherVerificationModule, Properties properties) {
        this.publisherVerificationModule.put(publisherVerificationModule, properties);
    }

    public Map<PAPStatusDataHandler, Properties> getPapStatusDataHandlers() {
        return this.papStatusDataHandlers;
    }

    public void addNotificationHandler(PAPStatusDataHandler notificationHandler, Properties properties) {
        this.papStatusDataHandlers.put(notificationHandler, properties);
    }

    public Map<PolicyVersionManager, Properties> getPolicyVersionModule() {
        return this.policyVersionModule;
    }

    public void addPolicyVersionModule(PolicyVersionManager policyVersionModule, Properties properties) {
        this.policyVersionModule.put(policyVersionModule, properties);
    }

    public Map<PolicyDataStore, Properties> getPolicyDataStore() {
        return this.policyDataStore;
    }

    public void addPolicyDataStore(PolicyDataStore policyDataStore, Properties properties) {
        this.policyDataStore.put(policyDataStore, properties);
    }

    public ConfigurationContextService getConfigurationContextService() {
        return this.configurationContextService;
    }

    public void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContextService = configurationContextService;
    }
}

