/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.extension;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.user.core.UserStoreException;

public class EvalPermissionTreeFunction
extends FunctionBase {
    public static final String SUBJECT_HAS_PERMISSION = "urn:oasis:names:tc:xacml:1.0:function:eval-permission-tree";
    private static final int ID_EVAL_PERMISSION_TREE = 0;
    private static final Log log = LogFactory.getLog(EvalPermissionTreeFunction.class);

    public EvalPermissionTreeFunction() {
        super(SUBJECT_HAS_PERMISSION, 0, "http://www.w3.org/2001/XMLSchema#string", false, 2, 2, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(SUBJECT_HAS_PERMISSION);
        return set;
    }

    public EvaluationResult evaluate(List<Evaluatable> inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                String resource = ((StringAttribute)argValues[0]).getValue().trim();
                String subject = ((StringAttribute)argValues[1]).getValue().trim();
                boolean isAuthorised = false;
                try {
                    isAuthorised = EntitlementServiceComponent.getRealmservice().getBootstrapRealm().getAuthorizationManager().isUserAuthorized(subject, resource, "ui.execute");
                }
                catch (UserStoreException e) {
                    log.error((Object)("Error while authorising" + subject + " to perform ui.execute on " + resource), (Throwable)e);
                }
                result = new EvaluationResult((AttributeValue)BooleanAttribute.getInstance((boolean)isAuthorised));
            }
        }
        return result;
    }
}

