/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.entitlement.dto.PublisherPropertyDTO;
import org.wso2.carbon.registry.core.Resource;

public class PublisherDataHolder {
    public static final String MODULE_NAME = "EntitlementModuleName";
    private static Log log = LogFactory.getLog(PublisherDataHolder.class);
    private String moduleName;
    private PublisherPropertyDTO[] propertyDTOs = new PublisherPropertyDTO[0];

    public PublisherDataHolder() {
    }

    public PublisherDataHolder(String moduleName) {
        this.moduleName = moduleName;
    }

    public PublisherDataHolder(Resource resource, boolean returnSecrets) {
        ArrayList<PublisherPropertyDTO> propertyDTOs = new ArrayList<PublisherPropertyDTO>();
        if (resource != null && resource.getProperties() != null) {
            Properties properties = resource.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ArrayList list;
                PublisherPropertyDTO dto = new PublisherPropertyDTO();
                dto.setId((String)entry.getKey());
                Object value = entry.getValue();
                if (value instanceof ArrayList && (list = (ArrayList)entry.getValue()) != null && list.size() > 0 && list.get(0) != null) {
                    dto.setValue((String)list.get(0));
                    if (list.size() > 1 && list.get(1) != null) {
                        dto.setDisplayName((String)list.get(1));
                    }
                    if (list.size() > 2 && list.get(2) != null) {
                        dto.setDisplayOrder(Integer.parseInt((String)list.get(2)));
                    }
                    if (list.size() > 3 && list.get(3) != null) {
                        dto.setRequired(Boolean.parseBoolean((String)list.get(3)));
                    }
                    if (list.size() > 4 && list.get(4) != null) {
                        dto.setSecret(Boolean.parseBoolean((String)list.get(4)));
                    }
                    if (dto.isSecret() && returnSecrets) {
                        String password = dto.getValue();
                        try {
                            password = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(dto.getValue()));
                        }
                        catch (CryptoException e) {
                            log.error((Object)e);
                        }
                        dto.setValue(password);
                    }
                }
                if (MODULE_NAME.equals(dto.getId())) {
                    this.moduleName = dto.getValue();
                    continue;
                }
                propertyDTOs.add(dto);
            }
        }
        this.propertyDTOs = propertyDTOs.toArray(new PublisherPropertyDTO[propertyDTOs.size()]);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public PublisherPropertyDTO[] getPropertyDTOs() {
        return Arrays.copyOf(this.propertyDTOs, this.propertyDTOs.length);
    }

    public void setPropertyDTOs(PublisherPropertyDTO[] propertyDTOs) {
        this.propertyDTOs = Arrays.copyOf(propertyDTOs, propertyDTOs.length);
    }

    public PublisherPropertyDTO getPropertyDTO(String id) {
        for (PublisherPropertyDTO dto : this.propertyDTOs) {
            if (!dto.getId().equalsIgnoreCase(id)) continue;
            return dto;
        }
        return null;
    }
}

