/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.entitlement.cache.EntitlementBaseCache;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.policy.search.PolicySearchCacheInvalidationClusteringMessage;
import org.wso2.carbon.identity.entitlement.policy.search.SearchResult;

public class PolicySearchCache
extends EntitlementBaseCache<IdentityCacheKey, SearchResult> {
    private static final Log log = LogFactory.getLog(PolicySearchCache.class);

    public PolicySearchCache(int timeOut) {
        super("$__local__$.POLICY_SEARCH_CACHE", timeOut);
    }

    @Override
    public void addToCache(String key, SearchResult result) {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        IdentityCacheKey cacheKey = new IdentityCacheKey(tenantId, key);
        this.addToCache(cacheKey, result);
    }

    public SearchResult getFromCache(String key) {
        SearchResult searchResult = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        IdentityCacheKey cacheKey = new IdentityCacheKey(tenantId, key);
        Object entry = this.getValueFromCache(cacheKey);
        if (entry != null) {
            searchResult = (SearchResult)entry;
        }
        return searchResult;
    }

    public void clearCache() {
        this.clear();
    }

    public void invalidateCache() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger invalidate policy search cache to tenant :  " + IdentityTenantUtil.getTenantDomain((int)tenantId)));
        }
        this.clearCache();
        if (this.isClusteringEnabled()) {
            this.sendClusterMessage(new PolicySearchCacheInvalidationClusteringMessage(tenantId), true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Clustering not enabled. Not sending cluster message to other nodes.");
        }
    }

    private void sendClusterMessage(ClusteringMessage clusterMessage, boolean isSync) {
        try {
            ClusteringAgent clusteringAgent;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sending cluster message to all other nodes");
            }
            if ((clusteringAgent = EntitlementConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent()) != null) {
                clusteringAgent.sendMessage(clusterMessage, isSync);
            } else {
                log.error((Object)"Clustering Agent not available.");
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Error while sending cluster message", (Throwable)clusteringFault);
        }
    }

    private boolean isClusteringEnabled() {
        return EntitlementConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent() != null;
    }
}

