/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.PolicyStatusClusterMessage;
import org.wso2.carbon.identity.entitlement.cache.EntitlementBaseCache;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;
import org.wso2.carbon.identity.entitlement.cache.PolicyCacheCreatedListener;
import org.wso2.carbon.identity.entitlement.cache.PolicyCacheUpdateListener;
import org.wso2.carbon.identity.entitlement.cache.PolicyStatus;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;

public class PolicyCache
extends EntitlementBaseCache<IdentityCacheKey, PolicyStatus> {
    private static final Log log = LogFactory.getLog(PolicyCache.class);
    private static final Object lock = new Object();
    private int myHashCode;
    private static final int INVALID_STATE = 1;
    private static Map<Integer, Integer> cacheInvalidationState = new HashMap<Integer, Integer>();
    private static Map<Integer, Map<String, PolicyStatus>> localPolicyCacheMap = new HashMap<Integer, Map<String, PolicyStatus>>();

    public PolicyCache(int timeout) {
        super("ENTITLEMENT_POLICY_INVALIDATION_CACHE", timeout);
        PolicyCacheUpdateListener policyCacheUpdateListener = new PolicyCacheUpdateListener();
        PolicyCacheCreatedListener policyCacheCreatedListener = new PolicyCacheCreatedListener();
        this.setCacheEntryUpdatedListener(policyCacheUpdateListener);
        this.setCacheEntryCreatedListener(policyCacheCreatedListener);
        this.initCacheBuilder();
        if (log.isDebugEnabled()) {
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            log.debug((Object)("PolicyCache initializing for tenant " + tenantId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLocalPolicyCacheMap(IdentityCacheKey identityCacheKey, PolicyStatus policyStatus) {
        if (identityCacheKey.getKey() != null) {
            if (!identityCacheKey.getKey().equals("")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating local cache map for the tenant : " + identityCacheKey.getTenantId() + " and Policy : " + identityCacheKey.getKey()));
                }
                Map<Integer, Map<String, PolicyStatus>> map = localPolicyCacheMap;
                synchronized (map) {
                    if (localPolicyCacheMap.get(identityCacheKey.getTenantId()) != null) {
                        if (localPolicyCacheMap.get(identityCacheKey.getTenantId()).get(identityCacheKey.getKey()) != null) {
                            PolicyStatus status = localPolicyCacheMap.get(identityCacheKey.getTenantId()).get(identityCacheKey.getKey());
                            status.setPolicyAction(PolicyCache.getPriorityAction(status.getPolicyAction(), policyStatus.getPolicyAction()));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Updated existing policy in local cache map :  Policy : " + identityCacheKey.getKey() + " and new action : " + PolicyCache.getPriorityAction(status.getPolicyAction(), policyStatus.getPolicyAction())));
                            }
                        } else {
                            localPolicyCacheMap.get(identityCacheKey.getTenantId()).put(policyStatus.getPolicyId(), policyStatus);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Adding policy in to the local cache policy map : policy :  " + identityCacheKey.getKey()));
                            }
                        }
                    } else {
                        HashMap<String, PolicyStatus> map2 = new HashMap<String, PolicyStatus>();
                        map2.put(policyStatus.getPolicyId(), policyStatus);
                        localPolicyCacheMap.put(identityCacheKey.getTenantId(), map2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding policy in to the local cache policy map : policy :  " + identityCacheKey.getKey() + " add new entry for this tenant : " + identityCacheKey.getTenantId()));
                        }
                    }
                }
            } else {
                cacheInvalidationState.put(identityCacheKey.getTenantId(), 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trigger event to clear all cache in tenant :  " + identityCacheKey.getTenantId()));
                }
            }
        }
    }

    public void invalidateCache() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger invalidateCache to tenant :  " + tenantId + " and all policy "));
        }
        IdentityCacheKey cacheKey = new IdentityCacheKey(tenantId, "");
        PolicyCache.updateLocalPolicyCacheMap(cacheKey, new PolicyStatus());
        if (this.isClusteringEnabled()) {
            this.sendClusterMessage(new PolicyStatusClusterMessage(cacheKey, new PolicyStatus()), true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Clustering not enabled. Not sending cluster message to other nodes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalidate() {
        boolean isInvalid;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        int state = 0;
        Map<Integer, Integer> map = cacheInvalidationState;
        synchronized (map) {
            if (cacheInvalidationState.get(tenantId) != null) {
                state = cacheInvalidationState.get(tenantId);
            }
        }
        boolean bl = isInvalid = state == 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check the invalidation state of all cache, isCacheInvalid: " + isInvalid));
        }
        return isInvalid;
    }

    public void resetCacheInvalidateState() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        cacheInvalidationState.put(tenantId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(String policyId, String action) {
        IdentityCacheKey cacheKey;
        PolicyStatus policyStatus;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger invalidateCache to tenant :  " + tenantId + " and policy " + policyId + " for  action : " + action));
        }
        if ((policyStatus = (PolicyStatus)this.getValueFromCache(cacheKey = new IdentityCacheKey(tenantId, policyId))) == null) {
            policyStatus = new PolicyStatus(policyId, 0, action);
        } else {
            policyStatus.setStatusCount(policyStatus.getStatusCount() + 1);
            policyStatus.setPolicyAction(action);
        }
        PolicyCache.updateLocalPolicyCacheMap(cacheKey, policyStatus);
        if (this.isClusteringEnabled()) {
            this.sendClusterMessage(new PolicyStatusClusterMessage(cacheKey, policyStatus), true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Clustering not enabled. Not sending cluster message to other nodes.");
        }
        Map<Integer, Map<String, PolicyStatus>> map = localPolicyCacheMap;
        synchronized (map) {
            if (localPolicyCacheMap.get(cacheKey.getTenantId()) != null) {
                if (localPolicyCacheMap.get(cacheKey.getTenantId()).get(cacheKey.getKey()) != null) {
                    PolicyStatus status = localPolicyCacheMap.get(cacheKey.getTenantId()).get(cacheKey.getKey());
                    status.setPolicyAction(PolicyCache.getPriorityAction(status.getPolicyAction(), action));
                }
            } else {
                HashMap<String, PolicyStatus> map2 = new HashMap<String, PolicyStatus>();
                map2.put(policyId, policyStatus);
                localPolicyCacheMap.put(cacheKey.getTenantId(), map2);
            }
        }
    }

    public Collection<PolicyStatus> getInvalidatedPolicies() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading invalidated policy files for : " + tenantId));
        }
        Collection<PolicyStatus> tmpSet = null;
        if (localPolicyCacheMap.get(tenantId) != null) {
            Map<String, PolicyStatus> tmpMap = localPolicyCacheMap.get(tenantId);
            tmpSet = tmpMap.values();
        }
        return tmpSet;
    }

    private static String getPriorityAction(String currentAction, String newAction) {
        if ("DELETE".equals(currentAction) || "DELETE".equals(newAction)) {
            return "DELETE";
        }
        if ("DISABLE".equals(currentAction) || "DISABLE".equals(newAction)) {
            return "DELETE";
        }
        if ("ENABLE".equals(currentAction) || "ENABLE".equals(newAction)) {
            return "CREATE";
        }
        if ("UPDATE".equals(currentAction) || "UPDATE".equals(newAction)) {
            return "UPDATE";
        }
        if ("ORDER".equals(currentAction) || "ORDER".equals(newAction)) {
            return "ORDER";
        }
        return newAction;
    }

    private void sendClusterMessage(PolicyStatusClusterMessage clusterMessage, boolean isSync) {
        try {
            ClusteringAgent clusteringAgent;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sending policy status change cluster message to all other nodes");
            }
            if ((clusteringAgent = EntitlementConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent()) != null) {
                clusteringAgent.sendMessage((ClusteringMessage)clusterMessage, isSync);
            } else {
                log.error((Object)"Clustering Agent not available.");
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Error while sending policy status change cluster message", (Throwable)clusteringFault);
        }
    }

    private boolean isClusteringEnabled() {
        return EntitlementConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent() != null;
    }
}

