/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import java.io.Serializable;
import java.security.Key;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;

public class IdentityCacheEntry
implements Serializable {
    private static final long serialVersionUID = 6982031255566292798L;
    private String cacheEntry;
    private Set<String> cacheEntrySet;
    private String[] cacheEntryArray;
    private int hashEntry;
    private long cacheInterval;
    private boolean cacheClearing;
    private Key secretKey;
    private Date date;

    public IdentityCacheEntry(String cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public IdentityCacheEntry(int hashEntry) {
        this.hashEntry = hashEntry;
    }

    public IdentityCacheEntry(boolean cacheClearing) {
        this.cacheClearing = cacheClearing;
    }

    public IdentityCacheEntry(String cacheEntry, long cacheInterval) {
        this.cacheEntry = cacheEntry;
        this.cacheInterval = cacheInterval;
    }

    public IdentityCacheEntry(String[] cacheEntryArray) {
        this.cacheEntryArray = Arrays.copyOf(cacheEntryArray, cacheEntryArray.length);
    }

    public IdentityCacheEntry(Set<String> cacheEntrySet) {
        this.cacheEntrySet = cacheEntrySet;
    }

    public IdentityCacheEntry(String cacheEntry, Key secretKey, Date date) {
        this.cacheEntry = cacheEntry;
        this.secretKey = secretKey;
        this.date = new Date(date.getTime());
    }

    public String getCacheEntry() {
        return this.cacheEntry;
    }

    public int getHashEntry() {
        return this.hashEntry;
    }

    public long getCacheInterval() {
        return this.cacheInterval;
    }

    public Set<String> getCacheEntrySet() {
        return this.cacheEntrySet;
    }

    public boolean isCacheClearing() {
        return this.cacheClearing;
    }

    public String[] getCacheEntryArray() {
        return Arrays.copyOf(this.cacheEntryArray, this.cacheEntryArray.length);
    }

    public Key getSecretKey() {
        return this.secretKey;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }
}

