/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;

public class EntitlementEngineCache {
    public static final String ENTITLEMENT_ENGINE_CACHE_MANAGER = "ENTITLEMENT_ENGINE_CACHE_MANAGER";
    public static final String ENTITLEMENT_ENGINE_CACHE = "$__local__$.ENTITLEMENT_ENGINE_CACHE";
    private static final EntitlementEngineCache instance = new EntitlementEngineCache();
    private static CacheBuilder<Integer, EntitlementEngine> cacheBuilder;
    private static final Log log;
    private static final long DEFAULT_ENTITLEMENT_ENGINE_CACHING_INTERVAL = 900L;

    private EntitlementEngineCache() {
    }

    public static EntitlementEngineCache getInstance() {
        return instance;
    }

    private Cache<Integer, EntitlementEngine> getEntitlementCache() {
        Cache cache;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(ENTITLEMENT_ENGINE_CACHE_MANAGER);
        if (cacheManager != null) {
            if (cacheBuilder == null) {
                Properties properties = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
                String engineCachingInterval = properties.getProperty("Entitlement.Engine.CachingInterval");
                long entitlementEngineCachingInterval = 900L;
                if (engineCachingInterval != null) {
                    try {
                        entitlementEngineCachingInterval = Long.parseLong(engineCachingInterval);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid value for Entitlement.Engine.CachingInterval. Using default value " + entitlementEngineCachingInterval + " seconds."));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Entitlement.Engine.CachingInterval not set. Using default value " + entitlementEngineCachingInterval + " seconds."));
                }
                cacheManager.removeCache(ENTITLEMENT_ENGINE_CACHE);
                cacheBuilder = cacheManager.createCacheBuilder(ENTITLEMENT_ENGINE_CACHE).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, entitlementEngineCachingInterval)).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, entitlementEngineCachingInterval));
                cache = cacheBuilder.build();
            } else {
                cache = cacheManager.getCache(ENTITLEMENT_ENGINE_CACHE);
            }
        } else {
            cache = Caching.getCacheManager().getCache(ENTITLEMENT_ENGINE_CACHE);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created authorization cache : " + cache));
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntitlementEngine get(int key) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            EntitlementEngine entitlementEngine = (EntitlementEngine)this.getEntitlementCache().get((Object)key);
            if (entitlementEngine != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache : $__local__$.ENTITLEMENT_ENGINE_CACHE  is HIT for tenantId : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cache : $__local__$.ENTITLEMENT_ENGINE_CACHE  is MISSED for tenantId : " + key));
            }
            EntitlementEngine entitlementEngine2 = entitlementEngine;
            return entitlementEngine2;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int key, EntitlementEngine engine) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            this.getEntitlementCache().put((Object)key, (Object)engine);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache : $__local__$.ENTITLEMENT_ENGINE_CACHE is populated with new entry with tenantId : " + key));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int key) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            boolean contain = this.getEntitlementCache().containsKey((Object)key);
            if (contain) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache : $__local__$.ENTITLEMENT_ENGINE_CACHE  is HIT for tenantId : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cache : $__local__$.ENTITLEMENT_ENGINE_CACHE  is MISSED for tenantId : " + key));
            }
            boolean bl = contain;
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    static {
        log = LogFactory.getLog(EntitlementEngineCache.class);
    }
}

