/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;

public class EntitlementBaseCache<K extends IdentityCacheKey, V> {
    private static final String ENTITLEMENT_CACHE_MANAGER = "ENTITLEMENT_CACHE_MANAGER";
    private static Log log = LogFactory.getLog(EntitlementBaseCache.class);
    private String Entitlement_CACHE_NAME;
    private int cacheTimeout;
    private CacheBuilder<K, V> cacheBuilder;
    private CacheEntryUpdatedListener<K, V> cacheEntryUpdatedListener;
    private CacheEntryCreatedListener<K, V> cacheEntryCreatedListener;

    public EntitlementBaseCache(String cacheName, int timeout) {
        this.Entitlement_CACHE_NAME = cacheName;
        this.cacheTimeout = timeout > 0 ? timeout : -1;
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is initialized for tenant domain : " + tenantDomain));
        }
    }

    public EntitlementBaseCache(String cacheName) {
        this.Entitlement_CACHE_NAME = cacheName;
        this.cacheTimeout = -1;
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is initialized for tenant domain : " + tenantDomain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<K, V> getEntitlementCache() {
        Cache cache = null;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(ENTITLEMENT_CACHE_MANAGER);
        if (this.cacheTimeout > 0) {
            if (this.cacheBuilder == null) {
                String string = this.Entitlement_CACHE_NAME.intern();
                synchronized (string) {
                    if (this.cacheBuilder == null) {
                        cacheManager.removeCache(this.Entitlement_CACHE_NAME);
                        this.cacheBuilder = cacheManager.createCacheBuilder(this.Entitlement_CACHE_NAME).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)this.cacheTimeout)).setStoreByValue(false);
                        cache = this.cacheBuilder.build();
                        if (this.cacheEntryUpdatedListener != null) {
                            this.cacheBuilder.registerCacheEntryListener(this.cacheEntryUpdatedListener);
                        }
                        if (this.cacheEntryCreatedListener != null) {
                            this.cacheBuilder.registerCacheEntryListener(this.cacheEntryCreatedListener);
                        }
                        if (log.isDebugEnabled()) {
                            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                            log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is built with time out value : " + this.cacheTimeout + " for tenant domain : " + tenantDomain));
                        }
                    }
                }
            } else {
                cache = cacheManager.getCache(this.Entitlement_CACHE_NAME);
            }
        } else {
            cache = cacheManager.getCache(this.Entitlement_CACHE_NAME);
        }
        return cache;
    }

    public void initCacheBuilder() {
        this.getEntitlementCache();
    }

    public void addToCache(K key, V entry) {
        this.clearCacheEntry(key);
        this.updateToCache(key, entry);
    }

    public void updateToCache(K key, V entry) {
        Cache<K, V> cache = this.getEntitlementCache();
        if (cache != null) {
            cache.put(key, entry);
        }
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is populated with new entry in tenant domain : " + tenantDomain));
        }
    }

    public V getValueFromCache(K key) {
        Cache<K, V> cache = this.getEntitlementCache();
        if (cache != null && cache.containsKey(key)) {
            if (log.isDebugEnabled()) {
                String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is HIT in tenant domain : " + tenantDomain));
            }
            return (V)cache.get(key);
        }
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + "  is MISSED in tenant domain : " + tenantDomain));
        }
        return null;
    }

    public void clearCacheEntry(K key) {
        Cache<K, V> cache = this.getEntitlementCache();
        if (cache != null && cache.containsKey(key)) {
            cache.remove(key);
            if (log.isDebugEnabled()) {
                String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + " entry is removed in tenant domain : " + tenantDomain));
            }
        }
    }

    public void clear() {
        Cache<K, V> cache = this.getEntitlementCache();
        if (cache != null) {
            try {
                cache.removeAll();
                if (log.isDebugEnabled()) {
                    String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                    log.debug((Object)("Cache : " + this.Entitlement_CACHE_NAME + " is cleared in tenant domain : " + tenantDomain));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCacheEntryUpdatedListener(CacheEntryUpdatedListener<K, V> cacheEntryUpdatedListener) {
        this.cacheEntryUpdatedListener = cacheEntryUpdatedListener;
    }

    public void setCacheEntryCreatedListener(CacheEntryCreatedListener<K, V> cacheEntryCreatedListener) {
        this.cacheEntryCreatedListener = cacheEntryCreatedListener;
    }
}

