/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.cache.EntitlementBaseCache;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;

public class DecisionCache
extends EntitlementBaseCache<IdentityCacheKey, Object> {
    private static final Log log = LogFactory.getLog(DecisionCache.class);

    public DecisionCache(int timeOut) {
        super("PDP_DECISION_CACHE", timeOut);
    }

    @Override
    public void addToCache(String key, Object decision) {
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            log.debug((Object)("DecisionCache is added for tenant : " + tenantDomain + "  tenantId : " + tenantId + " cache key : " + key + " cache value : " + decision));
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        IdentityCacheKey cacheKey = new IdentityCacheKey(tenantId, key);
        this.addToCache(cacheKey, decision);
    }

    public Object getFromCache(String key) {
        int tenantId;
        IdentityCacheKey cacheKey;
        Object entry;
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            int tenantId2 = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            log.debug((Object)("DecisionCache is get for tenant : " + tenantDomain + "  tenantId : " + tenantId2 + " cache key : " + key));
        }
        if ((entry = this.getValueFromCache(cacheKey = new IdentityCacheKey(tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId(), key))) != null) {
            return entry;
        }
        return null;
    }

    public void clearCache() {
        if (log.isDebugEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            log.debug((Object)("DecisionCache clear all cache from the cluster and tenant domain " + tenantDomain));
        }
        this.clear();
    }
}

