/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.StatusHolderComparator;
import org.wso2.carbon.identity.entitlement.dto.PublisherPropertyDTO;
import org.wso2.carbon.identity.entitlement.dto.StatusHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SimplePAPStatusDataHandler
implements PAPStatusDataHandler {
    private static final String ENTITLEMENT_POLICY_STATUS = "/repository/identity/entitlement/status/policy/";
    private static final String ENTITLEMENT_PUBLISHER_STATUS = "/repository/identity/entitlement/status/publisher/";
    private static final int SEARCH_BY_USER = 0;
    private static final int SEARCH_BY_POLICY = 1;
    private static Log log = LogFactory.getLog(SimplePAPStatusDataHandler.class);
    private int DEFAULT_MAX_RECODES = 50;
    private int maxRecodes;

    @Override
    public void init(Properties properties) {
        String maxRecodesString = (String)properties.get("maxRecodesToPersist");
        if (maxRecodesString != null) {
            try {
                this.maxRecodes = Integer.parseInt(maxRecodesString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.maxRecodes == 0) {
            this.maxRecodes = this.DEFAULT_MAX_RECODES;
        }
    }

    @Override
    public void handle(String about, String key, List<StatusHolder> statusHolder) throws EntitlementException {
        if ("POLICY".equals(about)) {
            String path = ENTITLEMENT_POLICY_STATUS + key;
            for (StatusHolder holder : statusHolder) {
                if (!"DELETE_POLICY".equals(holder.getType())) continue;
                this.deletedPersistedData(path);
                return;
            }
            this.persistStatus(path, statusHolder, false);
        } else {
            String path = ENTITLEMENT_PUBLISHER_STATUS + key;
            for (StatusHolder holder : statusHolder) {
                if (!"DELETE_POLICY".equals(holder.getType())) continue;
                this.deletedPersistedData(path);
                return;
            }
            this.persistStatus(path, statusHolder, false);
        }
    }

    @Override
    public void handle(String about, StatusHolder statusHolder) throws EntitlementException {
        ArrayList<StatusHolder> list = new ArrayList<StatusHolder>();
        list.add(statusHolder);
        this.handle(about, statusHolder.getKey(), list);
    }

    @Override
    public StatusHolder[] getStatusData(String about, String key, String type, String searchString) throws EntitlementException {
        if ("POLICY".equals(about)) {
            String path = ENTITLEMENT_POLICY_STATUS + key;
            List<StatusHolder> holders = this.readStatus(path, "POLICY");
            ArrayList<StatusHolder> filteredHolders = new ArrayList<StatusHolder>();
            if (holders != null) {
                searchString = searchString.replace("*", ".*");
                Pattern pattern = Pattern.compile(searchString, 2);
                for (StatusHolder holder : holders) {
                    String id = holder.getUser();
                    Matcher matcher = pattern.matcher(id);
                    if (!matcher.matches()) continue;
                    if (type != null && type.equals(holder.getType())) {
                        filteredHolders.add(holder);
                        continue;
                    }
                    if (type != null) continue;
                    filteredHolders.add(holder);
                }
            }
            return filteredHolders.toArray(new StatusHolder[filteredHolders.size()]);
        }
        ArrayList<StatusHolder> filteredHolders = new ArrayList<StatusHolder>();
        String path = ENTITLEMENT_PUBLISHER_STATUS + key;
        List<StatusHolder> holders = this.readStatus(path, "SUBSCRIBER");
        if (holders != null) {
            searchString = searchString.replace("*", ".*");
            Pattern pattern = Pattern.compile(searchString, 2);
            for (StatusHolder holder : holders) {
                String id = holder.getTarget();
                Matcher matcher = pattern.matcher(id);
                if (!matcher.matches()) continue;
                filteredHolders.add(holder);
            }
        }
        return filteredHolders.toArray(new StatusHolder[filteredHolders.size()]);
    }

    private synchronized void deletedPersistedData(String path) throws EntitlementException {
        UserRegistry registry = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new EntitlementException("Error while persisting policy status", e);
        }
    }

    private synchronized void persistStatus(String path, List<StatusHolder> statusHolders, boolean isNew) throws EntitlementException {
        Resource resource = null;
        UserRegistry registry = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists(path) && !isNew) {
                resource = registry.get(path);
                String[] versions = registry.getVersions(path);
                if (versions != null) {
                    for (String version : versions) {
                        long versionInt = 0L;
                        String[] versionStrings = version.split(";version:");
                        if (versionStrings != null && versionStrings.length == 2) {
                            try {
                                versionInt = Long.parseLong(versionStrings[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (versionInt == 0L) continue;
                        registry.removeVersionHistory(version, versionInt);
                    }
                }
            } else {
                resource = registry.newResource();
            }
            if (resource != null && statusHolders != null && statusHolders.size() > 0) {
                resource.setVersionableChange(false);
                this.populateStatusProperties(statusHolders.toArray(new StatusHolder[statusHolders.size()]), resource);
                registry.put(path, resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new EntitlementException("Error while persisting policy status", e);
        }
    }

    private synchronized List<StatusHolder> readStatus(String path, String about) throws EntitlementException {
        Resource resource = null;
        UserRegistry registry = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists(path)) {
                resource = registry.get(path);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new EntitlementException("Error while persisting policy status", e);
        }
        ArrayList<StatusHolder> statusHolders = new ArrayList<StatusHolder>();
        if (resource != null && resource.getProperties() != null) {
            Properties properties = resource.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ArrayList list;
                PublisherPropertyDTO dto = new PublisherPropertyDTO();
                dto.setId((String)entry.getKey());
                Object value = entry.getValue();
                if (!(value instanceof ArrayList) || (list = (ArrayList)entry.getValue()) == null || list.size() <= 0 || list.get(0) == null) continue;
                StatusHolder statusHolder = new StatusHolder(about);
                if (list.size() > 0 && list.get(0) != null) {
                    statusHolder.setType((String)list.get(0));
                }
                if (list.size() <= 1 || list.get(1) == null) continue;
                statusHolder.setTimeInstance((String)list.get(1));
                if (list.size() <= 2 || list.get(2) == null) continue;
                String user = (String)list.get(2);
                statusHolder.setUser(user);
                if (list.size() > 3 && list.get(3) != null) {
                    statusHolder.setKey((String)list.get(3));
                }
                if (list.size() > 4 && list.get(4) != null) {
                    statusHolder.setSuccess(Boolean.parseBoolean((String)list.get(4)));
                }
                if (list.size() > 5 && list.get(5) != null) {
                    statusHolder.setMessage((String)list.get(5));
                }
                if (list.size() > 6 && list.get(6) != null) {
                    statusHolder.setTarget((String)list.get(6));
                }
                if (list.size() > 7 && list.get(7) != null) {
                    statusHolder.setTargetAction((String)list.get(7));
                }
                if (list.size() > 8 && list.get(8) != null) {
                    statusHolder.setVersion((String)list.get(8));
                }
                statusHolders.add(statusHolder);
            }
        }
        if (statusHolders.size() > 0) {
            StatusHolder[] array = statusHolders.toArray(new StatusHolder[statusHolders.size()]);
            Arrays.sort(array, new StatusHolderComparator());
            if (statusHolders.size() > this.maxRecodes) {
                statusHolders = new ArrayList();
                for (int i = 0; i < this.maxRecodes; ++i) {
                    statusHolders.add(array[i]);
                }
                this.persistStatus(path, statusHolders, true);
            } else {
                statusHolders = new ArrayList<StatusHolder>(Arrays.asList(array));
            }
        }
        return statusHolders;
    }

    private void populateStatusProperties(StatusHolder[] statusHolders, Resource resource) {
        if (statusHolders != null) {
            for (StatusHolder statusHolder : statusHolders) {
                if (statusHolder == null) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(statusHolder.getType());
                list.add(statusHolder.getTimeInstance());
                list.add(statusHolder.getUser());
                list.add(statusHolder.getKey());
                list.add(Boolean.toString(statusHolder.isSuccess()));
                if (statusHolder.getMessage() != null) {
                    list.add(statusHolder.getMessage());
                } else {
                    list.add("");
                }
                if (statusHolder.getTarget() != null) {
                    list.add(statusHolder.getTarget());
                } else {
                    list.add("");
                }
                if (statusHolder.getTargetAction() != null) {
                    list.add(statusHolder.getTargetAction());
                } else {
                    list.add("");
                }
                if (statusHolder.getVersion() != null) {
                    list.add(statusHolder.getVersion());
                } else {
                    list.add("");
                }
                resource.setProperty(UUID.randomUUID().toString(), list);
            }
        }
    }
}

