/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.Balana;
import org.wso2.balana.ParsingException;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicySet;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.attr.DateAttribute;
import org.wso2.balana.attr.DateTimeAttribute;
import org.wso2.balana.attr.DoubleAttribute;
import org.wso2.balana.attr.HexBinaryAttribute;
import org.wso2.balana.attr.IntegerAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.attr.TimeAttribute;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.xacml2.FirstApplicablePolicyAlg;
import org.wso2.balana.combine.xacml2.OnlyOneApplicablePolicyAlg;
import org.wso2.balana.combine.xacml3.DenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml3.DenyUnlessPermitPolicyAlg;
import org.wso2.balana.combine.xacml3.OrderedDenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml3.OrderedPermitOverridesPolicyAlg;
import org.wso2.balana.combine.xacml3.PermitOverridesPolicyAlg;
import org.wso2.balana.combine.xacml3.PermitUnlessDenyPolicyAlg;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.xacml3.RequestCtx;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.cache.EntitlementBaseCache;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheEntry;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyStoreDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreManager;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisher;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManageModule;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class EntitlementUtil {
    private static Log log = LogFactory.getLog(EntitlementUtil.class);
    private static final String ENHANCED_XACML_LOADING_SYSTEM_PROPERTY = "enableEnhancedXACMLLoading";

    public static EntitlementBaseCache<IdentityCacheKey, IdentityCacheEntry> getCommonCache(String name) {
        return new EntitlementBaseCache<IdentityCacheKey, IdentityCacheEntry>(name);
    }

    public static AttributeValue getAttributeValue(final String value, String type) throws EntitlementException {
        try {
            if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) {
                return new StringAttribute(value);
            }
            if ("http://www.w3.org/2001/XMLSchema#integer".equals(type)) {
                return new IntegerAttribute(Long.parseLong(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#boolean".equals(type)) {
                return BooleanAttribute.getInstance((String)value);
            }
            if ("http://www.w3.org/2001/XMLSchema#double".equals(type)) {
                return new DoubleAttribute(Double.parseDouble(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#date".equals(type)) {
                return new DateAttribute(DateFormat.getDateInstance().parse(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#dateTime".equals(type)) {
                return new DateTimeAttribute(DateFormat.getDateInstance().parse(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#time".equals(type)) {
                return TimeAttribute.getInstance((String)value);
            }
            if ("http://www.w3.org/2001/XMLSchema#hexBinary".equals(type)) {
                return new HexBinaryAttribute(value.getBytes());
            }
            return new AttributeValue(new URI(type)){

                public String encode() {
                    return value;
                }
            };
        }
        catch (ParsingException e) {
            throw new EntitlementException("Error while creating AttributeValue object for given string value and data type");
        }
        catch (ParseException e) {
            throw new EntitlementException("Error while creating AttributeValue object for given string value and data type");
        }
        catch (URISyntaxException e) {
            throw new EntitlementException("Error while creating AttributeValue object for given string value and data type");
        }
    }

    public static AbstractRequestCtx createRequestContext(List<AttributeDTO> attributeDTOs) {
        HashSet<Attributes> attributesSet = new HashSet<Attributes>();
        for (AttributeDTO DTO : attributeDTOs) {
            Attributes attributes = EntitlementUtil.getAttributes(DTO);
            if (attributes == null) continue;
            attributesSet.add(attributes);
        }
        return new RequestCtx(attributesSet, null);
    }

    public static boolean validatePolicy(PolicyDTO policy) {
        try {
            if (!"true".equalsIgnoreCase((String)EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().get("PDP.SchemaValidation.Enable"))) {
                return true;
            }
            if (policy.getPolicy() == null || policy.getPolicy().trim().length() < 1) {
                return true;
            }
            String policyXMLNS = EntitlementUtil.getPolicyVersion(policy.getPolicy());
            Map<String, Schema> schemaMap = EntitlementServiceComponent.getEntitlementConfig().getPolicySchemaMap();
            Schema schema = schemaMap.get(policyXMLNS);
            if (schema != null) {
                DocumentBuilder documentBuilder = EntitlementUtil.getSecuredDocumentBuilder(false);
                ByteArrayInputStream stream = new ByteArrayInputStream(policy.getPolicy().getBytes());
                Document doc = documentBuilder.parse(stream);
                DOMSource domSource = new DOMSource(doc);
                DOMResult domResult = new DOMResult();
                Validator validator = schema.newValidator();
                validator.validate(domSource, domResult);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"XACML Policy validation succeeded with the Schema");
                }
                return true;
            }
            log.error((Object)"Invalid Namespace in policy");
        }
        catch (SAXException e) {
            log.error((Object)("XACML policy is not valid according to the schema :" + e.getMessage()), (Throwable)e);
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return false;
    }

    public static String getPolicyVersion(String policy) {
        try {
            DocumentBuilder documentBuilder = EntitlementUtil.getSecuredDocumentBuilder(false);
            ByteArrayInputStream stream = new ByteArrayInputStream(policy.getBytes());
            Document doc = documentBuilder.parse(stream);
            Element policyElement = doc.getDocumentElement();
            return policyElement.getNamespaceURI();
        }
        catch (Exception e) {
            log.debug((Object)e);
            log.warn((Object)"Policy version can not be identified. Default XACML 3.0 version is used");
            return "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17";
        }
    }

    public static Attributes getAttributes(AttributeDTO attributeDataDTO) {
        try {
            AttributeValue value = Balana.getInstance().getAttributeFactory().createValue(new URI(attributeDataDTO.getAttributeDataType()), attributeDataDTO.getAttributeValue());
            Attribute attribute = new Attribute(new URI(attributeDataDTO.getAttributeId()), null, null, value, 3);
            HashSet<Attribute> set = new HashSet<Attribute>();
            set.add(attribute);
            String category = attributeDataDTO.getCategory();
            if ("Subject".equals(category)) {
                category = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
            } else if ("Resource".equals(category)) {
                category = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
            } else if ("Action".equals(category)) {
                category = "urn:oasis:names:tc:xacml:3.0:attribute-category:action";
            } else if ("Environment".equals(category)) {
                category = "urn:oasis:names:tc:xacml:3.0:attribute-category:environment";
            }
            return new Attributes(new URI(category), set);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static PolicyCombiningAlgorithm getPolicyCombiningAlgorithm(String uri) throws EntitlementException {
        if ("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable".equals(uri)) {
            return new FirstApplicablePolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-overrides".equals(uri)) {
            return new DenyOverridesPolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-overrides".equals(uri)) {
            return new PermitOverridesPolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable".equals(uri)) {
            return new OnlyOneApplicablePolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:ordered-deny-overrides".equals(uri)) {
            return new OrderedDenyOverridesPolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:ordered-permit-overrides".equals(uri)) {
            return new OrderedPermitOverridesPolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-unless-permit".equals(uri)) {
            return new DenyUnlessPermitPolicyAlg();
        }
        if ("urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-unless-deny".equals(uri)) {
            return new PermitUnlessDenyPolicyAlg();
        }
        throw new EntitlementException("Unsupported policy algorithm " + uri);
    }

    public static String createSimpleXACMLRequest(String subject, String resource, String action, String environment) {
        return "<Request xmlns=\"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17\" CombinedDecision=\"false\" ReturnPolicyIdList=\"false\">\n<Attributes Category=\"urn:oasis:names:tc:xacml:3.0:attribute-category:action\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + action + "</AttributeValue>\n</Attribute>\n</Attributes>\n<Attributes Category=\"urn:oasis:names:tc:xacml:1.0:subject-category:access-subject\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject:subject-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + subject + "</AttributeValue>\n</Attribute>\n</Attributes>\n<Attributes Category=\"urn:oasis:names:tc:xacml:3.0:attribute-category:environment\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:environment:environment-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + environment + "</AttributeValue>\n</Attribute>\n</Attributes>\n<Attributes Category=\"urn:oasis:names:tc:xacml:3.0:attribute-category:resource\">\n<Attribute AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" IncludeInResult=\"false\">\n<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + resource + "</AttributeValue>\n</Attribute>\n</Attributes>\n</Request> ";
    }

    public static void addSamplePolicies(Registry registry) {
        Object[] fileList;
        File policyFolder = new File(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "identity" + File.separator + "policies" + File.separator + "xacml" + File.separator + "default");
        if (policyFolder.exists() && ArrayUtils.isNotEmpty((Object[])(fileList = policyFolder.listFiles()))) {
            for (Object policyFile : fileList) {
                if (!((File)policyFile).isFile()) continue;
                PolicyDTO policyDTO = new PolicyDTO();
                try {
                    policyDTO.setPolicy(FileUtils.readFileToString((File)policyFile));
                    EntitlementUtil.addFilesystemPolicy(policyDTO, registry, false);
                }
                catch (Exception e) {
                    log.error((Object)"Error while adding sample XACML policies", (Throwable)e);
                }
            }
        }
    }

    public static boolean isPolicyExists(String policyId, Registry registry) throws EntitlementException {
        PAPPolicyStoreReader policyReader = null;
        policyReader = new PAPPolicyStoreReader(new PAPPolicyStore(registry));
        return policyReader.isExistPolicy(policyId);
    }

    public static boolean addFilesystemPolicy(PolicyDTO policyDTO, Registry registry, boolean promote) throws EntitlementException {
        AbstractPolicy policyObj;
        if (policyDTO.getPolicy() != null) {
            policyDTO.setPolicy(policyDTO.getPolicy().replaceAll(">\\s+<", "><"));
        }
        if ((policyObj = EntitlementUtil.getPolicy(policyDTO.getPolicy())) != null) {
            PAPPolicyStore policyStore = new PAPPolicyStore(registry);
            PAPPolicyStoreManager policyAdmin = new PAPPolicyStoreManager();
            policyDTO.setPolicyId(policyObj.getId().toASCIIString());
            policyDTO.setActive(true);
            if (EntitlementUtil.isPolicyExists(policyDTO.getPolicyId(), registry)) {
                return false;
            }
            policyDTO.setPromote(promote);
            PolicyVersionManager versionManager = EntitlementAdminEngine.getInstance().getVersionManager();
            try {
                String version = versionManager.createVersion(policyDTO);
                policyDTO.setVersion(version);
            }
            catch (EntitlementException e) {
                log.error((Object)"Policy versioning is not supported", (Throwable)e);
            }
            policyAdmin.addOrUpdatePolicy(policyDTO);
            PAPPolicyStoreReader reader = new PAPPolicyStoreReader(policyStore);
            policyDTO = reader.readPolicyDTO(policyDTO.getPolicyId());
            if (Boolean.parseBoolean(System.getProperty(ENHANCED_XACML_LOADING_SYSTEM_PROPERTY)) && promote) {
                EntitlementAdminEngine adminEngine = EntitlementAdminEngine.getInstance();
                adminEngine.getPolicyStoreManager().addPolicy(policyDTO);
            } else {
                PolicyStoreDTO policyStoreDTO = new PolicyStoreDTO();
                policyStoreDTO.setPolicyId(policyDTO.getPolicyId());
                policyStoreDTO.setPolicy(policyDTO.getPolicy());
                policyStoreDTO.setPolicyOrder(policyDTO.getPolicyOrder());
                policyStoreDTO.setAttributeDTOs(policyDTO.getAttributeDTOs());
                policyStoreDTO.setActive(policyDTO.isActive());
                policyStoreDTO.setSetActive(policyDTO.isActive());
                if (promote) {
                    EntitlementUtil.addPolicyToPDP(policyStoreDTO);
                }
                policyAdmin.addOrUpdatePolicy(policyDTO);
            }
            return true;
        }
        throw new EntitlementException("Invalid Entitlement Policy");
    }

    public static AbstractPolicy getPolicy(String policy) {
        InputStream stream = null;
        try {
            DocumentBuilder builder = EntitlementUtil.getSecuredDocumentBuilder(true);
            stream = new ByteArrayInputStream(policy.getBytes("UTF-8"));
            Document doc = builder.parse(stream);
            Element root = doc.getDocumentElement();
            String name = root.getTagName();
            if (name.equals("Policy")) {
                Policy policy2 = Policy.getInstance((Node)root);
                return policy2;
            }
            if (name.equals("PolicySet")) {
                PolicySet policySet = PolicySet.getInstance((Node)root, null);
                return policySet;
            }
            try {
                throw new ParsingException("Unknown root document type: " + name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error while parsing start up policy", e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream");
                }
            }
        }
    }

    public static PolicyDTO getPolicy(String policyId, Registry registry) throws EntitlementException {
        PAPPolicyStoreReader policyReader = null;
        policyReader = new PAPPolicyStoreReader(new PAPPolicyStore(registry));
        return policyReader.readPolicyDTO(policyId);
    }

    public static void addPolicyToPDP(PolicyStoreDTO policyStoreDTO) throws EntitlementException {
        Map.Entry<PolicyStoreManageModule, Properties> entry = EntitlementServiceComponent.getEntitlementConfig().getPolicyStore().entrySet().iterator().next();
        String policyStorePath = entry.getValue().getProperty("policyStorePath");
        if (policyStorePath == null) {
            policyStorePath = "/repository/identity/entitlement/policy/pdp/";
        }
        if (policyStoreDTO == null || policyStoreDTO.getPolicy() == null || policyStoreDTO.getPolicy().trim().length() == 0 || policyStoreDTO.getPolicyId() == null || policyStoreDTO.getPolicyId().trim().length() == 0) {
            return;
        }
        try {
            UserRegistry registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry();
            Collection policyCollection = registry.resourceExists(policyStorePath) ? (Collection)registry.get(policyStorePath) : registry.newCollection();
            registry.put(policyStorePath, (Resource)policyCollection);
            String policyPath = policyStorePath + policyStoreDTO.getPolicyId();
            Resource resource = registry.resourceExists(policyPath) ? registry.get(policyPath) : registry.newResource();
            resource.setProperty("policyOrder", Integer.toString(policyStoreDTO.getPolicyOrder()));
            resource.setContent((Object)policyStoreDTO.getPolicy());
            resource.setMediaType("application/xacml-policy+xml");
            resource.setProperty("active", String.valueOf(policyStoreDTO.isActive()));
            AttributeDTO[] attributeDTOs = policyStoreDTO.getAttributeDTOs();
            if (attributeDTOs != null) {
                EntitlementUtil.setAttributesAsProperties(attributeDTOs, resource);
            }
            registry.put(policyPath, resource);
            PAPPolicyStoreManager storeManager = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager();
            if (storeManager.isExistPolicy(policyStoreDTO.getPolicyId())) {
                PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
                String[] subscribers = new String[]{"PDP Subscriber"};
                if (policyStoreDTO.isActive()) {
                    publisher.publishPolicy(new String[]{policyStoreDTO.getPolicyId()}, null, "ENABLE", false, 0, subscribers, null);
                } else {
                    publisher.publishPolicy(new String[]{policyStoreDTO.getPolicyId()}, null, "DISABLE", false, 0, subscribers, null);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new EntitlementException("Error while adding policy to PDP", e);
        }
    }

    public static void setAttributesAsProperties(AttributeDTO[] attributeDTOs, Resource resource) {
        int attributeElementNo = 0;
        if (attributeDTOs != null) {
            for (AttributeDTO attributeDTO : attributeDTOs) {
                resource.setProperty("policyMetaData" + attributeElementNo, attributeDTO.getCategory() + "," + attributeDTO.getAttributeValue() + "," + attributeDTO.getAttributeId() + "," + attributeDTO.getAttributeDataType());
                ++attributeElementNo;
            }
        }
    }

    public static Properties getPropertiesFromEntitlementConfig() {
        return EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
    }

    private static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }
}

