/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.search.PolicySearch;
import org.wso2.carbon.identity.entitlement.wsxacml.XACMLHandler;

public class EntitlementService
implements XACMLHandler {
    private static Log log = LogFactory.getLog(EntitlementService.class);

    public String getDecision(String request) throws EntitlementException {
        try {
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance();
            String response = entitlementEngine.evaluate(request);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request", (Throwable)e);
            throw new EntitlementException("Error occurred while evaluating XACML request");
        }
    }

    public String getDecisionByAttributes(String subject, String resource, String action, String[] environment) throws EntitlementException {
        try {
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance();
            return entitlementEngine.evaluate(subject, resource, action, environment);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request", (Throwable)e);
            throw new EntitlementException("Error occurred while evaluating XACML request");
        }
    }

    public boolean getBooleanDecision(String subject, String resource, String action) throws Exception {
        try {
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance();
            String response = entitlementEngine.evaluate(subject, resource, action, null);
            return response.contains("Permit");
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request", (Throwable)e);
            throw new Exception("Error occurred while evaluating XACML request");
        }
    }

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch) throws EntitlementException {
        if (subjectName == null) {
            throw new EntitlementException("Invalid input data - either the user name or role name should be non-null");
        }
        PolicySearch policySearch = EntitlementEngine.getInstance().getPolicySearch();
        return policySearch.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch);
    }

    public EntitledResultSetDTO getAllEntitlements(String identifier, AttributeDTO[] givenAttributes) throws EntitlementException {
        PolicySearch policySearch = EntitlementEngine.getInstance().getPolicySearch();
        return policySearch.getEntitledAttributes(identifier, givenAttributes);
    }

    @Override
    public String XACMLAuthzDecisionQuery(String request) throws Exception {
        return this.getDecision(request);
    }
}

