/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.SimplePAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitlementFinderDataHolder;
import org.wso2.carbon.identity.entitlement.dto.EntitlementTreeNodeDTO;
import org.wso2.carbon.identity.entitlement.dto.PaginatedPolicySetDTO;
import org.wso2.carbon.identity.entitlement.dto.PaginatedStatusHolder;
import org.wso2.carbon.identity.entitlement.dto.PaginatedStringDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.dto.StatusHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.pap.EntitlementDataFinder;
import org.wso2.carbon.identity.entitlement.pap.PAPPolicyReader;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreManager;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisher;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class EntitlementPolicyAdminService {
    private static Log log = LogFactory.getLog(EntitlementPolicyAdminService.class);

    public void addPolicy(PolicyDTO policyDTO) throws EntitlementException {
        this.addOrUpdatePolicy(policyDTO, true);
    }

    public void addPolicies(PolicyDTO[] policies) throws EntitlementException {
        if (policies != null) {
            for (PolicyDTO policyDTO : policies) {
                this.addOrUpdatePolicy(policyDTO, true);
            }
        } else {
            throw new EntitlementException("No Entitlement policies are provided.");
        }
    }

    public void importPolicyFromRegistry(String policyRegistryPath) throws EntitlementException {
        PolicyDTO policyDTO = new PolicyDTO();
        String policy = "";
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        String resourceUri = policyRegistryPath.substring(policyRegistryPath.lastIndexOf(58) + 1);
        String registryIdentifier = policyRegistryPath.substring(0, policyRegistryPath.lastIndexOf(58));
        Registry registry = "conf".equals(registryIdentifier) ? (Registry)CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION) : (Registry)CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
        try {
            String stringLine;
            Resource resource = registry.get(resourceUri);
            inputStream = resource.getContentStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
            StringBuilder buffer = new StringBuilder(policy);
            while ((stringLine = bufferedReader.readLine()) != null) {
                buffer.append(stringLine);
            }
            policy = buffer.toString();
            policyDTO.setPolicy(policy.replaceAll(">\\s+<", "><"));
            this.addOrUpdatePolicy(policyDTO, true);
        }
        catch (RegistryException e) {
            log.error((Object)"Registry Error occurs while reading policy from registry", (Throwable)e);
            throw new EntitlementException("Error loading policy from carbon registry");
        }
        catch (IOException e) {
            log.error((Object)"I/O Error occurs while reading policy from registry", (Throwable)e);
            throw new EntitlementException("Error loading policy from carbon registry");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
        }
    }

    public void updatePolicy(PolicyDTO policyDTO) throws EntitlementException {
        this.addOrUpdatePolicy(policyDTO, false);
    }

    public PaginatedPolicySetDTO getAllPolicies(String policyTypeFilter, String policySearchString, int pageNumber, boolean isPDPPolicy) throws EntitlementException {
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        PolicyDTO[] policyDTOs = null;
        policyDTOs = isPDPPolicy ? EntitlementAdminEngine.getInstance().getPolicyStoreManager().getLightPolicies() : EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getAllLightPolicyDTOs();
        policySearchString = policySearchString.replace("*", ".*");
        Pattern pattern = Pattern.compile(policySearchString, 2);
        for (PolicyDTO policyDTO : policyDTOs) {
            boolean useAttributeFiler = false;
            if (!policyTypeFilter.equals("ALL") && !policyTypeFilter.equals(policyDTO.getPolicyType()) && (!"PDP_ENABLED".equals(policyTypeFilter) || !policyDTO.isActive()) && (!"PDP_DISABLED".equals(policyTypeFilter) || policyDTO.isActive())) continue;
            if (policySearchString != null && policySearchString.trim().length() > 0) {
                Matcher matcher;
                PolicyDTO metaDataPolicyDTO;
                AttributeDTO[] attributeDTOs;
                if (!isPDPPolicy && (attributeDTOs = (metaDataPolicyDTO = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getMetaDataPolicy(policyDTO.getPolicyId())).getAttributeDTOs()) != null) {
                    for (AttributeDTO attributeDTO : attributeDTOs) {
                        if (!policySearchString.equalsIgnoreCase(attributeDTO.getAttributeValue())) continue;
                        useAttributeFiler = true;
                        break;
                    }
                }
                if (!useAttributeFiler && policySearchString.trim().length() > 0 && !(matcher = pattern.matcher(policyDTO.getPolicyId())).matches()) continue;
            }
            policyDTOList.add(policyDTO);
        }
        return this.doPaging(pageNumber, policyDTOList.toArray(new PolicyDTO[policyDTOList.size()]));
    }

    public PolicyDTO getPolicy(String policyId, boolean isPDPPolicy) throws EntitlementException {
        PolicyDTO policyDTO = null;
        if (isPDPPolicy) {
            policyDTO = EntitlementAdminEngine.getInstance().getPolicyStoreManager().getPolicy(policyId);
        } else {
            try {
                policyDTO = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getPolicy(policyId);
            }
            catch (EntitlementException e) {
                policyDTO = new PolicyDTO();
                policyDTO.setPolicy(policyId);
                this.handleStatus("GET_POLICY", policyDTO, false, e.getMessage());
                throw e;
            }
            this.handleStatus("GET_POLICY", policyDTO, true, null);
        }
        return policyDTO;
    }

    public PolicyDTO getPolicyByVersion(String policyId, String version) throws EntitlementException {
        PolicyDTO policyDTO = null;
        try {
            PolicyVersionManager versionManager = EntitlementAdminEngine.getInstance().getVersionManager();
            policyDTO = versionManager.getPolicy(policyId, version);
        }
        catch (EntitlementException e) {
            policyDTO = new PolicyDTO();
            policyDTO.setPolicy(policyId);
            this.handleStatus("GET_POLICY", policyDTO, false, e.getMessage());
            throw e;
        }
        this.handleStatus("GET_POLICY", policyDTO, true, null);
        return policyDTO;
    }

    public PolicyDTO getLightPolicy(String policyId) throws EntitlementException {
        return EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getLightPolicy(policyId);
    }

    public void removePolicies(String[] policyIds, boolean dePromote) throws EntitlementException {
        if (policyIds == null || policyIds.length == 0) {
            throw new EntitlementException("No Entitlement policyId has been provided.");
        }
        for (String policyId : policyIds) {
            this.removePolicy(policyId, dePromote);
        }
    }

    public void removePolicy(String policyId, boolean dePromote) throws EntitlementException {
        if (policyId == null) {
            throw new EntitlementException("Entitlement PolicyId can not be null.");
        }
        PAPPolicyStoreManager policyAdmin = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager();
        PolicyDTO oldPolicy = null;
        try {
            try {
                oldPolicy = this.getPolicy(policyId, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldPolicy == null) {
                oldPolicy = new PolicyDTO();
                oldPolicy.setPolicyId(policyId);
            }
            policyAdmin.removePolicy(policyId);
        }
        catch (EntitlementException e) {
            oldPolicy = new PolicyDTO();
            oldPolicy.setPolicyId(policyId);
            this.handleStatus("DELETE_POLICY", oldPolicy, false, e.getMessage());
            throw e;
        }
        this.handleStatus("DELETE_POLICY", oldPolicy, true, null);
        EntitlementAdminEngine.getInstance().getVersionManager().deletePolicy(policyId);
        if (dePromote) {
            this.publishToPDP(new String[]{policyId}, null, "DELETE");
        }
    }

    public String[] getAllPolicyIds(String searchString) throws EntitlementException {
        Pattern pattern;
        String[] policyIds = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getPolicyIds();
        if (searchString == null || searchString.isEmpty()) {
            return policyIds;
        }
        String replacedSearchString = searchString.replace("*", ".*");
        try {
            pattern = Pattern.compile(replacedSearchString, 2);
        }
        catch (PatternSyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while compiling pattern with search string: " + replacedSearchString), (Throwable)e);
            }
            throw new EntitlementException("Invalid search string: " + searchString);
        }
        ArrayList<String> filteredPolicyIds = new ArrayList<String>();
        for (String policyId : policyIds) {
            Matcher matcher = pattern.matcher(policyId);
            if (!matcher.matches()) continue;
            filteredPolicyIds.add(policyId);
        }
        return filteredPolicyIds.toArray(new String[filteredPolicyIds.size()]);
    }

    public PublisherDataHolder getSubscriber(String subscribeId) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        return publisher.retrieveSubscriber(subscribeId, false);
    }

    public String[] getSubscriberIds(String searchString) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        String[] ids = publisher.retrieveSubscriberIds(searchString);
        if (ids != null) {
            return ids;
        }
        return new String[0];
    }

    public void addSubscriber(PublisherDataHolder holder) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        publisher.persistSubscriber(holder, false);
    }

    public void updateSubscriber(PublisherDataHolder holder) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        publisher.persistSubscriber(holder, true);
    }

    public void deleteSubscriber(String subscriberId) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        publisher.deleteSubscriber(subscriberId);
    }

    public void publishPolicies(String[] policyIds, String[] subscriberIds, String action, String version, boolean enabled, int order) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        if (policyIds == null || policyIds.length < 1) {
            policyIds = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager().getPolicyIds();
        }
        if (subscriberIds == null || subscriberIds.length < 1) {
            subscriberIds = publisher.retrieveSubscriberIds("*");
        }
        if (policyIds == null || policyIds.length < 1) {
            throw new EntitlementException("There are no policies to publish");
        }
        if (subscriberIds == null || subscriberIds.length < 1) {
            throw new EntitlementException("There are no subscribers to publish");
        }
        publisher.publishPolicy(policyIds, version, action, enabled, order, subscriberIds, null);
    }

    public void publish(String verificationCode) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        publisher.publishPolicy(null, null, null, false, 0, null, verificationCode);
    }

    private void publishToPDP(String[] policyIds, String version, String action) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        String[] subscribers = new String[]{"PDP Subscriber"};
        publisher.publishPolicy(policyIds, version, action, false, 0, subscribers, null);
    }

    public void publishToPDP(String[] policyIds, String action, String version, boolean enabled, int order) throws EntitlementException {
        PolicyPublisher publisher = EntitlementAdminEngine.getInstance().getPolicyPublisher();
        String[] subscribers = new String[]{"PDP Subscriber"};
        publisher.publishPolicy(policyIds, version, action, enabled, order, subscribers, null);
    }

    public void rollBackPolicy(String policyId, String version) throws EntitlementException {
        PolicyVersionManager versionManager = EntitlementAdminEngine.getInstance().getVersionManager();
        PolicyDTO policyDTO = versionManager.getPolicy(policyId, version);
        this.addOrUpdatePolicy(policyDTO, false);
    }

    public PaginatedStatusHolder getStatusData(String about, String key, String type, String searchString, int pageNumber) throws EntitlementException {
        PAPStatusDataHandler dataRetrievingHandler = null;
        Set<PAPStatusDataHandler> handlers = EntitlementAdminEngine.getInstance().getPapStatusDataHandlers();
        for (PAPStatusDataHandler handler : handlers) {
            if (!(handler instanceof SimplePAPStatusDataHandler)) continue;
            dataRetrievingHandler = handler;
            break;
        }
        if (dataRetrievingHandler == null) {
            throw new EntitlementException("No Status Data Handler is defined for data retrieving");
        }
        StatusHolder[] holders = dataRetrievingHandler.getStatusData(about, key, type, searchString);
        return this.doPaging(pageNumber, holders);
    }

    public PublisherDataHolder[] getPublisherModuleData() {
        List<PublisherDataHolder> holders = EntitlementServiceComponent.getEntitlementConfig().getModulePropertyHolders(PolicyPublisherModule.class.getName());
        if (holders != null) {
            return holders.toArray(new PublisherDataHolder[holders.size()]);
        }
        return null;
    }

    public EntitlementTreeNodeDTO getEntitlementData(String dataModule, String category, String regexp, int dataLevel, int limit) {
        EntitlementDataFinder dataFinder = EntitlementAdminEngine.getInstance().getEntitlementDataFinder();
        return dataFinder.getEntitlementData(dataModule, category, regexp, dataLevel, limit);
    }

    public EntitlementFinderDataHolder[] getEntitlementDataModules() {
        EntitlementDataFinder dataFinder = EntitlementAdminEngine.getInstance().getEntitlementDataFinder();
        return dataFinder.getEntitlementDataModules();
    }

    public String[] getPolicyVersions(String policyId) throws EntitlementException {
        Object[] versions = EntitlementAdminEngine.getInstance().getVersionManager().getVersions(policyId);
        if (versions == null) {
            throw new EntitlementException("Error obtaining policy versions");
        }
        Arrays.sort(versions);
        return versions;
    }

    public void orderPolicy(String policyId, int newOrder) throws EntitlementException {
        PolicyDTO policyDTO = new PolicyDTO();
        policyDTO.setPolicyId(policyId);
        policyDTO.setPolicyOrder(newOrder);
        PAPPolicyStoreManager storeManager = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager();
        if (storeManager.isExistPolicy(policyId)) {
            storeManager.addOrUpdatePolicy(policyDTO);
        }
        this.publishToPDP(new String[]{policyDTO.getPolicyId()}, "ORDER", null, false, newOrder);
    }

    public void enableDisablePolicy(String policyId, boolean enable) throws EntitlementException {
        PolicyDTO policyDTO = new PolicyDTO();
        policyDTO.setPolicyId(policyId);
        policyDTO.setActive(enable);
        PAPPolicyStoreManager storeManager = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager();
        if (storeManager.isExistPolicy(policyId)) {
            storeManager.addOrUpdatePolicy(policyDTO);
        }
        if (enable) {
            this.publishToPDP(new String[]{policyDTO.getPolicyId()}, null, "ENABLE");
        } else {
            this.publishToPDP(new String[]{policyDTO.getPolicyId()}, null, "DISABLE");
        }
    }

    public void dePromotePolicy(String policyId) throws EntitlementException {
        this.publishToPDP(new String[]{policyId}, null, "DELETE");
    }

    private void addOrUpdatePolicy(PolicyDTO policyDTO, boolean isAdd) throws EntitlementException {
        String regString = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PAP.Policy.Id.Regexp.Pattern");
        if (regString == null || regString.trim().length() == 0) {
            regString = "[a-zA-Z0-9._:-]{3,100}$";
        }
        PAPPolicyStoreManager policyAdmin = EntitlementAdminEngine.getInstance().getPapPolicyStoreManager();
        PolicyVersionManager versionManager = EntitlementAdminEngine.getInstance().getVersionManager();
        String policyId = null;
        String policy = null;
        String operation = "UPDATE_POLICY";
        if (isAdd) {
            operation = "ADD_POLICY";
        }
        if (policyDTO == null) {
            throw new EntitlementException("Entitlement Policy can not be null.");
        }
        if (isAdd && policyDTO.getPolicy() == null) {
            throw new EntitlementException("Entitlement Policy can not be null.");
        }
        try {
            policy = policyDTO.getPolicy();
            if (policy != null) {
                policyDTO.setPolicy(policy.replaceAll(">\\s+<", "><"));
                if (!EntitlementUtil.validatePolicy(policyDTO)) {
                    throw new EntitlementException("Invalid Entitlement Policy. Policy is not valid according to XACML schema");
                }
                AbstractPolicy policyObj = PAPPolicyReader.getInstance(null).getPolicy(policy);
                if (policyObj != null) {
                    policyId = policyObj.getId().toASCIIString();
                    policyDTO.setPolicyId(policyId);
                    policyDTO.setActive(policyDTO.isActive());
                    if (policyId.contains("/")) {
                        throw new EntitlementException(" Policy Id cannot contain / characters. Please correct and upload again");
                    }
                    if (!policyId.matches(regString)) {
                        throw new EntitlementException("An Entitlement Policy Id is not valid. It contains illegal characters");
                    }
                    policyDTO.setPolicyId(policyId);
                    if (isAdd && policyAdmin.isExistPolicy(policyId)) {
                        throw new EntitlementException("An Entitlement Policy with the given Id already exists");
                    }
                } else {
                    throw new EntitlementException("Unsupported Entitlement Policy. Policy can not be parsed");
                }
                try {
                    String version = versionManager.createVersion(policyDTO);
                    policyDTO.setVersion(version);
                }
                catch (EntitlementException e) {
                    log.error((Object)"Policy versioning is not supported", (Throwable)e);
                }
            }
            policyAdmin.addOrUpdatePolicy(policyDTO);
        }
        catch (EntitlementException e) {
            this.handleStatus(operation, policyDTO, false, e.getMessage());
            throw e;
        }
        this.handleStatus(operation, policyDTO, true, null);
        if (policyDTO.isPromote()) {
            if (isAdd) {
                this.publishToPDP(new String[]{policyDTO.getPolicyId()}, "CREATE", null, policyDTO.isActive(), policyDTO.getPolicyOrder());
            } else {
                this.publishToPDP(new String[]{policyDTO.getPolicyId()}, "UPDATE", null, policyDTO.isActive(), policyDTO.getPolicyOrder());
            }
        }
    }

    private PaginatedPolicySetDTO doPaging(int pageNumber, PolicyDTO[] policySet) {
        int numberOfPages;
        PaginatedPolicySetDTO paginatedPolicySet = new PaginatedPolicySetDTO();
        if (policySet.length == 0) {
            paginatedPolicySet.setPolicySet(new PolicyDTO[0]);
            return paginatedPolicySet;
        }
        String itemsPerPage = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PAP.Items.Per.Page");
        if (itemsPerPage != null) {
            itemsPerPage = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        }
        int itemsPerPageInt = 10;
        if (itemsPerPage != null) {
            itemsPerPageInt = Integer.parseInt(itemsPerPage);
        }
        if (pageNumber > (numberOfPages = (int)Math.ceil((double)policySet.length / (double)itemsPerPageInt)) - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        PolicyDTO[] returnedPolicySet = new PolicyDTO[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < policySet.length) {
            returnedPolicySet[j] = policySet[i];
            ++i;
            ++j;
        }
        paginatedPolicySet.setPolicySet(returnedPolicySet);
        paginatedPolicySet.setNumberOfPages(numberOfPages);
        return paginatedPolicySet;
    }

    private PaginatedStatusHolder doPaging(int pageNumber, StatusHolder[] statusHolders) {
        int numberOfPages;
        PaginatedStatusHolder paginatedStatusHolder = new PaginatedStatusHolder();
        if (statusHolders.length == 0) {
            paginatedStatusHolder.setStatusHolders(new StatusHolder[0]);
            return paginatedStatusHolder;
        }
        String itemsPerPage = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PAP.Items.Per.Page");
        if (itemsPerPage != null) {
            itemsPerPage = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        }
        int itemsPerPageInt = 10;
        if (itemsPerPage != null) {
            itemsPerPageInt = Integer.parseInt(itemsPerPage);
        }
        if (pageNumber > (numberOfPages = (int)Math.ceil((double)statusHolders.length / (double)itemsPerPageInt)) - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        StatusHolder[] returnedHolders = new StatusHolder[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < statusHolders.length) {
            returnedHolders[j] = statusHolders[i];
            ++i;
            ++j;
        }
        paginatedStatusHolder.setStatusHolders(returnedHolders);
        paginatedStatusHolder.setNumberOfPages(numberOfPages);
        return paginatedStatusHolder;
    }

    private PaginatedStringDTO doPagingString(int pageNumber, String[] ids) {
        int numberOfPages;
        PaginatedStringDTO paginatedStatusHolder = new PaginatedStringDTO();
        if (ids.length == 0) {
            paginatedStatusHolder.setStatusHolders(new String[0]);
            return paginatedStatusHolder;
        }
        String itemsPerPage = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PAP.Items.Per.Page");
        if (itemsPerPage != null) {
            itemsPerPage = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        }
        int itemsPerPageInt = 10;
        if (itemsPerPage != null) {
            itemsPerPageInt = Integer.parseInt(itemsPerPage);
        }
        if (pageNumber > (numberOfPages = (int)Math.ceil((double)ids.length / (double)itemsPerPageInt)) - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        String[] returnedHolders = new String[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < ids.length) {
            returnedHolders[j] = ids[i];
            ++i;
            ++j;
        }
        paginatedStatusHolder.setStatusHolders(returnedHolders);
        paginatedStatusHolder.setNumberOfPages(numberOfPages);
        return paginatedStatusHolder;
    }

    private void handleStatus(String action, PolicyDTO policyDTO, boolean success, String message) {
        Set<PAPStatusDataHandler> handlers = EntitlementServiceComponent.getEntitlementConfig().getPapStatusDataHandlers().keySet();
        String target = "PAP POLICY STORE";
        String targetAction = "";
        if ("ADD_POLICY".equals(action) || "UPDATE_POLICY".equals(action)) {
            targetAction = "PERSIST";
        } else if ("DELETE_POLICY".equals(action)) {
            targetAction = "REMOVE";
        } else if ("GET_POLICY".equals(action)) {
            targetAction = "LOAD";
        }
        String policyId = policyDTO.getPolicyId();
        if (policyId == null) {
            policyId = "UNKNOWN";
        }
        StatusHolder holder = new StatusHolder(action, policyId, policyDTO.getVersion(), target, targetAction, success, message);
        if (handlers != null) {
            for (PAPStatusDataHandler handler : handlers) {
                try {
                    handler.handle("POLICY", holder);
                }
                catch (EntitlementException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

