/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.dto.StatusHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.identity.notification.mgt.bean.PublisherEvent;

public class EntitlementNotificationExtension
implements PAPStatusDataHandler {
    private static final Log log = LogFactory.getLog(EntitlementNotificationExtension.class);
    private final String eventName = "policyUpdate";
    private boolean pdpUpdate = true;
    private boolean papUpdate = false;
    private List<String> pdpActions = new ArrayList<String>();

    @Override
    public void init(Properties properties) {
        String pdpActionUpdate;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initiating Entitlement Notification Extension");
        }
        String pdpUpdateProperty = properties.getProperty("pdpNotification");
        String papNotificationProperty = properties.getProperty("papNotification");
        if (pdpUpdateProperty != null && !pdpUpdateProperty.trim().isEmpty()) {
            this.pdpUpdate = Boolean.parseBoolean(pdpUpdateProperty);
        }
        if (papNotificationProperty != null && !papNotificationProperty.trim().isEmpty()) {
            this.papUpdate = Boolean.parseBoolean(papNotificationProperty);
        }
        if ((pdpActionUpdate = properties.getProperty("pdpNotificationAction")) != null) {
            String[] pdpActionUpdates;
            for (String update : pdpActionUpdates = pdpActionUpdate.split(";")) {
                this.pdpActions.add(update.trim());
            }
        }
    }

    @Override
    public void handle(String about, String key, List<StatusHolder> statusHolder) throws EntitlementException {
        if ("POLICY".equalsIgnoreCase(about)) {
            return;
        }
        if (statusHolder != null) {
            for (StatusHolder holder : statusHolder) {
                this.handle(about, holder);
            }
        }
    }

    @Override
    public void handle(String about, StatusHolder statusHolder) throws EntitlementException {
        if (!"POLICY".equalsIgnoreCase(about)) {
            return;
        }
        String action = null;
        String typeOfAction = statusHolder.getType();
        if (this.papUpdate) {
            if ("UPDATE_POLICY".equals(typeOfAction)) {
                action = "UPDATE";
            } else if ("DELETE_POLICY".equals(typeOfAction)) {
                action = "DELETE";
            } else if ("ADD_POLICY".equals(typeOfAction)) {
                action = "CREATE";
            }
        }
        if (this.pdpUpdate && action == null) {
            if ("PUBLISH_POLICY".equals(typeOfAction)) {
                action = statusHolder.getTargetAction();
            }
            if (action == null || this.pdpActions.size() > 0 && !this.pdpActions.contains(action)) {
                return;
            }
            if ("CREATE".equals(action) || "UPDATE".equals(action)) {
                action = "UPDATE";
            }
        }
        if (action == null) {
            return;
        }
        NotificationSender notificationSender = EntitlementServiceComponent.getNotificationSender();
        if (notificationSender != null) {
            try {
                PublisherEvent event = new PublisherEvent("policyUpdate");
                event.addEventProperty("targetId", statusHolder.getKey());
                event.addEventProperty("username", statusHolder.getUser());
                event.addEventProperty("target", statusHolder.getTarget());
                event.addEventProperty("action", action);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invoking notification sender");
                }
                notificationSender.invoke(event);
            }
            catch (NotificationManagementException e) {
                log.error((Object)"Error while invoking notification sender", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.error((Object)"No registered notification sending service found");
        }
    }

    @Override
    public StatusHolder[] getStatusData(String about, String key, String type, String searchString) throws EntitlementException {
        return new StatusHolder[0];
    }
}

