/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PDPDataHolder;
import org.wso2.carbon.identity.entitlement.dto.PIPFinderDataHolder;
import org.wso2.carbon.identity.entitlement.dto.PolicyFinderDataHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyFinder;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.pip.AbstractPIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonResourceFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;

public class EntitlementAdminService {
    private static Log log = LogFactory.getLog(EntitlementAdminService.class);

    public void clearDecisionCache() throws EntitlementException {
        EntitlementEngine.getInstance().clearDecisionCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Decision Caching is cleared by using admin service");
        }
    }

    public void clearPolicyCache() throws EntitlementException {
        EntitlementEngine.getInstance().invalidatePolicyCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Decision Caching is cleared by using admin service");
        }
    }

    public void clearAllAttributeCaches() throws EntitlementException {
        CarbonAttributeFinder finder = EntitlementEngine.getInstance().getCarbonAttributeFinder();
        if (finder == null) {
            throw new EntitlementException("Can not clear all attribute caches - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                pipAttributeFinder.clearCache();
            }
        }
    }

    public void clearCarbonAttributeCache() throws EntitlementException {
        CarbonAttributeFinder finder = EntitlementEngine.getInstance().getCarbonAttributeFinder();
        if (finder == null) {
            throw new EntitlementException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!(pipAttributeFinder instanceof AbstractPIPAttributeFinder)) continue;
                pipAttributeFinder.clearCache();
            }
        }
    }

    public void clearAttributeFinderCache(String attributeFinder) {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!(pipAttributeFinder instanceof AbstractPIPAttributeFinder) || !pipAttributeFinder.getClass().getCanonicalName().equals(attributeFinder)) continue;
                pipAttributeFinder.clearCache();
                break;
            }
        }
    }

    public void clearAttributeFinderCacheByAttributes(String attributeFinder, String[] attributeIds) {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!pipAttributeFinder.getClass().getCanonicalName().equals(attributeFinder)) continue;
                pipAttributeFinder.clearCache(attributeIds);
                break;
            }
        }
    }

    public void clearAllResourceCaches() throws EntitlementException {
        CarbonResourceFinder finder = EntitlementEngine.getInstance().getCarbonResourceFinder();
        if (finder == null) {
            throw new EntitlementException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
    }

    public void clearCarbonResourceCache() throws EntitlementException {
        CarbonResourceFinder finder = EntitlementEngine.getInstance().getCarbonResourceFinder();
        if (finder == null) {
            throw new EntitlementException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPResourceFinder, Properties> resourceConfigs = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceConfigs != null && !resourceConfigs.isEmpty()) {
            Set<PIPResourceFinder> resourceFinders = resourceConfigs.keySet();
            for (PIPResourceFinder pipResourceFinder : resourceFinders) {
                pipResourceFinder.clearCache();
            }
        }
    }

    public void clearResourceFinderCache(String resourceFinder) {
        Map<PIPResourceFinder, Properties> resourceConfigs = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceConfigs != null && !resourceConfigs.isEmpty()) {
            Set<PIPResourceFinder> resourceFinders = resourceConfigs.keySet();
            for (PIPResourceFinder pipResourceFinder : resourceFinders) {
                if (!resourceFinder.getClass().getCanonicalName().equals(resourceFinder)) continue;
                pipResourceFinder.clearCache();
                break;
            }
        }
    }

    public void refreshAttributeFinder(String attributeFinder) throws EntitlementException {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (attributeFinder != null && designators != null && !designators.isEmpty()) {
            Set<Map.Entry<PIPAttributeFinder, Properties>> pipAttributeFinders = designators.entrySet();
            for (Map.Entry<PIPAttributeFinder, Properties> entry : pipAttributeFinders) {
                if (!attributeFinder.equals(entry.getKey().getClass().getName()) && !attributeFinder.equals(entry.getKey().getModuleName())) continue;
                try {
                    entry.getKey().init(entry.getValue());
                    entry.getKey().clearCache();
                    CarbonAttributeFinder carbonAttributeFinder = EntitlementEngine.getInstance().getCarbonAttributeFinder();
                    carbonAttributeFinder.init();
                    break;
                }
                catch (Exception e) {
                    throw new EntitlementException("Error while refreshing attribute finder - " + attributeFinder);
                }
            }
        }
    }

    public void refreshResourceFinder(String resourceFinder) throws EntitlementException {
        Map<PIPResourceFinder, Properties> resourceFinders = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceFinder != null && resourceFinders != null && !resourceFinders.isEmpty()) {
            for (Map.Entry<PIPResourceFinder, Properties> entry : resourceFinders.entrySet()) {
                if (!resourceFinder.equals(entry.getKey().getClass().getName()) && !resourceFinder.equals(entry.getKey().getModuleName())) continue;
                try {
                    entry.getKey().init(entry.getValue());
                    entry.getKey().clearCache();
                    CarbonAttributeFinder carbonAttributeFinder = EntitlementEngine.getInstance().getCarbonAttributeFinder();
                    carbonAttributeFinder.init();
                    break;
                }
                catch (Exception e) {
                    throw new EntitlementException("Error while refreshing attribute finder - " + resourceFinder);
                }
            }
        }
    }

    public void refreshPolicyFinders(String policyFinder) throws EntitlementException {
        Map<PolicyFinderModule, Properties> policyFinders = EntitlementServiceComponent.getEntitlementConfig().getPolicyFinderModules();
        if (policyFinder != null && policyFinders != null && !policyFinders.isEmpty()) {
            for (Map.Entry<PolicyFinderModule, Properties> entry : policyFinders.entrySet()) {
                if (!policyFinder.equals(entry.getKey().getClass().getName()) && !policyFinder.equals(entry.getKey().getModuleName())) continue;
                try {
                    entry.getKey().init(entry.getValue());
                    EntitlementEngine.getInstance().getCarbonPolicyFinder().init();
                    EntitlementEngine.getInstance().clearDecisionCache();
                    break;
                }
                catch (Exception e) {
                    throw new EntitlementException("Error while refreshing attribute finder - " + policyFinder);
                }
            }
        }
    }

    public String doTestRequest(String xacmlRequest) throws EntitlementException {
        return EntitlementEngine.getInstance().test(xacmlRequest);
    }

    public String doTestRequestForGivenPolicies(String xacmlRequest, String[] policies) throws EntitlementException {
        EntitlementEngine engine = EntitlementEngine.getInstance();
        PAPPolicyFinder papPolicyFinder = (PAPPolicyFinder)((Object)engine.getPapPolicyFinder().getModules().iterator().next());
        papPolicyFinder.setPolicyIds(Arrays.asList(policies));
        String response = EntitlementEngine.getInstance().test(xacmlRequest);
        papPolicyFinder.initPolicyIds();
        return response;
    }

    public PDPDataHolder getPDPData() {
        Object module;
        ArrayList<String> list;
        PDPDataHolder pdpDataHolder = new PDPDataHolder();
        Map<PolicyFinderModule, Properties> finderModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyFinderModules();
        Map<PIPAttributeFinder, Properties> attributeModules = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        Map<PIPResourceFinder, Properties> resourceModules = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (finderModules != null) {
            list = new ArrayList<String>();
            for (Map.Entry<Object, Properties> entry : finderModules.entrySet()) {
                module = (PolicyFinderModule)entry.getKey();
                if (module == null) continue;
                if (module.getModuleName() != null) {
                    list.add(module.getModuleName());
                    continue;
                }
                list.add(module.getClass().getName());
            }
            pdpDataHolder.setPolicyFinders(list.toArray(new String[list.size()]));
        }
        if (attributeModules != null) {
            list = new ArrayList();
            for (Map.Entry<Object, Properties> entry : attributeModules.entrySet()) {
                module = (PIPAttributeFinder)entry.getKey();
                if (module == null) continue;
                if (module.getModuleName() != null) {
                    list.add(module.getModuleName());
                    continue;
                }
                list.add(module.getClass().getName());
            }
            pdpDataHolder.setPipAttributeFinders(list.toArray(new String[list.size()]));
        }
        if (resourceModules != null) {
            list = new ArrayList();
            for (Map.Entry<Object, Properties> entry : resourceModules.entrySet()) {
                module = (PIPResourceFinder)entry.getKey();
                if (module == null) continue;
                if (module.getModuleName() != null) {
                    list.add(module.getModuleName());
                    continue;
                }
                list.add(module.getClass().getName());
            }
            pdpDataHolder.setPipResourceFinders(list.toArray(new String[list.size()]));
        }
        return pdpDataHolder;
    }

    public PolicyFinderDataHolder getPolicyFinderData(String finder) {
        PolicyFinderDataHolder holder = null;
        Map<PolicyFinderModule, Properties> finderModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyFinderModules();
        if (finderModules == null || finder == null) {
            return null;
        }
        for (Map.Entry<PolicyFinderModule, Properties> entry : finderModules.entrySet()) {
            PolicyFinderModule module = entry.getKey();
            if (module == null || !finder.equals(module.getModuleName()) && !finder.equals(module.getClass().getName())) continue;
            holder = new PolicyFinderDataHolder();
            if (module.getModuleName() != null) {
                holder.setModuleName(module.getModuleName());
            } else {
                holder.setModuleName(module.getClass().getName());
            }
            holder.setClassName(module.getClass().getName());
            holder.setPolicyIdentifiers(module.getOrderedPolicyIdentifiers());
            break;
        }
        return holder;
    }

    public PIPFinderDataHolder getPIPAttributeFinderData(String finder) {
        PIPFinderDataHolder holder = null;
        Map<PIPAttributeFinder, Properties> attributeModules = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (attributeModules == null || finder == null) {
            return null;
        }
        for (Map.Entry<PIPAttributeFinder, Properties> entry : attributeModules.entrySet()) {
            PIPAttributeFinder module = entry.getKey();
            if (module == null || !finder.equals(module.getModuleName()) && !finder.equals(module.getClass().getName())) continue;
            holder = new PIPFinderDataHolder();
            if (module.getModuleName() != null) {
                holder.setModuleName(module.getModuleName());
            } else {
                holder.setModuleName(module.getClass().getName());
            }
            holder.setClassName(module.getClass().getName());
            holder.setSupportedAttributeIds(module.getSupportedAttributes().toArray(new String[module.getSupportedAttributes().size()]));
            break;
        }
        return holder;
    }

    public PIPFinderDataHolder getPIPResourceFinderData(String finder) {
        PIPFinderDataHolder holder = null;
        Map<PIPResourceFinder, Properties> resourceModules = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceModules == null || finder == null) {
            return null;
        }
        for (Map.Entry<PIPResourceFinder, Properties> entry : resourceModules.entrySet()) {
            PIPResourceFinder module = entry.getKey();
            if (module == null) continue;
            holder = new PIPFinderDataHolder();
            if (module.getModuleName() != null) {
                holder.setModuleName(module.getModuleName());
            } else {
                holder.setModuleName(module.getClass().getName());
            }
            holder.setClassName(module.getClass().getName());
            break;
        }
        return holder;
    }

    public String getGlobalPolicyAlgorithm() throws EntitlementException {
        return EntitlementAdminEngine.getInstance().getPolicyDataStore().getGlobalPolicyAlgorithmName();
    }

    public void setGlobalPolicyAlgorithm(String policyCombiningAlgorithm) throws EntitlementException {
        EntitlementAdminEngine.getInstance().getPolicyDataStore().setGlobalPolicyAlgorithm(policyCombiningAlgorithm);
    }
}

