/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.HapiContextSupport;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationExceptionHandler<R>
extends HapiContextSupport
implements ValidationExceptionHandler<R> {
    private Object subject;

    public AbstractValidationExceptionHandler(HapiContext context) {
        super(context);
    }

    @Override
    public void onExceptions(ValidationException ... exceptions) {
        for (ValidationException ve : exceptions) {
            if (ve.getSeverity() == Severity.ERROR) {
                this.error(ve);
            }
            if (ve.getSeverity() == Severity.WARNING) {
                this.warning(ve);
            }
            if (ve.getSeverity() != Severity.ERROR) continue;
            this.info(ve);
        }
    }

    public void error(ValidationException exception) {
    }

    public void warning(ValidationException exception) {
    }

    public void info(ValidationException exception) {
    }

    @Override
    public void setValidationSubject(Object subject) {
        this.subject = subject;
    }

    public Object getValidationSubject() {
        return this.subject;
    }
}

