/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.BPS_O29_ORDER;
import ca.uhn.hl7v2.model.v25.group.BPS_O29_PATIENT;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPS_O29
extends AbstractMessage {
    public BPS_O29() {
        this(new DefaultModelClassFactory());
    }

    public BPS_O29(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, true);
            this.add(BPS_O29_PATIENT.class, false, false);
            this.add(BPS_O29_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating BPS_O29 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public BPS_O29_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", BPS_O29_PATIENT.class);
    }

    public BPS_O29_ORDER getORDER() {
        return this.getTyped("ORDER", BPS_O29_ORDER.class);
    }

    public BPS_O29_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, BPS_O29_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<BPS_O29_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", BPS_O29_ORDER.class);
    }

    public void insertORDER(BPS_O29_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public BPS_O29_ORDER insertORDER(int rep) throws HL7Exception {
        return (BPS_O29_ORDER)super.insertRepetition("ORDER", rep);
    }

    public BPS_O29_ORDER removeORDER(int rep) throws HL7Exception {
        return (BPS_O29_ORDER)super.removeRepetition("ORDER", rep);
    }
}

