/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.TS;

public class DLD
extends AbstractComposite {
    private Type[] data;

    public DLD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new IS(this.getMessage(), 0);
        this.data[1] = new TS(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getDischargeLocation() {
        return this.getTyped(0, IS.class);
    }

    public IS getDld1_DischargeLocation() {
        return this.getTyped(0, IS.class);
    }

    public TS getEffectiveDate() {
        return this.getTyped(1, TS.class);
    }

    public TS getDld2_EffectiveDate() {
        return this.getTyped(1, TS.class);
    }
}

