/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RQ1
extends AbstractSegment {
    public RQ1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 10, new Object[]{this.getMessage()}, "Anticipated Price");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Manufacturer ID");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Manufacturer's Catalog");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Vendor ID");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Vendor Catalog");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Taxable");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Substitute Allowed");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RQ1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getAnticipatedPrice() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getRq11_AnticipatedPrice() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getManufacturerID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRq12_ManufacturerID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getManufacturerSCatalog() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getRq13_ManufacturerSCatalog() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getVendorID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRq14_VendorID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getVendorCatalog() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getRq15_VendorCatalog() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getTaxable() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getRq16_Taxable() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getSubstituteAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getRq17_SubstituteAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

