/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Varies
implements Type {
    public static final String DEFAULT_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.default_obx2_type";
    public static final String INVALID_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.invalid_obx2_type";
    public static final String ESCAPE_SUBCOMPONENT_DELIM_IN_PRIMITIVE = "ca.uhn.hl7v2.model.varies.escape_subcomponent_delim_in_primitive";
    private static final Logger log = LoggerFactory.getLogger(Varies.class);
    private Type data;
    private Message message;

    public Varies(Message message) {
        this.data = new GenericPrimitive(message);
        this.message = message;
    }

    public Type getData() {
        return this.data;
    }

    public String getName() {
        String name = "*";
        if (this.data != null) {
            name = this.data.getName();
        }
        return name;
    }

    public void setData(Type data) throws DataTypeException {
        if (!(this.data == null || this.data instanceof Primitive && ((Primitive)this.data).getValue() == null)) {
            DeepCopy.copy(this.data, data);
        }
        this.data = data;
    }

    public ExtraComponents getExtraComponents() {
        return this.data.getExtraComponents();
    }

    public Message getMessage() {
        return this.message;
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory) throws HL7Exception {
        Varies.fixOBX5(segment, factory, segment.getMessage().getParser().getParserConfiguration());
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory, ParserConfiguration parserConfiguration) throws HL7Exception {
        try {
            Primitive obx2 = (Primitive)segment.getField(2, 0);
            Type[] reps = segment.getField(5);
            for (int i = 0; i < reps.length; ++i) {
                Type[] subComponentsInFirstField;
                boolean escapeSubcomponentDelimInPrimitive;
                Type newTypeInstance;
                Varies v = (Varies)reps[i];
                if (obx2.getValue() == null) {
                    String defaultOBX2Type = parserConfiguration.getDefaultObx2Type();
                    if (defaultOBX2Type == null) {
                        defaultOBX2Type = System.getProperty(DEFAULT_OBX2_TYPE_PROP);
                    }
                    if (defaultOBX2Type != null) {
                        log.debug("setting default obx2 type to {}", (Object)defaultOBX2Type);
                        obx2.setValue(defaultOBX2Type);
                    }
                }
                if (obx2.getValue() == null) {
                    if (v.getData() == null || v.getData() instanceof Primitive && ((Primitive)v.getData()).getValue() == null) continue;
                    throw new HL7Exception("OBX-5 is valued, but OBX-2 is not.  A datatype for OBX-5 must be specified using OBX-2. See JavaDoc for Varies#fixOBX5(Segment, ModelClassFactory)", ErrorCode.REQUIRED_FIELD_MISSING);
                }
                String version = segment.getMessage().getVersion();
                String obx2Value = obx2.getValue();
                Class<? extends Type> c = factory.getTypeClass(obx2Value, version);
                if (c == null) {
                    String defaultOBX2Type = parserConfiguration.getInvalidObx2Type();
                    if (defaultOBX2Type == null) {
                        defaultOBX2Type = System.getProperty(INVALID_OBX2_TYPE_PROP);
                    }
                    if (defaultOBX2Type != null) {
                        c = factory.getTypeClass(defaultOBX2Type, version);
                    }
                    if (c == null) {
                        Primitive obx1 = (Primitive)segment.getField(1, 0);
                        HL7Exception h = new HL7Exception("'" + obx2.getValue() + "' in record " + obx1.getValue() + " is invalid for version " + version + ". See JavaDoc for Varies#fixOBX5(Segment, ModelClassFactory)", ErrorCode.DATA_TYPE_ERROR);
                        h.setSegmentName("OBX");
                        h.setFieldPosition(2);
                        throw h;
                    }
                }
                try {
                    newTypeInstance = c.getConstructor(Message.class).newInstance(v.getMessage());
                }
                catch (NoSuchMethodException e) {
                    newTypeInstance = c.getConstructor(Message.class, Integer.class).newInstance(v.getMessage(), 0);
                }
                boolean bl = escapeSubcomponentDelimInPrimitive = parserConfiguration.isEscapeSubcomponentDelimiterInPrimitive() || Varies.escapeSubcomponentDelimInPrimitive();
                if (newTypeInstance instanceof Primitive && (subComponentsInFirstField = v.getFirstComponentSubcomponentsOnlyIfMoreThanOne()) != null && escapeSubcomponentDelimInPrimitive) {
                    StringBuilder firstComponentValue = new StringBuilder();
                    for (Type type : subComponentsInFirstField) {
                        if (firstComponentValue.length() != 0) {
                            char subComponentSeparator = EncodingCharacters.getInstance(segment.getMessage()).getSubcomponentSeparator();
                            firstComponentValue.append(subComponentSeparator);
                        }
                        firstComponentValue.append(type.encode());
                    }
                    v.setFirstComponentPrimitiveValue(firstComponentValue.toString());
                }
                v.setData(newTypeInstance);
            }
        }
        catch (HL7Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new HL7Exception(e.getClass().getName() + " trying to set data type of OBX-5", e);
        }
    }

    private static boolean escapeSubcomponentDelimInPrimitive() {
        String property = System.getProperty(ESCAPE_SUBCOMPONENT_DELIM_IN_PRIMITIVE);
        return property == null || "true".equalsIgnoreCase(property);
    }

    private void setFirstComponentPrimitiveValue(String theValue) throws DataTypeException {
        Composite c = (Composite)this.data;
        Type firstComponent = c.getComponent(0);
        this.setFirstComponentPrimitiveValue(firstComponent, theValue);
    }

    private void setFirstComponentPrimitiveValue(Type theFirstComponent, String theValue) throws DataTypeException {
        if (theFirstComponent instanceof Varies) {
            Varies firstComponentVaries = (Varies)theFirstComponent;
            if (((Varies)theFirstComponent).getData() instanceof Composite) {
                Type[] subComponents = ((Composite)firstComponentVaries.getData()).getComponents();
                this.setFirstComponentPrimitiveValue(subComponents[0], theValue);
                for (int i = 1; i < subComponents.length; ++i) {
                    this.setFirstComponentPrimitiveValue(subComponents[i], "");
                }
            } else {
                Primitive p = (Primitive)firstComponentVaries.getData();
                p.setValue(theValue);
            }
        } else if (theFirstComponent instanceof Composite) {
            Type[] subComponents = ((Composite)theFirstComponent).getComponents();
            this.setFirstComponentPrimitiveValue(subComponents[0], theValue);
            for (int i = 1; i < subComponents.length; ++i) {
                this.setFirstComponentPrimitiveValue(subComponents[i], "");
            }
        } else {
            ((Primitive)theFirstComponent).setValue(theValue);
        }
    }

    private Type[] getFirstComponentSubcomponentsOnlyIfMoreThanOne() throws DataTypeException {
        Varies firstComponentVaries;
        Composite c;
        Type firstComponent;
        if (this.data instanceof Composite && (firstComponent = (c = (Composite)this.data).getComponent(0)) instanceof Varies && (firstComponentVaries = (Varies)firstComponent).getData() instanceof Composite) {
            return ((Composite)firstComponentVaries.getData()).getComponents();
        }
        return null;
    }

    public void parse(String string) throws HL7Exception {
        if (this.data != null) {
            this.data.clear();
        }
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return AbstractType.toString(this);
    }
}

