/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

public class Location {
    private String segmentName = null;
    private int segmentRepetition = -1;
    private int field = -1;
    private int fieldRepetition = -1;
    private int component = -1;
    private int subcomponent = -1;
    public static final Location UNKNOWN = new Location();

    public Location() {
    }

    public Location(Location l) {
        this.segmentName = l.segmentName;
        this.segmentRepetition = l.segmentRepetition;
        this.field = l.field;
        this.fieldRepetition = l.fieldRepetition;
        this.component = l.component;
        this.subcomponent = l.subcomponent;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public int getSegmentRepetition() {
        return this.segmentRepetition;
    }

    public void setSegmentRepetition(int segmentRepetition) {
        this.segmentRepetition = segmentRepetition;
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public int getFieldRepetition() {
        return this.fieldRepetition;
    }

    public void setFieldRepetition(int fieldRepetition) {
        this.fieldRepetition = fieldRepetition;
    }

    public int getComponent() {
        return this.component;
    }

    public void setComponent(int component) {
        this.component = component;
    }

    public int getSubcomponent() {
        return this.subcomponent;
    }

    public void setSubcomponent(int subcomponent) {
        this.subcomponent = subcomponent;
    }

    public void setFieldIndizes(int[] indices) {
        this.field = indices[0];
        this.fieldRepetition = indices[1];
        this.component = indices[2];
        this.subcomponent = indices[3];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.segmentName != null) {
            sb.append(this.segmentName);
            if (this.segmentRepetition >= 0) {
                sb.append("(").append(this.segmentRepetition).append(")");
            }
            if (this.field > 0) {
                sb.append("-").append(this.field);
                if (this.fieldRepetition >= 0) {
                    sb.append("(").append(this.fieldRepetition).append(")");
                }
                if (this.component > 0) {
                    sb.append("-").append(this.component);
                    if (this.subcomponent > 0) {
                        sb.append("-").append(this.subcomponent);
                    }
                }
            }
        } else {
            sb.append("unknown location");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.component;
        result = 31 * result + this.field;
        result = 31 * result + this.fieldRepetition;
        result = 31 * result + (this.segmentName == null ? 0 : this.segmentName.hashCode());
        result = 31 * result + this.segmentRepetition;
        result = 31 * result + this.subcomponent;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.component != other.component) {
            return false;
        }
        if (this.field != other.field) {
            return false;
        }
        if (this.fieldRepetition != other.fieldRepetition) {
            return false;
        }
        if (this.segmentName == null ? other.segmentName != null : !this.segmentName.equals(other.segmentName)) {
            return false;
        }
        if (this.segmentRepetition != other.segmentRepetition) {
            return false;
        }
        return this.subcomponent == other.subcomponent;
    }
}

