/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.InlineModelResolver;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.RemoteUrl;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIV3Parser
implements SwaggerParserExtension {
    private static ObjectMapper JSON_MAPPER;
    private static ObjectMapper YAML_MAPPER;
    private static final Logger LOGGER;
    private static String encoding;

    public static String getEncoding() {
        return encoding;
    }

    public static void setEncoding(String encoding) {
        if (Charset.isSupported(encoding)) {
            OpenAPIV3Parser.encoding = encoding;
        }
    }

    @Override
    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        try {
            String version;
            if (auth == null) {
                auth = new ArrayList<AuthorizationValue>();
            }
            if ((result = this.readWithInfo(url, auth)).getOpenAPI() != null && (version = result.getOpenAPI().getOpenapi()) != null && version.startsWith("3.0") && options != null) {
                OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, url);
                if (options.isResolve()) {
                    result.setOpenAPI(resolver.resolve());
                }
                if (options.isResolveFully()) {
                    result.setOpenAPI(resolver.resolve());
                    new ResolverFully(options.isResolveCombinators()).resolveFully(result.getOpenAPI());
                } else if (options.isFlatten()) {
                    InlineModelResolver inlineModelResolver = new InlineModelResolver(options.isFlattenComposedSchemas(), options.isCamelCaseFlattenNaming());
                    inlineModelResolver.setSkipMatches(options.isSkipMatches());
                    inlineModelResolver.flatten(result.getOpenAPI());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading:", (Throwable)e);
            result.setMessages(Arrays.asList(e.getMessage()));
        }
        return result;
    }

    public OpenAPI read(String location) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.read(location, null, options);
    }

    public OpenAPI read(String location, List<AuthorizationValue> auths, ParseOptions resolve) {
        if (location == null) {
            return null;
        }
        location = location.replaceAll("\\\\", "/");
        List<SwaggerParserExtension> parserExtensions = OpenAPIV3Parser.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            SwaggerParseResult parsed = extension.readLocation(location, auths, resolve);
            for (String message : parsed.getMessages()) {
                LOGGER.info("{}: {}", (Object)extension, (Object)message);
            }
            OpenAPI output = parsed.getOpenAPI();
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public SwaggerParseResult readWithInfo(String path, JsonNode node) {
        OpenAPIDeserializer ser = new OpenAPIDeserializer();
        return ser.deserialize(node, path);
    }

    private ObjectMapper getRightMapper(String data) {
        ObjectMapper mapper = data.trim().startsWith("{") ? JSON_MAPPER : YAML_MAPPER;
        return mapper;
    }

    public SwaggerParseResult readWithInfo(String location, List<AuthorizationValue> auths) {
        try {
            String data;
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString(location, auths);
            } else {
                String fileScheme = "file:";
                Path path = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)encoding) : ClasspathHelper.loadFileFromClasspath(location);
            }
            LOGGER.debug("Loaded raw data: {}", (Object)data);
            ObjectMapper mapper = this.getRightMapper(data);
            JsonNode rootNode = mapper.readTree(data);
            LOGGER.debug("Parsed rootNode: {}", (Object)rootNode);
            return this.readWithInfo(location, rootNode);
        }
        catch (SSLHandshakeException e) {
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "` due to a SSL configuration error.  It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority."));
            return output;
        }
        catch (JsonParseException e) {
            LOGGER.warn("Exception while parsing:", (Throwable)e);
            SwaggerParseResult output = new SwaggerParseResult();
            String message = e.getOriginalMessage();
            if (message != null && message.startsWith("Duplicate field")) {
                output.setMessages(Arrays.asList(message + " in `" + location + "`"));
            } else {
                output.setMessages(Arrays.asList("unable to parse `" + location + "`"));
            }
            return output;
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading:", (Throwable)e);
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "`"));
            return output;
        }
    }

    @Override
    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result;
        block11: {
            result = new SwaggerParseResult();
            if (swaggerAsString != null && !"".equals(swaggerAsString.trim())) {
                ObjectMapper mapper = this.getRightMapper(swaggerAsString);
                if (auth == null) {
                    auth = new ArrayList<AuthorizationValue>();
                }
                try {
                    if (options != null) {
                        if (options.isResolve()) {
                            OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
                            JsonNode rootNode = mapper.readTree(swaggerAsString);
                            result = deserializer.deserialize(rootNode);
                            OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, null);
                            result.setOpenAPI(resolver.resolve());
                        } else {
                            JsonNode rootNode = mapper.readTree(swaggerAsString);
                            result = new OpenAPIDeserializer().deserialize(rootNode);
                        }
                        if (options.isResolveFully()) {
                            result.setOpenAPI(new OpenAPIResolver(result.getOpenAPI(), auth, null).resolve());
                            new ResolverFully(options.isResolveCombinators()).resolveFully(result.getOpenAPI());
                        } else if (options.isFlatten()) {
                            InlineModelResolver inlineModelResolver = new InlineModelResolver(options.isFlattenComposedSchemas(), options.isCamelCaseFlattenNaming());
                            inlineModelResolver.setSkipMatches(options.isSkipMatches());
                            inlineModelResolver.flatten(result.getOpenAPI());
                        }
                        break block11;
                    }
                    JsonNode rootNode = mapper.readTree(swaggerAsString);
                    result = new OpenAPIDeserializer().deserialize(rootNode);
                }
                catch (Exception e) {
                    result.setMessages(Arrays.asList(e.getMessage()));
                }
            } else {
                result.setMessages(Arrays.asList("No swagger supplied"));
            }
        }
        return result;
    }

    public static List<SwaggerParserExtension> getExtensions() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        List<SwaggerParserExtension> extensions = OpenAPIV3Parser.getExtensions(tccl);
        ClassLoader cl = SwaggerParserExtension.class.getClassLoader();
        if (cl != tccl) {
            extensions.addAll(OpenAPIV3Parser.getExtensions(cl));
        }
        extensions.add(0, new OpenAPIV3Parser());
        return extensions;
    }

    protected static List<SwaggerParserExtension> getExtensions(ClassLoader cl) {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class, cl);
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            extensions.add(itr.next());
        }
        return extensions;
    }

    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            v.setUrlMatcher(value.getUrlMatcher());
            output.add(v);
        }
        return output;
    }

    public SwaggerParseResult readContents(String yaml) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.readContents(yaml, null, options);
    }

    static {
        LOGGER = LoggerFactory.getLogger(OpenAPIV3Parser.class);
        encoding = "UTF-8";
        JSON_MAPPER = ObjectMapperFactory.createJson();
        YAML_MAPPER = ObjectMapperFactory.createYaml();
    }
}

