/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.core.internal.ds;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.internal.CarbonInputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.internal.config.AdapterConfigs;
import org.wso2.carbon.event.input.adapter.core.internal.ds.InputEventAdapterServiceValueHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="event.input.adapter.service", immediate=true)
public class InputEventAdapterServiceDS {
    private static final Log log = LogFactory.getLog(InputEventAdapterServiceDS.class);
    public static List<InputEventAdapterFactory> inputEventAdapterFactories = new ArrayList<InputEventAdapterFactory>();

    @Activate
    protected void activate(ComponentContext context) {
        InputEventAdapterServiceValueHolder.setGlobalAdapterConfigs(this.loadGlobalConfigs());
        CarbonInputEventAdapterService inputEventAdapterService = new CarbonInputEventAdapterService();
        InputEventAdapterServiceValueHolder.setCarbonInputEventAdapterService(inputEventAdapterService);
        this.registerInputEventAdapterFactories();
        context.getBundleContext().registerService(InputEventAdapterService.class.getName(), (Object)inputEventAdapterService, null);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the input event adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the input event adapter service ", (Throwable)e);
        }
    }

    private void registerInputEventAdapterFactories() {
        CarbonInputEventAdapterService carbonInputEventAdapterService = InputEventAdapterServiceValueHolder.getCarbonInputEventAdapterService();
        for (InputEventAdapterFactory inputEventAdapterFactory : inputEventAdapterFactories) {
            carbonInputEventAdapterService.registerEventAdapterFactory(inputEventAdapterFactory);
        }
    }

    @Reference(name="input.event.adapter.tracker.service", service=InputEventAdapterFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unSetEventAdapterType")
    protected void setEventAdapterType(InputEventAdapterFactory inputEventAdapterFactory) {
        try {
            if (InputEventAdapterServiceValueHolder.getCarbonInputEventAdapterService() != null) {
                InputEventAdapterServiceValueHolder.getCarbonInputEventAdapterService().registerEventAdapterFactory(inputEventAdapterFactory);
            } else {
                inputEventAdapterFactories.add(inputEventAdapterFactory);
            }
        }
        catch (Throwable t) {
            String inputEventAdapterFactoryClassName = "Unknown";
            if (inputEventAdapterFactory != null) {
                inputEventAdapterFactoryClassName = inputEventAdapterFactory.getClass().getName();
            }
            log.error((Object)("Unexpected error at initializing input event adapter factory " + inputEventAdapterFactoryClassName + ": " + t.getMessage()), t);
        }
    }

    protected void unSetEventAdapterType(InputEventAdapterFactory inputEventAdapterFactory) {
        InputEventAdapterServiceValueHolder.getCarbonInputEventAdapterService().unRegisterEventAdapter(inputEventAdapterFactory);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        InputEventAdapterServiceValueHolder.setConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        InputEventAdapterServiceValueHolder.setConfigurationContextService(null);
    }

    private AdapterConfigs loadGlobalConfigs() {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "input-event-adapters.xml";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AdapterConfigs.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File configFile = new File(path);
            if (!configFile.exists()) {
                log.warn((Object)("input-event-adapters.xml can not found in " + path + ", hence Input Event Adapters will be running with default global configs."));
            }
            return (AdapterConfigs)unmarshaller.unmarshal(this.getXMLStreamReader(path));
        }
        catch (JAXBException | XMLStreamException e) {
            log.error((Object)("Error in loading input-event-adapters.xml from " + path + ", hence Input Event Adapters will be running with default global configs."));
            return new AdapterConfigs();
        }
    }

    private XMLStreamReader getXMLStreamReader(String filePath) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(new StreamSource(filePath));
        return xmlStreamReader;
    }
}

