/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.core.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSubscription;
import org.wso2.carbon.event.input.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.core.internal.DecayTimer;

public class InputAdapterRuntime
implements InputEventAdapterListener {
    private static Log log = LogFactory.getLog(InputAdapterRuntime.class);
    private InputEventAdapter inputEventAdapter;
    private String name;
    private InputEventAdapterSubscription inputEventAdapterSubscription;
    private volatile boolean connected = false;
    private DecayTimer timer = new DecayTimer();
    private volatile long nextConnectionTime;
    private ExecutorService executorService;
    private boolean startedTriggered = false;
    private boolean startPollingTriggered = false;
    private int tenantId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputAdapterRuntime(InputEventAdapter inputEventAdapter, String name, InputEventAdapterSubscription inputEventAdapterSubscription) throws InputEventAdapterException {
        this.inputEventAdapter = inputEventAdapter;
        this.name = name;
        this.inputEventAdapterSubscription = inputEventAdapterSubscription;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        this.executorService = Executors.newSingleThreadExecutor();
        InputAdapterRuntime inputAdapterRuntime = this;
        synchronized (inputAdapterRuntime) {
            inputEventAdapter.init(this);
        }
    }

    public void startPolling() {
        this.startPollingTriggered = true;
        if (!this.connected && this.startedTriggered && this.isPolling()) {
            this.start();
        }
    }

    public void start() {
        try {
            this.startedTriggered = true;
            if (!this.isPolling() || this.startPollingTriggered) {
                if (!this.connected) {
                    log.info((Object)("Connecting receiver " + this.name));
                    this.inputEventAdapter.connect();
                    this.connected = true;
                }
            } else {
                log.info((Object)("Waiting to connect receiver " + this.name));
            }
        }
        catch (ConnectionUnavailableException e) {
            this.connectionUnavailable(e);
        }
        catch (InputEventAdapterRuntimeException e) {
            this.connected = false;
            this.inputEventAdapter.disconnect();
            log.error((Object)("Error initializing Input Adapter '" + this.name + ", hence this will be suspended indefinitely, " + e.getMessage()), (Throwable)e);
        }
    }

    public void destroy() {
        if (this.inputEventAdapter != null) {
            try {
                this.inputEventAdapter.disconnect();
            }
            catch (Throwable e) {
                log.error((Object)("Error when disconnecting Input Adapter '" + this.name + "'," + e.getMessage()), e);
            }
            finally {
                this.inputEventAdapter.destroy();
            }
        }
    }

    @Override
    public void onEvent(Object object) {
        this.inputEventAdapterSubscription.onEvent(object);
    }

    @Override
    public synchronized void connectionUnavailable(ConnectionUnavailableException connectionUnavailableException) {
        block7: {
            try {
                try {
                    if (!this.connected && connectionUnavailableException == null) {
                        if (this.nextConnectionTime <= System.currentTimeMillis()) {
                            this.inputEventAdapter.connect();
                            this.connected = true;
                            this.timer.reset();
                        }
                        break block7;
                    }
                    this.connected = false;
                    this.inputEventAdapter.disconnect();
                    this.timer.incrementPosition();
                    this.nextConnectionTime = System.currentTimeMillis() + this.timer.returnTimeToWait();
                    if (this.timer.returnTimeToWait() == 0L) {
                        log.error((Object)("Connection unavailable for Input Adapter '" + this.name + "' reconnecting."), (Throwable)connectionUnavailableException);
                        this.inputEventAdapter.connect();
                        break block7;
                    }
                    log.error((Object)("Connection unavailable for Input Adapter '" + this.name + "' . Reconnection will be retried in " + this.timer.returnTimeToWait() + " milliseconds."), (Throwable)connectionUnavailableException);
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PrivilegedCarbonContext.startTenantFlow();
                                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(InputAdapterRuntime.this.tenantId);
                                try {
                                    Thread.sleep(InputAdapterRuntime.this.timer.returnTimeToWait());
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                InputAdapterRuntime.this.connectionUnavailable(null);
                            }
                            finally {
                                PrivilegedCarbonContext.endTenantFlow();
                            }
                        }
                    });
                }
                catch (ConnectionUnavailableException e) {
                    this.connectionUnavailable(e);
                }
            }
            catch (InputEventAdapterRuntimeException e) {
                this.connected = false;
                log.error((Object)("Error in connecting Input Adapter '" + this.name + "', hence this will be suspended indefinitely, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean isEventDuplicatedInCluster() {
        return this.inputEventAdapter.isEventDuplicatedInCluster();
    }

    public boolean isPolling() {
        return this.inputEventAdapter.isPolling();
    }

    public String getName() {
        return this.name;
    }
}

