/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSchema;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSubscription;
import org.wso2.carbon.event.input.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.core.internal.InputAdapterRuntime;
import org.wso2.carbon.event.input.adapter.core.internal.TestConnectionAdapterListener;
import org.wso2.carbon.event.input.adapter.core.internal.ds.InputEventAdapterServiceValueHolder;

public class CarbonInputEventAdapterService
implements InputEventAdapterService {
    private static Log log = LogFactory.getLog(CarbonInputEventAdapterService.class);
    private Map<String, InputEventAdapterFactory> eventAdapterFactoryMap = new ConcurrentHashMap<String, InputEventAdapterFactory>();
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, InputAdapterRuntime>> tenantSpecificEventAdapters = new ConcurrentHashMap();
    private boolean startPollingTriggered = false;
    private boolean startTriggered = false;

    public void registerEventAdapterFactory(InputEventAdapterFactory inputEventAdapterFactory) {
        InputEventAdapterSchema inputEventAdapterSchema = inputEventAdapterFactory.getInputEventAdapterSchema();
        this.eventAdapterFactoryMap.put(inputEventAdapterSchema.getType(), inputEventAdapterFactory);
    }

    public void unRegisterEventAdapter(InputEventAdapterFactory inputEventAdapterFactory) {
        InputEventAdapterSchema inputEventAdapterSchema = inputEventAdapterFactory.getInputEventAdapterSchema();
        this.eventAdapterFactoryMap.remove(inputEventAdapterSchema.getType());
    }

    @Override
    public List<String> getInputEventAdapterTypes() {
        return new ArrayList<String>(this.eventAdapterFactoryMap.keySet());
    }

    @Override
    public InputEventAdapterSchema getInputEventAdapterSchema(String eventAdapterType) {
        InputEventAdapterFactory inputEventAdapterFactory = this.eventAdapterFactoryMap.get(eventAdapterType);
        if (inputEventAdapterFactory != null) {
            return inputEventAdapterFactory.getInputEventAdapterSchema();
        }
        return null;
    }

    @Override
    public void create(InputEventAdapterConfiguration inputEventAdapterConfiguration, InputEventAdapterSubscription inputEventAdapterSubscription) throws InputEventAdapterException {
        InputEventAdapterFactory adapterFactory;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputAdapterRuntime> eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        if (eventAdapters == null) {
            this.tenantSpecificEventAdapters.putIfAbsent(tenantId, new ConcurrentHashMap());
            eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        }
        if ((adapterFactory = this.eventAdapterFactoryMap.get(inputEventAdapterConfiguration.getType())) == null) {
            throw new InputEventAdapterException("Input Event Adapter not created as no adapter factory is registered with type " + inputEventAdapterConfiguration.getType());
        }
        if (inputEventAdapterConfiguration.getName() == null) {
            throw new InputEventAdapterException("Input Event Adapter name cannot be null, for the adapter type " + inputEventAdapterConfiguration.getType());
        }
        if (eventAdapters.get(inputEventAdapterConfiguration.getName()) != null) {
            throw new InputEventAdapterException("Input Event Adapter not created as another adapter with same name '" + inputEventAdapterConfiguration.getName() + "' already exist for tenant " + tenantId);
        }
        Map<String, String> globalProperties = InputEventAdapterServiceValueHolder.getGlobalAdapterConfigs().getAdapterConfig(inputEventAdapterConfiguration.getType()).getGlobalPropertiesAsMap();
        InputEventAdapter inputEventAdapter = adapterFactory.createEventAdapter(inputEventAdapterConfiguration, globalProperties);
        InputAdapterRuntime inputAdapterRuntime = new InputAdapterRuntime(inputEventAdapter, inputEventAdapterConfiguration.getName(), inputEventAdapterSubscription);
        eventAdapters.put(inputEventAdapterConfiguration.getName(), inputAdapterRuntime);
        if (this.startTriggered) {
            inputAdapterRuntime.start();
        }
        if (this.startPollingTriggered) {
            inputAdapterRuntime.startPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(InputEventAdapterConfiguration inputEventAdapterConfiguration) throws InputEventAdapterException, TestConnectionNotSupportedException {
        InputEventAdapter inputEventAdapter = null;
        TestConnectionAdapterListener adaptorSubscription = null;
        try {
            InputEventAdapterFactory inputEventAdapterFactory = this.eventAdapterFactoryMap.get(inputEventAdapterConfiguration.getType());
            InputEventAdapterFactory adapterFactory = this.eventAdapterFactoryMap.get(inputEventAdapterConfiguration.getType());
            if (adapterFactory == null) {
                throw new InputEventAdapterException("Input Event Adapter not created as no adapter factory is registered with type " + inputEventAdapterConfiguration.getType());
            }
            if (inputEventAdapterConfiguration.getName() == null) {
                throw new InputEventAdapterException("Input Event Adapter name cannot by null, for the adapter type " + inputEventAdapterConfiguration.getType());
            }
            Map<String, String> globalProperties = InputEventAdapterServiceValueHolder.getGlobalAdapterConfigs().getAdapterConfig(inputEventAdapterConfiguration.getType()).getGlobalPropertiesAsMap();
            inputEventAdapter = inputEventAdapterFactory.createEventAdapter(inputEventAdapterConfiguration, globalProperties);
            adaptorSubscription = new TestConnectionAdapterListener();
            inputEventAdapter.init(adaptorSubscription);
            inputEventAdapter.testConnect();
            inputEventAdapter.disconnect();
            inputEventAdapter.destroy();
        }
        finally {
            if (inputEventAdapter != null) {
                inputEventAdapter.destroy();
            }
        }
        ConnectionUnavailableException exception = adaptorSubscription.getConnectionUnavailableException();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void destroy(String name) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputAdapterRuntime> eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        if (eventAdapters == null) {
            return;
        }
        InputAdapterRuntime inputAdapterRuntime = eventAdapters.remove(name);
        if (inputAdapterRuntime != null) {
            inputAdapterRuntime.destroy();
        }
    }

    public ConcurrentHashMap<Integer, ConcurrentHashMap<String, InputAdapterRuntime>> getTenantSpecificEventAdapters() {
        return this.tenantSpecificEventAdapters;
    }

    @Override
    public InputEventAdapterListener getInputAdapterRuntime(int tenantId, String eventAdapterName) {
        ConcurrentHashMap<String, InputAdapterRuntime> tenantRuntimes = this.tenantSpecificEventAdapters.get(tenantId);
        if (tenantRuntimes != null) {
            return tenantRuntimes.get(eventAdapterName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPolling() {
        this.startPollingTriggered = true;
        for (Map.Entry<Integer, ConcurrentHashMap<String, InputAdapterRuntime>> pair : this.tenantSpecificEventAdapters.entrySet()) {
            Map map = pair.getValue();
            int tenantId = pair.getKey();
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
                for (InputAdapterRuntime inputAdapterRuntime : map.values()) {
                    inputAdapterRuntime.startPolling();
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to startTriggered event adapters for tenant :" + tenantId), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.startTriggered = true;
        for (Map.Entry<Integer, ConcurrentHashMap<String, InputAdapterRuntime>> pair : this.tenantSpecificEventAdapters.entrySet()) {
            Map map = pair.getValue();
            int tenantId = pair.getKey();
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
                for (InputAdapterRuntime inputAdapterRuntime : map.values()) {
                    inputAdapterRuntime.start();
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to start event adapters for tenant :" + tenantId), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public boolean isEventDuplicatedInCluster(String inputEventAdapterName) throws InputEventAdapterException {
        InputAdapterRuntime inputAdapterRuntime;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputAdapterRuntime> inputRuntimeMap = this.tenantSpecificEventAdapters.get(tenantId);
        if (inputRuntimeMap != null && (inputAdapterRuntime = inputRuntimeMap.get(inputEventAdapterName)) != null) {
            return inputAdapterRuntime.isEventDuplicatedInCluster();
        }
        throw new InputEventAdapterException("Adapter with name '" + inputEventAdapterName + "' not found");
    }

    @Override
    public void start(String inputEventAdapterName) {
        InputAdapterRuntime inputAdapterRuntime;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputAdapterRuntime> inputRuntimeMap = this.tenantSpecificEventAdapters.get(tenantId);
        if (inputRuntimeMap != null && (inputAdapterRuntime = inputRuntimeMap.get(inputEventAdapterName)) != null) {
            inputAdapterRuntime.start();
        }
    }
}

