/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.service.andes;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.server.security.AbstractPlugin;
import org.wso2.andes.server.security.Result;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.security.SecurityPluginFactory;
import org.wso2.andes.server.security.access.ObjectProperties;
import org.wso2.andes.server.security.access.ObjectType;
import org.wso2.andes.server.security.access.Operation;
import org.wso2.carbon.andes.authorization.andes.AndesAuthorizationHandler;
import org.wso2.carbon.andes.authorization.andes.AndesAuthorizationHandlerException;
import org.wso2.carbon.andes.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class AndesAuthorizationPlugin
extends AbstractPlugin {
    private static final Log logger = LogFactory.getLog(AndesAuthorizationPlugin.class);
    private static final String DOMAIN_NAME_SEPARATOR = "!";
    public static final SecurityPluginFactory<AndesAuthorizationPlugin> FACTORY = new SecurityPluginFactory<AndesAuthorizationPlugin>(){

        public AndesAuthorizationPlugin newInstance(ConfigurationPlugin config) throws ConfigurationException {
            return new AndesAuthorizationPlugin();
        }

        public String getPluginName() {
            return AndesAuthorizationPlugin.class.getName();
        }

        public Class<AndesAuthorizationPlugin> getPluginClass() {
            return AndesAuthorizationPlugin.class;
        }
    };

    public Result access(ObjectType objectType, Object instance) {
        try {
            Subject subject = SecurityManager.getThreadSubject();
            Principal principal = (Principal)subject.getPrincipals().toArray()[0];
            if (principal == null) {
                return this.getDefault();
            }
            if (objectType == ObjectType.VIRTUALHOST) {
                return Result.ALLOWED;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Authorising access to broker failed.", (Throwable)e);
        }
        return Result.DENIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            Subject subject = SecurityManager.getThreadSubject();
            Principal principal = null;
            if (subject != null) {
                principal = (Principal)subject.getPrincipals().toArray()[0];
            }
            if (principal == null) {
                Result result = this.getDefault();
                return result;
            }
            String username = principal.getName();
            if (username.contains(DOMAIN_NAME_SEPARATOR)) {
                String tenantDomain = username.substring(username.lastIndexOf(DOMAIN_NAME_SEPARATOR) + 1);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
            } else {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            }
            UserRealm userRealm = AndesAuthorizationPlugin.getUserRealm(username);
            int domainNameSeparatorIndex = username.lastIndexOf(DOMAIN_NAME_SEPARATOR);
            if (-1 != domainNameSeparatorIndex) {
                username = username.substring(0, domainNameSeparatorIndex).replaceAll(DOMAIN_NAME_SEPARATOR, "@");
            }
            switch (operation) {
                case CREATE: {
                    if (ObjectType.EXCHANGE == objectType) {
                        Result result = Result.ALLOWED;
                        return result;
                    }
                    if (ObjectType.QUEUE == objectType) {
                        Result result = AndesAuthorizationHandler.handleCreateQueue(username, userRealm, properties, operation);
                        return result;
                    }
                }
                case BIND: {
                    Result result = AndesAuthorizationHandler.handleBindQueue(username, userRealm, properties, operation);
                    return result;
                }
                case PUBLISH: {
                    Result result = AndesAuthorizationHandler.handlePublishToExchange(username, userRealm, properties, operation);
                    return result;
                }
                case CONSUME: {
                    Result result = AndesAuthorizationHandler.handleConsumeQueue(username, userRealm, properties, operation);
                    return result;
                }
                case BROWSE: {
                    Result result = AndesAuthorizationHandler.handleBrowseQueue(username, userRealm, properties, operation);
                    return result;
                }
                case UNBIND: {
                    Result result = AndesAuthorizationHandler.handleUnbindQueue(username, userRealm, properties, operation);
                    return result;
                }
                case DELETE: {
                    if (ObjectType.EXCHANGE == objectType) {
                        Result result = Result.ALLOWED;
                        return result;
                    }
                    if (ObjectType.QUEUE == objectType) {
                        Result result = AndesAuthorizationHandler.handleDeleteQueue(username, userRealm, properties, operation);
                        return result;
                    }
                }
                case PURGE: {
                    Result result = AndesAuthorizationHandler.handlePurgeQueue(username, userRealm, properties, operation);
                    return result;
                }
            }
            return Result.DENIED;
        }
        catch (AndesAuthorizationHandlerException e) {
            logger.error((Object)"Error while invoking AndesAuthorizationHandler", (Throwable)e);
            return Result.DENIED;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private static UserRealm getUserRealm(String username) {
        UserRealm userRealm = null;
        RealmService realmService = AuthorizationServiceDataHolder.getInstance().getRealmService();
        if (null != realmService) {
            try {
                int tenantID = !username.contains(DOMAIN_NAME_SEPARATOR) ? -1234 : realmService.getTenantManager().getTenantId(username.substring(username.lastIndexOf(DOMAIN_NAME_SEPARATOR) + 1));
                userRealm = realmService.getTenantUserRealm(tenantID);
            }
            catch (UserStoreException e) {
                logger.error((Object)("Error while getting tenant user realm for user " + username), (Throwable)e);
            }
            catch (NullPointerException e) {
                logger.error((Object)"Error while accessing the realm service.", (Throwable)e);
            }
        }
        return userRealm;
    }
}

