/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;
import org.wso2.andes.server.security.SecurityPluginFactory;
import org.wso2.carbon.andes.authorization.config.AuthorizationConfigurationManager;
import org.wso2.carbon.andes.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.andes.authorization.service.andes.AndesAuthorizationPlugin;
import org.wso2.carbon.andes.authorization.service.andes.AndesAuthorizationPluginConfiguration;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.andes.authorization.internal.AuthorizationServiceComponent", immediate=true)
public class AuthorizationServiceComponent {
    private static final Log log = LogFactory.getLog(AuthorizationServiceComponent.class);
    private ServiceRegistration securityPluginFactory = null;
    private ServiceRegistration configurationPluginFactory = null;
    private static final String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static final int CARBON_DEFAULT_PORT_OFFSET = 0;

    @Activate
    protected void activate(ComponentContext ctx) {
        try {
            AndesConfigurationManager.initialize((int)this.getPortOffset());
            AuthorizationConfigurationManager.getInstance().initConfig();
            this.securityPluginFactory = ctx.getBundleContext().registerService(SecurityPluginFactory.class.getName(), AndesAuthorizationPlugin.FACTORY, null);
            this.configurationPluginFactory = ctx.getBundleContext().registerService(ConfigurationPluginFactory.class.getName(), (Object)AndesAuthorizationPluginConfiguration.FACTORY, null);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to activate org.wso2.carbon.andes.authorization.internal.AuthorizationServiceComponent : " + e));
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (null != this.securityPluginFactory) {
            this.securityPluginFactory.unregister();
        }
        if (null != this.configurationPluginFactory) {
            this.configurationPluginFactory.unregister();
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        AuthorizationServiceDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        AuthorizationServiceDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        AuthorizationServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AuthorizationServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
    }

    private int getPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = System.getProperty("portOffset", carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET));
        try {
            if (portOffset != null) {
                return Integer.parseInt(portOffset.trim());
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

