/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.andes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.server.IAuthorizer;
import org.wso2.andes.configuration.enums.MQTTAuthoriztionPermissionLevel;
import org.wso2.andes.mqtt.MQTTAuthorizationSubject;
import org.wso2.carbon.andes.authorization.config.AuthorizationConfigurationManager;
import org.wso2.carbon.andes.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.authorization.TreeNode;

public class CarbonPermissionBasedMQTTAuthorizer
implements IAuthorizer {
    private static final Log logger = LogFactory.getLog(CarbonPermissionBasedMQTTAuthorizer.class);
    private static final String PERMISSION_PREFIX = "/permission/admin/mqtt/topic/";
    private static final String CONNECTION_PERMISSION_CONFIG = "connectionPermission";

    public boolean isAuthorizedForTopic(MQTTAuthorizationSubject authorizationSubject, String topic, MQTTAuthoriztionPermissionLevel permissionLevel) {
        String permission = this.getPermissionStringFromTopic(topic);
        String permissionAction = TreeNode.Permission.SUBSCRIBE.toString().toLowerCase();
        if (permissionLevel == MQTTAuthoriztionPermissionLevel.PUBLISH) {
            permissionAction = TreeNode.Permission.PUBLISH.toString().toLowerCase();
        }
        return this.isUserAuthorized(authorizationSubject, permission, permissionAction);
    }

    public boolean isAuthorizedToConnect(MQTTAuthorizationSubject authorizationSubject) {
        String permission = AuthorizationConfigurationManager.getInstance().getProperty(CONNECTION_PERMISSION_CONFIG);
        if (permission != null && !permission.isEmpty()) {
            String permissionAction = TreeNode.Permission.AUTHORIZE.toString().toLowerCase();
            return this.isUserAuthorized(authorizationSubject, permission, permissionAction);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserAuthorized(MQTTAuthorizationSubject authorizationSubject, String permission, String action) {
        String username = authorizationSubject.getUsername();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(authorizationSubject.getTenantDomain(), true);
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserRealm userRealm = AuthorizationServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
            if (userRealm != null && userRealm.getAuthorizationManager() != null) {
                boolean bl = userRealm.getAuthorizationManager().isUserAuthorized(username, permission, action);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (UserStoreException e) {
            String errorMsg = String.format("Unable to authorize the user : %s", username);
            logger.error((Object)errorMsg, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private String getPermissionStringFromTopic(String topic) {
        String permission = topic;
        if (topic != null && !topic.isEmpty()) {
            if (permission.charAt(0) == '/') {
                permission = permission.substring(1, permission.length());
            }
            permission = permission.split("\\+")[0];
            permission = permission.split("#")[0];
            permission = PERMISSION_PREFIX + permission;
            if (permission.charAt(permission.length() - 1) == '/') {
                permission = permission.substring(0, permission.length() - 1);
            }
        }
        return permission;
    }
}

