/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authorization.andes;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.security.Result;
import org.wso2.andes.server.security.access.ObjectProperties;
import org.wso2.andes.server.security.access.Operation;
import org.wso2.carbon.andes.authorization.andes.AndesAuthorizationHandlerException;
import org.wso2.carbon.andes.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.commons.registry.RegistryClient;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AndesAuthorizationHandler {
    private static final Log log = LogFactory.getLog(AndesAuthorizationHandler.class);
    private static final String DEFAULT_EXCHANGE = "default";
    private static final String DIRECT_EXCHANGE = "amq.direct";
    private static final String TOPIC_EXCHANGE = "amq.topic";
    private static final String PERMISSION_CHANGE_PERMISSION = "changePermission";
    private static final String AT_REPLACE_CHAR = "_";
    private static final String UI_EXECUTE = "ui.execute";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_ADD = "/permission/admin/manage/queue/add";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_DELETE = "/permission/admin/manage/queue/delete";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_PURGE = "/permission/admin/manage/queue/purge";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_BROWSE = "/permission/admin/manage/queue/browse";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_ADD = "/permission/admin/manage/topic/add";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_DELETE = "/permission/admin/manage/topic/delete";
    private static final String QUEUE_ROLE_PREFIX = "Q_";
    private static final String TOPIC_ROLE_PREFIX = "T_";
    private static final String TEMP_QUEUE_SUFFIX = "tmp_";
    private static final String SPACE = " ";
    private static final String PARENT_RESOURCE_PATH = "\\bevent/topics/\\b";
    private static Map<String, String> temporaryQueueToTopicMap = new HashMap<String, String>();

    public static Result handleCreateQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        try {
            if (null != userRealm) {
                if (!AndesAuthorizationHandler.isOwnDomain((String)properties.get((Object)ObjectProperties.Property.NAME), userRealm, properties)) {
                    accessResult = Result.DENIED;
                } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    AndesAuthorizationHandler.registerAndAuthorizeQueue(username, userRealm, properties);
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_ADD, UI_EXECUTE)) {
                    AndesAuthorizationHandler.registerAndAuthorizeQueue(username, userRealm, properties);
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_ADD, UI_EXECUTE)) {
                    AndesAuthorizationHandler.registerAndAuthorizeQueue(username, userRealm, properties);
                    accessResult = Result.ALLOWED;
                } else if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue()) {
                    AndesAuthorizationHandler.registerAndAuthorizeQueue(username, userRealm, properties);
                    accessResult = Result.ALLOWED;
                } else if (AndesAuthorizationHandler.isTopicSubscriberQueue((String)properties.get((Object)ObjectProperties.Property.NAME)) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                    AndesAuthorizationHandler.registerAndAuthorizeQueue(username, userRealm, properties);
                    accessResult = Result.ALLOWED;
                }
            }
        }
        catch (RegistryClientException | UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling create queue.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.NAME)));
        }
        return accessResult;
    }

    public static Result handleConsumeQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        if (null == userRealm) {
            accessResult = Result.DENIED;
        } else {
            String routingKey = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
            String queueID = CommonsUtil.getQueueID((String)routingKey);
            try {
                String topicId;
                String topicName;
                if (!AndesAuthorizationHandler.isOwnDomain((String)properties.get((Object)ObjectProperties.Property.NAME), userRealm, properties)) {
                    accessResult = Result.DENIED;
                } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                    accessResult = Result.ALLOWED;
                } else if (AndesAuthorizationHandler.isTopicSubscriberQueue((String)properties.get((Object)ObjectProperties.Property.NAME)) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && null != (topicName = temporaryQueueToTopicMap.get(properties.get((Object)ObjectProperties.Property.NAME))) && AndesAuthorizationHandler.isAuthorizeToParentInHierarchy(username, userRealm, topicId = CommonsUtil.getTopicID((String)RegistryClient.getTenantBasedTopicName((String)topicName)), TreeNode.Permission.SUBSCRIBE)) {
                    accessResult = Result.ALLOWED;
                }
            }
            catch (RegistryClientException | UserStoreException e) {
                throw new AndesAuthorizationHandlerException("Error handling consume queue.", e);
            }
        }
        if (log.isDebugEnabled()) {
            if (AndesAuthorizationHandler.isTopicSubscriberQueue((String)properties.get((Object)ObjectProperties.Property.NAME)) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                String topicName = temporaryQueueToTopicMap.get(properties.get((Object)ObjectProperties.Property.NAME));
                log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + topicName));
            } else {
                log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.NAME)));
            }
        }
        return accessResult;
    }

    public static Result handleBrowseQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        if (null != userRealm) {
            try {
                if (!AndesAuthorizationHandler.isOwnDomain((String)properties.get((Object)ObjectProperties.Property.NAME), userRealm, properties)) {
                    accessResult = Result.DENIED;
                } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_BROWSE, UI_EXECUTE)) {
                    accessResult = Result.ALLOWED;
                }
                return accessResult;
            }
            catch (UserStoreException e) {
                throw new AndesAuthorizationHandlerException("Error handling browse queue.", e);
            }
        }
        accessResult = Result.DENIED;
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.NAME)));
        }
        return accessResult;
    }

    public static Result handleBindQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        try {
            if (null != userRealm) {
                String exchangeName = AndesAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String queueName = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME));
                String routingKey = AndesAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
                String queueID = CommonsUtil.getQueueID((String)queueName);
                String topicId = CommonsUtil.getTopicID((String)RegistryClient.getTenantBasedTopicName((String)routingKey));
                switch (exchangeName) {
                    case "default": {
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                        } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_ADD, UI_EXECUTE)) {
                            accessResult = Result.ALLOWED;
                        } else if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue()) {
                            accessResult = Result.ALLOWED;
                        } else if (AndesAuthorizationHandler.isTopicSubscriberQueue(queueName) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                            accessResult = Result.ALLOWED;
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME)));
                        break;
                    }
                    case "amq.direct": {
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                        } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase())) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_ADD, UI_EXECUTE)) {
                            accessResult = Result.ALLOWED;
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME)));
                        break;
                    }
                    case "amq.topic": {
                        String newRoutingKey = routingKey.replace("@", AT_REPLACE_CHAR);
                        String roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + newRoutingKey.replace(".*", "").replace(".#", "").replace(".", "-").replace("/", "-")));
                        UserStoreManager userStoreManager = userRealm.getUserStoreManager();
                        String newQName = queueName.replace("@", AT_REPLACE_CHAR);
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                        } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            RegistryClient.createSubscription((String)newRoutingKey, (String)newQName, (String)username);
                            temporaryQueueToTopicMap.put(queueName, routingKey);
                            String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username);
                            String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
                            String role = null;
                            for (String userRole : userRoles) {
                                if (!userRole.equals(adminRole)) continue;
                                role = userRole;
                                break;
                            }
                            AndesAuthorizationHandler.grantPermissionToHierarchyLevel(username, userRealm, topicId, role);
                            accessResult = Result.ALLOWED;
                        } else if (!userStoreManager.isExistingRole(roleName) && !userRealm.getAuthorizationManager().isUserAuthorized(username, topicId, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase()) && !userRealm.getAuthorizationManager().isUserAuthorized(username, topicId, TreeNode.Permission.PUBLISH.toString().toLowerCase()) && userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_ADD, UI_EXECUTE)) {
                            boolean isAdminAuthorized = false;
                            if (RegistryClient.isResourceExist((String)CommonsUtil.getTopicID((String)RegistryClient.getTenantBasedTopicName((String)newRoutingKey)))) {
                                isAdminAuthorized = true;
                            }
                            if (!isAdminAuthorized) {
                                RegistryClient.createSubscription((String)newRoutingKey, (String)newQName, (String)username);
                                AndesAuthorizationHandler.authorizeTopicPermissionsToLoggedInUser(username, newRoutingKey, topicId, queueName, userRealm);
                                accessResult = Result.ALLOWED;
                            }
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, topicId, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase())) {
                            RegistryClient.createSubscription((String)newRoutingKey, (String)newQName, (String)username);
                            if (AndesAuthorizationHandler.isTopicSubscriberQueue(queueName) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                                temporaryQueueToTopicMap.put(queueName, routingKey);
                            } else {
                                String[] userRoles;
                                for (String userRole : userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username)) {
                                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(userRole, topicId, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase())) continue;
                                    AndesAuthorizationHandler.authorizeRoleToPublishConsume(userRealm, userRole, queueID);
                                }
                            }
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_ADD, UI_EXECUTE)) {
                            accessResult = Result.ALLOWED;
                        } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, topicId, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                            accessResult = Result.ALLOWED;
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY)));
                    }
                }
            }
        }
        catch (RegistryClientException | UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling bind queue.", e);
        }
        return accessResult;
    }

    public static Result handlePublishToExchange(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        try {
            if (null != userRealm) {
                String exchangeName = AndesAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
                String routingKey = AndesAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
                String queueID = CommonsUtil.getQueueID((String)routingKey);
                String permissionID = CommonsUtil.getTopicID((String)RegistryClient.getTenantBasedTopicName((String)routingKey));
                switch (exchangeName) {
                    case "amq.direct": {
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                            break;
                        }
                        if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            accessResult = Result.ALLOWED;
                            break;
                        }
                        if (!userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) break;
                        accessResult = Result.ALLOWED;
                        break;
                    }
                    case "amq.topic": {
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                            break;
                        }
                        if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            accessResult = Result.ALLOWED;
                            break;
                        }
                        if (!AndesAuthorizationHandler.isAuthorizeToParentInHierarchy(username, userRealm, permissionID, TreeNode.Permission.PUBLISH)) break;
                        accessResult = Result.ALLOWED;
                        break;
                    }
                    case "default": {
                        if (!AndesAuthorizationHandler.isOwnDomain(routingKey, userRealm, properties)) {
                            accessResult = Result.DENIED;
                            break;
                        }
                        if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                            accessResult = Result.ALLOWED;
                            break;
                        }
                        if (!userRealm.getAuthorizationManager().isUserAuthorized(username, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) break;
                        accessResult = Result.ALLOWED;
                    }
                }
            }
        }
        catch (UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling publish queue.", e);
        }
        catch (RegistryClientException e) {
            throw new AndesAuthorizationHandlerException("Error checking permission hierarchy", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY)));
        }
        return accessResult;
    }

    public static Result handleUnbindQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        String exchangeName = AndesAuthorizationHandler.getRawExchangeName((String)properties.get((Object)ObjectProperties.Property.NAME));
        String queueName = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.QUEUE_NAME));
        String routingKey = AndesAuthorizationHandler.getRawRoutingKey((String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY));
        String newRoutingKey = routingKey.replace("@", AT_REPLACE_CHAR);
        String newQName = queueName.replace("@", AT_REPLACE_CHAR);
        try {
            if (TOPIC_EXCHANGE.equals(exchangeName)) {
                RegistryClient.deleteSubscription((String)newRoutingKey, (String)newQName);
                temporaryQueueToTopicMap.remove(queueName);
                if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username);
                    String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
                    String role = null;
                    for (String userRole : userRoles) {
                        if (!userRole.equals(adminRole)) continue;
                        role = userRole;
                        break;
                    }
                    String queueID = CommonsUtil.getQueueID((String)queueName);
                    String topicId = CommonsUtil.getTopicID((String)RegistryClient.getTenantBasedTopicName((String)routingKey));
                    userRealm.getAuthorizationManager().clearRoleAuthorization(role, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase());
                    userRealm.getAuthorizationManager().clearRoleAuthorization(role, topicId, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase());
                    userRealm.getAuthorizationManager().clearRoleAuthorization(role, topicId, TreeNode.Permission.PUBLISH.toString().toLowerCase());
                    userRealm.getAuthorizationManager().clearRoleAuthorization(role, topicId, PERMISSION_CHANGE_PERMISSION);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(username + SPACE + Result.ALLOWED.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.ROUTING_KEY)));
            }
            return Result.ALLOWED;
        }
        catch (RegistryClientException | UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling unbind queue.", e);
        }
    }

    public static Result handleDeleteQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        try {
            if (null != userRealm) {
                String queueName = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
                if (!AndesAuthorizationHandler.isOwnDomain(queueName, userRealm, properties)) {
                    accessResult = Result.DENIED;
                } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_DELETE, UI_EXECUTE)) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_DELETE, UI_EXECUTE)) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue()) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (AndesAuthorizationHandler.isTopicSubscriberQueue(queueName) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                }
            }
        }
        catch (RegistryClientException | UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling delete queue.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.NAME)));
        }
        return accessResult;
    }

    public static Result handlePurgeQueue(String username, UserRealm userRealm, ObjectProperties properties, Operation operation) throws AndesAuthorizationHandlerException {
        Result accessResult = Result.DENIED;
        try {
            if (null != userRealm) {
                String queueName = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
                if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_PURGE, UI_EXECUTE)) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue()) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                } else if (AndesAuthorizationHandler.isTopicSubscriberQueue(queueName) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                    AndesAuthorizationHandler.deleteQueueFromRegistry(queueName);
                    accessResult = Result.ALLOWED;
                }
            }
        }
        catch (RegistryClientException | UserStoreException e) {
            throw new AndesAuthorizationHandlerException("Error handling purge queue.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + SPACE + accessResult.toString().toLowerCase() + SPACE + operation.toString() + SPACE + (String)properties.get((Object)ObjectProperties.Property.NAME)));
        }
        return accessResult;
    }

    private static void registerAndAuthorizeQueue(String username, UserRealm userRealm, ObjectProperties properties) throws RegistryClientException, UserStoreException {
        String queueName = AndesAuthorizationHandler.getRawQueueName((String)properties.get((Object)ObjectProperties.Property.NAME));
        if (AndesAuthorizationHandler.isOwnDomain((String)properties.get((Object)ObjectProperties.Property.NAME), userRealm, properties)) {
            String newQueueName = queueName.replace("@", AT_REPLACE_CHAR);
            RegistryClient.createQueue((String)newQueueName, (String)username);
            if (log.isDebugEnabled()) {
                log.debug((Object)(queueName + " created in the registry"));
            }
            String queueID = CommonsUtil.getQueueID((String)queueName);
            boolean isCreateRole = true;
            if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue()) {
                isCreateRole = false;
            } else if (AndesAuthorizationHandler.isTopicSubscriberQueue((String)properties.get((Object)ObjectProperties.Property.NAME)) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                isCreateRole = false;
            } else if (AndesAuthorizationHandler.isAdmin(username, userRealm)) {
                isCreateRole = false;
            }
            if (isCreateRole) {
                AndesAuthorizationHandler.authorizeQueuePermissionsToLoggedInUser(username, newQueueName, queueID, userRealm);
            }
        }
    }

    private static boolean isAdmin(String username, UserRealm userRealm) throws UserStoreException {
        boolean isAdmin = false;
        String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username);
        String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
        for (String userRole : userRoles) {
            if (!userRole.equals(adminRole)) continue;
            isAdmin = true;
            break;
        }
        return isAdmin;
    }

    private static void deleteQueueFromRegistry(String queueName) throws RegistryClientException, UserStoreException {
        String newQName = queueName.replace("@", AT_REPLACE_CHAR);
        RegistryClient.deleteQueue((String)queueName);
        if (log.isDebugEnabled()) {
            log.debug((Object)(queueName + " deleted from the registry"));
        }
        if (!AndesKernelBoot.isKernelShuttingDown()) {
            AndesAuthorizationHandler.removeQueueRoleCreateForLoggedInUser(newQName);
        }
    }

    private static String getRawQueueName(String queueName) {
        if (queueName.contains(";")) {
            queueName = queueName.substring(0, queueName.indexOf(";"));
        }
        return queueName.substring(queueName.indexOf(":") + 1, queueName.length());
    }

    private static String getRawRoutingKey(String routingKey) {
        String virtualHostFormatted = "carbon:";
        int startIndex = !routingKey.contains(virtualHostFormatted) ? 0 : routingKey.indexOf(virtualHostFormatted);
        return routingKey.substring(startIndex, routingKey.length());
    }

    private static String getRawExchangeName(String exchangeName) {
        return exchangeName.equals("<<default>>") ? DEFAULT_EXCHANGE : exchangeName;
    }

    private static boolean isOwnDomain(String routingKey, UserRealm userRealm, ObjectProperties properties) throws UserStoreException {
        boolean isOwnDomain = false;
        RealmService realmService = AuthorizationServiceDataHolder.getInstance().getRealmService();
        String tenantDomain = realmService.getTenantManager().getDomain(userRealm.getAuthorizationManager().getTenantId());
        if (tenantDomain != null) {
            if (!routingKey.substring(routingKey.contains("/") ? routingKey.indexOf("/") + 1 : 0).isEmpty()) {
                if (routingKey.length() >= tenantDomain.length() + 1 && routingKey.substring(0, tenantDomain.length() + 1).equals(tenantDomain + "/")) {
                    isOwnDomain = true;
                } else if (tenantDomain.equalsIgnoreCase("carbon.super")) {
                    if (!routingKey.contains("/")) {
                        isOwnDomain = true;
                    }
                } else if (AndesAuthorizationHandler.isTopicSubscriberQueue(routingKey) && !Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue()) {
                    isOwnDomain = true;
                } else if (Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.DURABLE)).booleanValue() && Boolean.valueOf((String)properties.get((Object)ObjectProperties.Property.EXCLUSIVE)).booleanValue() && routingKey.substring(routingKey.lastIndexOf(":") + 1).startsWith(tenantDomain)) {
                    isOwnDomain = true;
                }
            }
        } else if (!routingKey.contains("/")) {
            isOwnDomain = true;
        }
        return isOwnDomain;
    }

    private static boolean isTopicSubscriberQueue(String queueName) {
        return queueName.startsWith(TEMP_QUEUE_SUFFIX);
    }

    private static void authorizeQueuePermissionsToLoggedInUser(String username, String queueName, String queueId, UserRealm userRealm) throws UserStoreException {
        if (DLCQueueUtils.isDeadLetterQueue((String)queueName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Dead letter channel permission to subscribe or consume is not granted to users");
            }
            return;
        }
        String roleName = UserCoreUtil.addInternalDomainName((String)(QUEUE_ROLE_PREFIX + queueName.replace(".", "-").replace("/", "-")));
        UserStoreManager userStoreManager = userRealm.getUserStoreManager();
        if (!userStoreManager.isExistingRole(roleName)) {
            String[] user = new String[]{MultitenantUtils.getTenantAwareUsername((String)username)};
            userStoreManager.addRole(roleName, user, null);
            AndesAuthorizationHandler.authorizeRoleToPublishConsume(userRealm, roleName, queueId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("permission granted to user = " + username + " role = " + roleName + " queue = " + queueName + " queueId = " + queueId));
            }
        } else {
            log.warn((Object)("Unable to provide permissions to the user,  " + username + ", to subscribe and publish to " + queueName));
        }
    }

    private static void authorizeTopicPermissionsToLoggedInUser(String username, String topicName, String topicId, String queueName, UserRealm userRealm) throws UserStoreException {
        String roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + topicName.replace(".*", "").replace(".#", "").replace(".", "-").replace("/", "-")));
        UserStoreManager userStoreManager = userRealm.getUserStoreManager();
        String[] user = new String[]{MultitenantUtils.getTenantAwareUsername((String)username)};
        String tempQueueId = CommonsUtil.getQueueID((String)queueName);
        if (!userStoreManager.isExistingRole(roleName)) {
            userStoreManager.addRole(roleName, user, null);
        }
        boolean userShouldBeAdded = true;
        for (String foundUser : userStoreManager.getUserListOfRole(roleName)) {
            if (!username.equals(foundUser)) continue;
            userShouldBeAdded = false;
            break;
        }
        if (userShouldBeAdded) {
            userStoreManager.updateUserListOfRole(roleName, new String[0], user);
        }
        AndesAuthorizationHandler.grantPermissionToHierarchyLevel(username, userRealm, topicId, roleName);
        if (AndesAuthorizationHandler.isTopicSubscriberQueue(queueName)) {
            temporaryQueueToTopicMap.put(queueName, topicName);
        } else {
            AndesAuthorizationHandler.authorizeRoleToPublishConsume(userRealm, roleName, tempQueueId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("permission granted to user = " + username + " role = " + roleName + " topic = " + topicName + " topicId = " + topicId));
        }
    }

    private static void removeQueueRoleCreateForLoggedInUser(String queueName) throws UserStoreException {
        String roleName = UserCoreUtil.addInternalDomainName((String)(QUEUE_ROLE_PREFIX + queueName.replace(".", "-").replace("/", "-")));
        AuthorizationManager authorizationManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager();
        UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
        if (userStoreManager.isExistingRole(roleName)) {
            userStoreManager.deleteRole(roleName);
            authorizationManager.clearResourceAuthorizations(CommonsUtil.getQueueID((String)queueName));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("role " + roleName + " associated with queue " + queueName + " deleted"));
        }
    }

    private static void grantPermissionToHierarchyLevel(String username, UserRealm userRealm, String topicId, String role) throws UserStoreException {
        StringTokenizer tokenizer = new StringTokenizer(topicId, "/");
        StringBuilder resourcePathBuilder = new StringBuilder();
        int tokenCount = tokenizer.countTokens();
        int count = 0;
        Pattern pattern = Pattern.compile(PARENT_RESOURCE_PATH);
        while (tokenizer.hasMoreElements()) {
            String resource = tokenizer.nextElement().toString();
            resourcePathBuilder.append(resource);
            Matcher matcher = pattern.matcher(resourcePathBuilder.toString());
            if (matcher.find()) {
                AndesAuthorizationHandler.authorizeRole(userRealm, role, resourcePathBuilder.toString(), TreeNode.Permission.SUBSCRIBE.toString().toLowerCase());
                AndesAuthorizationHandler.authorizeRole(userRealm, role, resourcePathBuilder.toString(), TreeNode.Permission.PUBLISH.toString().toLowerCase());
                AndesAuthorizationHandler.authorizeRole(userRealm, role, resourcePathBuilder.toString(), PERMISSION_CHANGE_PERMISSION);
            }
            if (++count < tokenCount) {
                resourcePathBuilder.append("/");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("permission granted to user = " + username + " role = " + role + " hierarchical topic = " + resourcePathBuilder.toString()));
        }
    }

    private static boolean isAuthorizeToParentInHierarchy(String username, UserRealm userRealm, String topicId, TreeNode.Permission permission) throws UserStoreException, RegistryClientException {
        if (!RegistryClient.isResourceExist((String)topicId)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(topicId, "/");
        StringBuilder resourcePathBuilder = new StringBuilder();
        int tokenCount = tokenizer.countTokens();
        int count = 0;
        boolean userAuthorized = false;
        Pattern pattern = Pattern.compile(PARENT_RESOURCE_PATH);
        while (tokenizer.hasMoreElements()) {
            String resource = tokenizer.nextElement().toString();
            resourcePathBuilder.append(resource);
            Matcher matcher = pattern.matcher(resourcePathBuilder.toString());
            if (matcher.find() && userRealm.getAuthorizationManager().isUserAuthorized(username, resourcePathBuilder.toString(), permission.toString().toLowerCase())) {
                userAuthorized = true;
                break;
            }
            if (++count >= tokenCount) continue;
            resourcePathBuilder.append("/");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(username + " is authorized to parent hierarchy topic = " + resourcePathBuilder.toString() + " topicId = " + topicId + SPACE + userAuthorized));
        }
        return userAuthorized;
    }

    private static void authorizeRole(UserRealm userRealm, String role, String resourcePath, String action) throws UserStoreException {
        try {
            userRealm.getAuthorizationManager().authorizeRole(role, resourcePath, action);
        }
        catch (UserStoreException e) {
            log.warn((Object)("Could not authorize role: " + role + " to resourceID: " + resourcePath + " for action: " + action + ". Hence, retrying authorization"), (Throwable)e);
            userRealm.getAuthorizationManager().authorizeRole(role, resourcePath, action);
        }
    }

    private static void authorizeRoleToPublishConsume(UserRealm userRealm, String roleName, String resourcePath) throws UserStoreException {
        AndesAuthorizationHandler.authorizeRole(userRealm, roleName, resourcePath, TreeNode.Permission.CONSUME.toString().toLowerCase());
        AndesAuthorizationHandler.authorizeRole(userRealm, roleName, resourcePath, TreeNode.Permission.PUBLISH.toString().toLowerCase());
        AndesAuthorizationHandler.authorizeRole(userRealm, roleName, resourcePath, PERMISSION_CHANGE_PERMISSION);
    }
}

