/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementValidationException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.sts.common.config.SecurityServiceAdmin;
import org.wso2.carbon.identity.sts.common.sts.service.STSAdminServiceImpl;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.sts.service.util.TrustedServiceData;
import org.wso2.carbon.sts.internal.ApplicationManagementServiceComponentHolder;

public class STSApplicationMgtListener
extends AbstractApplicationMgtListener {
    private static Log log = LogFactory.getLog(STSApplicationMgtListener.class);

    public int getDefaultOrderId() {
        return 998;
    }

    public boolean doPreUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        this.handleWsTrustAssociationRemoval(serviceProvider);
        return true;
    }

    private void handleWsTrustAssociationRemoval(ServiceProvider sp) throws IdentityApplicationManagementException {
        InboundAuthenticationRequestConfig updatedWsTrustInbound;
        int appId = sp.getApplicationID();
        ServiceProvider storedSp = ApplicationMgtSystemConfig.getInstance().getApplicationDAO().getApplication(appId);
        InboundAuthenticationRequestConfig storedWstrustInbound = this.getWsTrustInbound(storedSp);
        if (this.isAssociationRemoved(storedWstrustInbound, updatedWsTrustInbound = this.getWsTrustInbound(sp))) {
            String trustedService = storedWstrustInbound.getInboundAuthKey();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WSTrust inbound with trustService: " + trustedService + " has been removed from service provider with id: " + appId + ". Removing the stale WSTrust data for trustService: " + trustedService));
                }
                STSAdminServiceImpl stsAdminService = new STSAdminServiceImpl();
                stsAdminService.removeTrustedService(trustedService);
            }
            catch (SecurityConfigException e) {
                String msg = "Error removing wsTrust inbound data with trustedService: %s associated with service provider with id: %s during application update.";
                throw new IdentityApplicationManagementException(String.format(msg, trustedService, appId), (Throwable)e);
            }
        }
    }

    private boolean isAssociationRemoved(InboundAuthenticationRequestConfig storedWsTrustConfig, InboundAuthenticationRequestConfig updatedWsTrustConfig) {
        return storedWsTrustConfig != null && updatedWsTrustConfig == null;
    }

    private InboundAuthenticationRequestConfig getWsTrustInbound(ServiceProvider sp) {
        if (sp != null && sp.getInboundAuthenticationConfig() != null && ArrayUtils.isNotEmpty((Object[])sp.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs())) {
            return Arrays.stream(sp.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()).filter(inbound -> "wstrust".equals(inbound.getInboundAuthType())).findAny().orElse(null);
        }
        return null;
    }

    public boolean doPreDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        ServiceProvider serviceProvider = appDAO.getApplication(applicationName, tenantDomain);
        if (serviceProvider != null && serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
            InboundAuthenticationRequestConfig[] configs;
            for (InboundAuthenticationRequestConfig config : configs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                if (!"wstrust".equalsIgnoreCase(config.getInboundAuthType()) || config.getInboundAuthKey() == null) continue;
                try {
                    AxisService stsService = this.getAxisConfig().getService("wso2carbon-sts");
                    Parameter origParam = stsService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                    if (origParam == null) {
                        throw new IdentityApplicationManagementException("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                    }
                    OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                    SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                    samlConfig.getTrustedServices().remove(config.getInboundAuthKey());
                    this.setSTSParameter(samlConfig);
                    STSAdminServiceImpl stsAdminService = new STSAdminServiceImpl();
                    stsAdminService.removeTrustedService(config.getInboundAuthKey());
                    break;
                }
                catch (Exception e) {
                    String error = "Error while removing a trusted service: " + config.getInboundAuthKey();
                    throw new IdentityApplicationManagementException(error, (Throwable)e);
                }
            }
        }
        return true;
    }

    public void onPreCreateInbound(ServiceProvider serviceProvider, boolean isUpdate) throws IdentityApplicationManagementException {
        ArrayList<String> validationMsg = new ArrayList<String>();
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) {
                if (!"wstrust".equals(authConfig.getInboundAuthType())) continue;
                if (authConfig.getInboundConfiguration() == null) break;
                TrustedServiceData trustedServiceData = this.unmarshalTrustedServiceData(authConfig.getInboundConfiguration(), serviceProvider.getApplicationName(), serviceProvider.getOwner().getTenantDomain());
                if (!authConfig.getInboundAuthKey().equals(trustedServiceData.getServiceAddress())) {
                    validationMsg.add(String.format("The Inbound Auth Key of the  application name %s is not match with ServiceAddress %s.", authConfig.getInboundAuthKey(), trustedServiceData.getServiceAddress()));
                }
                if (trustedServiceData.getCertAlias() != null && !"".equals(trustedServiceData.getCertAlias())) break;
                validationMsg.add(String.format("WS CertAlias is not provided  with ServiceAddress %s.", authConfig.getInboundAuthKey()));
                break;
            }
        }
        if (!validationMsg.isEmpty()) {
            throw new IdentityApplicationManagementValidationException(validationMsg.toArray(new String[0]));
        }
    }

    public void doImportServiceProvider(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) {
                if (!"wstrust".equals(authConfig.getInboundAuthType())) continue;
                TrustedServiceData trustedServiceData = this.unmarshalTrustedServiceData(authConfig.getInboundConfiguration(), serviceProvider.getApplicationName(), serviceProvider.getOwner().getTenantDomain());
                String inboundConfiguration = authConfig.getInboundConfiguration();
                if (StringUtils.isBlank((String)inboundConfiguration)) {
                    String errorMsg = String.format("No inbound configurations found for wstrust in the imported %s", serviceProvider.getApplicationName());
                    throw new IdentityApplicationManagementException(errorMsg);
                }
                try {
                    STSAdminServiceImpl stsAdminService = new STSAdminServiceImpl();
                    stsAdminService.addTrustedService(trustedServiceData.getServiceAddress(), trustedServiceData.getCertAlias());
                }
                catch (SecurityConfigException e) {
                    throw new IdentityApplicationManagementException(String.format("Error in adding trusted service data for %s", serviceProvider.getApplicationName()), (Throwable)e);
                }
            }
        }
    }

    public void doExportServiceProvider(ServiceProvider serviceProvider, Boolean exportSecrets) throws IdentityApplicationManagementException {
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) {
                if (!"wstrust".equals(authConfig.getInboundAuthType())) continue;
                String inboundAuthKey = authConfig.getInboundAuthKey();
                try {
                    STSAdminServiceImpl stsAdminService = new STSAdminServiceImpl();
                    TrustedServiceData[] trustedServices = stsAdminService.getTrustedServices();
                    if (trustedServices == null) continue;
                    for (TrustedServiceData trustedServiceData : trustedServices) {
                        if (!trustedServiceData.getServiceAddress().equals(inboundAuthKey)) continue;
                        authConfig.setInboundConfiguration(this.marshalTrustedServiceData(trustedServiceData));
                    }
                }
                catch (SecurityConfigException e) {
                    throw new IdentityApplicationManagementException(String.format("Error in getting trusted service data for %s", serviceProvider.getApplicationName()), (Throwable)e);
                }
            }
        }
    }

    private void setSTSParameter(SAMLTokenIssuerConfig samlConfig) throws AxisFault, RegistryException {
        new SecurityServiceAdmin(this.getAxisConfig(), this.getConfigSystemRegistry()).setServiceParameterElement("wso2carbon-sts", samlConfig.getParameter());
    }

    private AxisConfiguration getAxisConfig() {
        return ApplicationManagementServiceComponentHolder.getInstance().getConfigContextService().getServerConfigContext().getAxisConfiguration();
    }

    private Registry getConfigSystemRegistry() throws RegistryException {
        return (Registry)ApplicationManagementServiceComponentHolder.getInstance().getRegistryService().getConfigSystemRegistry();
    }

    private TrustedServiceData unmarshalTrustedServiceData(String inboundConfiguration, String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TrustedServiceData.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (TrustedServiceData)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(inboundConfiguration.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in unmarshelling Trusted Service Data %s@%s", serviceProviderName, tenantDomain), (Throwable)e);
        }
    }

    private String marshalTrustedServiceData(TrustedServiceData trustedServiceData) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TrustedServiceData.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal((Object)trustedServiceData, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in exporting Trusted Service Data %s", trustedServiceData.getServiceAddress()), (Throwable)e);
        }
    }
}

