/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityAttributeService;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.sts.STSDeploymentInterceptor;
import org.wso2.carbon.sts.STSDeploymentListener;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

@Component(name="carbon.sts.component", immediate=true)
public class STSServiceComponent {
    private static final Log log = LogFactory.getLog(STSServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is activated");
        }
        try {
            BundleContext bundleCtx = ctxt.getBundleContext();
            STSServiceDataHolder.getInstance().setBundle(bundleCtx.getBundle());
            try {
                this.addKeystores();
            }
            catch (Exception e) {
                String msg = "Cannot add keystores";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
            ctxt.getBundleContext().registerService(AxisObserver.class.getName(), (Object)new STSDeploymentInterceptor(), props);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new STSDeploymentListener(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while updating carbon STS service", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is deactivated");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Carbon STS bundle");
        }
        try {
            STSServiceDataHolder.getInstance().setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        STSServiceDataHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Carbon STS bundle");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RealmService");
        }
        STSServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RealmService");
        }
        STSServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="identity.attribute.service", service=IdentityAttributeService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeAttributeService")
    protected void addAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityAttributeService added in Carbon STS bundle");
        }
    }

    protected void removeAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityAttributeService removed in Carbon STS bundle");
        }
    }

    private void addKeystores() throws RegistryException {
        UserRegistry registry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry();
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            if (!registry.resourceExists("/repository/security/key-stores")) {
                Collection kstores = registry.newCollection();
                registry.put("/repository/security/key-stores", (Resource)kstores);
                Resource primResource = registry.newResource();
                if (!registry.resourceExists("/repository/security/key-stores/carbon-primary-ks")) {
                    registry.put("/repository/security/key-stores/carbon-primary-ks", primResource);
                }
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }
}

