/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.sts.STSDeploymentInterceptor;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.IOStreamUtils;
import org.wso2.carbon.utils.deployment.Axis2ServiceRegistry;
import org.wso2.carbon.utils.deployment.BundleClassLoader;

public class STSDeploymentListener
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(STSDeploymentListener.class);
    private static String componentsDirPath;

    public void createdConfigurationContext(ConfigurationContext configContext) {
        AxisService service;
        block6: {
            service = null;
            try {
                service = configContext.getAxisConfiguration().getService("wso2carbon-sts");
            }
            catch (AxisFault axisFault) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"wso2carbon-sts service is not available", (Throwable)axisFault);
            }
        }
        if (service == null) {
            configContext.getAxisConfiguration().addObservers((AxisObserver)new STSDeploymentInterceptor());
            Bundle bundle = STSServiceDataHolder.getInstance().getBundle();
            AxisServiceGroup serviceGroup = this.createService(bundle, configContext);
            if (serviceGroup != null) {
                try {
                    configContext.getAxisConfiguration().addServiceGroup(serviceGroup);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error occurs while adding wso2carbon-sts service group in to axis2configuration of tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)axisFault);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AxisServiceGroup createService(Bundle bundle, ConfigurationContext configContext) {
        Enumeration enumeration = bundle.findEntries("META-INF", "*services.xml", true);
        AxisServiceGroup serviceGroup = null;
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        if (enumeration != null && enumeration.hasMoreElements()) {
            InputStream inputStream = null;
            try {
                serviceGroup = new AxisServiceGroup(axisConfiguration);
                BundleClassLoader loader = new BundleClassLoader(bundle, Axis2ServiceRegistry.class.getClassLoader());
                URL url = (URL)enumeration.nextElement();
                Dictionary headers = bundle.getHeaders();
                String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                serviceGroup.setServiceGroupName(bundleSymbolicName);
                serviceGroup.setServiceGroupClassLoader((ClassLoader)loader);
                inputStream = url.openStream();
                DescriptionBuilder builder = new DescriptionBuilder(inputStream, configContext);
                OMElement rootElement = builder.buildOM();
                String elementName = rootElement.getLocalName();
                HashMap wsdlServicesMap = this.processWSDL(bundle);
                if (MapUtils.isNotEmpty((Map)wsdlServicesMap)) {
                    for (AxisService service : wsdlServicesMap.values()) {
                        Iterator operations = service.getOperations();
                        while (operations.hasNext()) {
                            AxisOperation axisOperation = (AxisOperation)operations.next();
                            axisConfiguration.getPhasesInfo().setOperationPhases(axisOperation);
                        }
                    }
                }
                if ("service".equals(elementName)) {
                    AxisService axisService = new AxisService(bundleSymbolicName);
                    axisService.setParent(serviceGroup);
                    axisService.setClassLoader((ClassLoader)loader);
                    ServiceBuilder serviceBuilder = new ServiceBuilder(configContext, axisService);
                    serviceBuilder.setWsdlServiceMap(wsdlServicesMap);
                    AxisService service = serviceBuilder.populateService(rootElement);
                    ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                    serviceList.add(service);
                    DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, serviceList, null, null, (AxisConfiguration)axisConfiguration);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deployed wso2carbon-sts service");
                    }
                } else if ("serviceGroup".equals(elementName)) {
                    ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServicesMap, configContext);
                    ArrayList serviceList = groupBuilder.populateServiceGroup(serviceGroup);
                    DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, (ArrayList)serviceList, null, null, (AxisConfiguration)axisConfiguration);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deployed wso2carbon-sts service group ");
                    }
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)axisFault);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error occurred while closing Input stream", (Throwable)e);
                }
            }
        }
        return serviceGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap processWSDL(Bundle bundle) throws IOException, XMLStreamException {
        File bundleFile;
        Enumeration enumeration = bundle.findEntries("META-INF", "*.wsdl", true);
        if (enumeration == null) {
            return new HashMap();
        }
        String bundleLocation = bundle.getLocation();
        if (bundleLocation.startsWith("reference:")) {
            bundleLocation = bundleLocation.substring("reference:".length());
        }
        String[] subStrings = bundleLocation.split("/");
        String bundleFileName = subStrings[subStrings.length - 1];
        URL bundleURL = new URL(bundleLocation);
        InputStream bundleStream = null;
        OutputStream bundleFileOutputSteam = null;
        try {
            if ("file".equals(bundleURL.getProtocol())) {
                bundleFile = new File(bundleURL.getFile());
            } else {
                bundleStream = bundleURL.openStream();
                String tempBundleDirPath = System.getProperty("java.io.tmpdir") + File.separator + "bundles";
                File tempBundleDir = new File(tempBundleDirPath);
                if (!tempBundleDir.exists() && !tempBundleDir.mkdir()) {
                    log.warn((Object)("Could not create temp bundle directory " + tempBundleDir.getAbsolutePath()));
                    HashMap hashMap = new HashMap();
                    return hashMap;
                }
                bundleFile = new File(tempBundleDirPath, bundleFileName);
                bundleFileOutputSteam = new FileOutputStream(bundleFile);
                IOStreamUtils.copyInputStream((InputStream)bundleStream, (OutputStream)bundleFileOutputSteam);
            }
        }
        finally {
            try {
                if (bundleStream != null) {
                    bundleStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while closing Input stream", (Throwable)e);
            }
            try {
                if (bundleFileOutputSteam != null) {
                    bundleFileOutputSteam.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while closing Output stream", (Throwable)e);
            }
        }
        if (!bundleFile.exists()) {
            bundleFile = new File(componentsDirPath + File.separator + bundleURL.getFile());
        }
        if (!bundleFile.exists()) {
            return new HashMap();
        }
        DeploymentFileData deploymentFileData = new DeploymentFileData(bundleFile);
        ArchiveReader archiveReader = new ArchiveReader();
        return archiveReader.processWSDLs(deploymentFileData);
    }

    static {
        String carbonRepo = System.getenv("CARBON_REPOSITORY");
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.repository");
        }
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
        }
        componentsDirPath = carbonRepo + File.separator + "components";
    }
}

