/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.deployment.DeploymentInterceptor;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.sts.common.util.RampartConfigUtil;
import org.wso2.carbon.identity.sts.common.util.ServerCrypto;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;

public class STSDeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(DeploymentInterceptor.class);
    public static final String HOST_NAME = "HostName";
    public static final String STS_TIME_TO_LIVE = "STSTimeToLive";
    public static final String STS_HOST_NAME = "STSHostName";
    public static final String SECURITY_DISABLE_TOKEN_STORE = "Security.DisableTokenStore";
    public static final String SECURITY_KEY_STORE_KEY_PASSWORD = "Security.KeyStore.KeyPassword";
    public static final String SECURITY_TOKEN_PERSISTER_CLASS = "Security.TokenPersister.Class";
    public static final String SECURITY_TOKEN_PERSISTER_STORAGE_PATH = "Security.TokenPersister.StoragePath";
    public static final String SECURITY_TOKEN_PERSISTER_IN_MEMORY_THRESHOLD = "Security.TokenPersister.InMemoryThreshold";
    public static final String SECURITY_TOKEN_PERSISTER_PROPERTIES_PROPERTY_NAME = "Security.TokenPersister.Properties.Property.Name";
    public static final String SECURITY_TOKEN_PERSISTER_PROPERTIES_PROPERTY_VALUE = "Security.TokenPersister.Properties.Property.Value";
    public static final String STS_SIGNATURE_ALGORITHM = "Security.STSSignatureAlgorithm";
    public static final String STS_DIGEST_ALGORITHM = "Security.STSDigestAlgorithm";

    public static void updateSTSService(AxisConfiguration config) throws Exception {
        AxisService service = null;
        UserRegistry configRegistry = null;
        UserRegistry governRegistry = null;
        String keyPassword = null;
        KeyStoreAdmin admin = null;
        KeyStoreData[] keystores = null;
        String privateKeyAlias = null;
        String keyStoreName = null;
        String issuerName = null;
        ServerConfiguration serverConfig = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        configRegistry = STSServiceDataHolder.getInstance().getRegistryService().getConfigSystemRegistry(tenantId);
        governRegistry = STSServiceDataHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
        if (configRegistry == null || config.getService("wso2carbon-sts") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"configRegistry not set or STS service is unavailable");
            }
            return;
        }
        serverConfig = ServerConfiguration.getInstance();
        admin = new KeyStoreAdmin(tenantId, (Registry)governRegistry);
        if (-1234 == tenantId) {
            keyPassword = serverConfig.getFirstProperty(SECURITY_KEY_STORE_KEY_PASSWORD);
            keystores = admin.getKeyStores(true);
            for (int i = 0; i < keystores.length; ++i) {
                if (!KeyStoreUtil.isPrimaryStore((String)keystores[i].getKeyStoreName())) continue;
                keyStoreName = keystores[i].getKeyStoreName();
                privateKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)KeyStoreManager.getInstance((int)-1234).getKeyStore(keyStoreName));
                break;
            }
        } else {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (tenantDomain == null) {
                tenantDomain = STSServiceDataHolder.getInstance().getRealmService().getTenantManager().getDomain(tenantId);
            }
            if (tenantDomain != null) {
                keyStoreName = tenantDomain.replace(".", "-") + ".jks";
                KeyStore keyStore = KeyStoreManager.getInstance((int)tenantId).getKeyStore(keyStoreName);
                if (keyStore != null) {
                    privateKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)keyStore);
                    keyPassword = KeyStoreManager.getInstance((int)tenantId).getKeyStorePassword(keyStoreName);
                } else {
                    log.warn((Object)("No key store is exist as " + keyStoreName + ". STS would be fail"));
                }
            } else {
                throw new Exception("Tenant Domain can not be null");
            }
        }
        issuerName = serverConfig.getFirstProperty(STS_HOST_NAME);
        if (StringUtils.isBlank((String)issuerName)) {
            issuerName = "https://" + serverConfig.getFirstProperty(HOST_NAME);
        }
        if (privateKeyAlias != null) {
            String tokenStoreDisabled;
            String ttl;
            service = config.getService("wso2carbon-sts");
            String cryptoProvider = ServerCrypto.class.getName();
            Properties props = RampartConfigUtil.getServerCryptoProperties((String[])new String[]{keyStoreName}, (String)keyStoreName, (String)privateKeyAlias);
            String callBackHandlerName = serverConfig.getFirstProperty("Security.STSCallBackHandlerName");
            SAMLTokenIssuerConfig stsSamlConfig = new SAMLTokenIssuerConfig(issuerName, cryptoProvider, props);
            stsSamlConfig.setIssuerName(issuerName);
            stsSamlConfig.setIssuerKeyAlias(privateKeyAlias);
            stsSamlConfig.setIssuerKeyPassword(keyPassword);
            stsSamlConfig.setAddRequestedAttachedRef(true);
            stsSamlConfig.setAddRequestedUnattachedRef(true);
            stsSamlConfig.setKeyComputation(2);
            stsSamlConfig.setProofKeyType("BinarySecret");
            String signatureAlgorithm = serverConfig.getFirstProperty(STS_SIGNATURE_ALGORITHM);
            String digestAlgorithm = serverConfig.getFirstProperty(STS_DIGEST_ALGORITHM);
            stsSamlConfig.setSignatureAlgorithm(signatureAlgorithm);
            stsSamlConfig.setDigestAlgorithm(digestAlgorithm);
            if (StringUtils.isNotBlank((String)callBackHandlerName)) {
                stsSamlConfig.setCallbackHandlerName(callBackHandlerName);
            }
            String resourcePath = null;
            resourcePath = "/repository/axis2/service-groups/wso2carbon-sts/services/wso2carbon-sts/trustedServices";
            if (configRegistry.resourceExists(resourcePath)) {
                Resource trustedService = null;
                Properties properties = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                trustedService = configRegistry.get(resourcePath);
                properties = trustedService.getProperties();
                if (properties != null && !properties.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        if (RegistryUtils.isHiddenProperty((String)entry.getKey().toString())) continue;
                        stsSamlConfig.addTrustedServiceEndpointAddress((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                    }
                }
            }
            if (StringUtils.isNotBlank((String)(ttl = serverConfig.getFirstProperty(STS_TIME_TO_LIVE)))) {
                try {
                    stsSamlConfig.setTtl(Long.parseLong(ttl));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("STSTimeToLive read from carbon.xml " + ttl));
                    }
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Error while reading STSTimeToLive from carbon.xml", (Throwable)e);
                }
            }
            if ((tokenStoreDisabled = serverConfig.getFirstProperty(SECURITY_DISABLE_TOKEN_STORE)) != null) {
                stsSamlConfig.setTokenStoreDisabled(Boolean.parseBoolean(tokenStoreDisabled));
            }
            String persisterClassName = serverConfig.getFirstProperty(SECURITY_TOKEN_PERSISTER_CLASS);
            String persistingFilePath = serverConfig.getFirstProperty(SECURITY_TOKEN_PERSISTER_STORAGE_PATH);
            String inMemoryThreshold = serverConfig.getFirstProperty(SECURITY_TOKEN_PERSISTER_IN_MEMORY_THRESHOLD);
            if (persisterClassName != null) {
                stsSamlConfig.setPersisterClassName(persisterClassName);
            }
            HashMap<Object, Object> propertyMap = new HashMap<Object, Object>();
            if (persistingFilePath != null) {
                propertyMap.put("StoragePath", persistingFilePath);
            }
            if (inMemoryThreshold != null) {
                propertyMap.put("InMemoryThreshold", inMemoryThreshold);
            }
            if (log.isDebugEnabled() && persisterClassName != null && inMemoryThreshold == null) {
                log.debug((Object)"Although persister is defined, threshold not defined.");
            }
            Object[] persisterPropertyNames = serverConfig.getProperties(SECURITY_TOKEN_PERSISTER_PROPERTIES_PROPERTY_NAME);
            Object[] persisterPropertyValues = serverConfig.getProperties(SECURITY_TOKEN_PERSISTER_PROPERTIES_PROPERTY_VALUE);
            if (!ArrayUtils.isEmpty((Object[])persisterPropertyNames) && !ArrayUtils.isEmpty((Object[])persisterPropertyValues) && persisterPropertyNames.length == persisterPropertyValues.length) {
                for (int i = 0; i < persisterPropertyNames.length; ++i) {
                    propertyMap.put(persisterPropertyNames[i], persisterPropertyValues[i]);
                }
            }
            if (!propertyMap.isEmpty()) {
                stsSamlConfig.setPersisterPropertyMap(propertyMap);
            }
            try {
                Parameter param = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                if (param == null) {
                    service.addParameter(stsSamlConfig.getParameter());
                }
            }
            catch (AxisFault e) {
                log.error((Object)"Error while updating wso2carbon-sts in STSDeploymentInterceptor", (Throwable)e);
            }
        }
    }

    public void serviceUpdate(AxisEvent event, AxisService service) {
        if (event.getEventType() == 1 && "wso2carbon-sts".equals(service.getName())) {
            try {
                STSDeploymentInterceptor.updateSTSService(service.getAxisConfiguration());
            }
            catch (Exception e) {
                log.error((Object)"Error while updating wso2carbon-sts in STSDeploymentInterceptor", (Throwable)e);
            }
        }
    }

    public void init(AxisConfiguration arg0) {
    }

    public void moduleUpdate(AxisEvent arg0, AxisModule arg1) {
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup group) {
    }

    public void addParameter(Parameter arg0) throws AxisFault {
    }

    public void deserializeParameters(OMElement arg0) throws AxisFault {
    }

    public Parameter getParameter(String arg0) {
        return null;
    }

    public ArrayList getParameters() {
        return null;
    }

    public boolean isParameterLocked(String arg0) {
        return false;
    }

    public void removeParameter(Parameter arg0) throws AxisFault {
    }
}

