/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.notification.mgt.internal;

import java.util.ArrayList;
import java.util.List;
import javax.mail.MessageRemovedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationMgtConfigBuilder;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.identity.notification.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.notification.mgt.bean.ModuleConfiguration;

@Component(name="carbon.identity.notification.mgt", immediate=true)
public class NotificationManagementServiceComponent {
    private static final Log log = LogFactory.getLog(NotificationManagementServiceComponent.class);
    int threadPoolSize = 0;
    private NotificationSender notificationSender;
    private NotificationMgtConfigBuilder configBuilder;
    private List<NotificationSendingModule> notificationSendingModules = new ArrayList<NotificationSendingModule>();

    @Activate
    protected void activate(ComponentContext context) {
        try {
            try {
                this.configBuilder = new NotificationMgtConfigBuilder(context.getBundleContext());
            }
            catch (NotificationManagementException e) {
                log.error((Object)"Error while building Notification Mgt configuration", (Throwable)((Object)e));
            }
            if (this.configBuilder != null && this.configBuilder.getThreadPoolSize() != null) {
                try {
                    this.threadPoolSize = Integer.parseInt(this.configBuilder.getThreadPoolSize());
                }
                catch (NumberFormatException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Error while parsing thread pool size configuration, setting default size :5");
                    }
                    this.threadPoolSize = 5;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No configuration found for thread pool size, setting default size :5");
                }
                this.threadPoolSize = 5;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification mgt thread pool size " + this.threadPoolSize));
            }
            this.notificationSender = new NotificationSender(this.notificationSendingModules, this.threadPoolSize);
            context.getBundleContext().registerService(NotificationSender.class.getName(), (Object)this.notificationSender, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Notification Management bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while initiating Notification Management component", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Notification Management bundle is deactivated");
        }
        this.notificationSender.stopService();
    }

    @Reference(name="ldap.tenant.manager.listener.service", service=NotificationSendingModule.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeNotificationSendingModule")
    protected void addNotificationSendingModule(NotificationSendingModule module) throws MessageRemovedException {
        if (StringUtils.isEmpty((String)module.getModuleName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot register module without a valid module name");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering a message sending module " + module.getModuleName()));
        }
        ModuleConfiguration moduleConfiguration = this.configBuilder != null ? this.configBuilder.getModuleConfigurations(module.getModuleName()) : new ModuleConfiguration();
        try {
            module.init(moduleConfiguration);
            this.notificationSendingModules.add(module);
        }
        catch (NotificationManagementException e) {
            log.error((Object)("Error while initializing Notification sending module " + module.getModuleName()), (Throwable)((Object)e));
        }
    }

    protected void removeNotificationSendingModule(NotificationSendingModule module) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing a message module " + module.getModuleName()));
        }
        this.notificationSendingModules.remove(module);
    }
}

