/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.notification.mgt;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.notification.mgt.EventDistributionTask;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.notification.mgt.bean.PublisherEvent;

public class NotificationSender {
    private static final Log log = LogFactory.getLog(NotificationSender.class);
    private EventDistributionTask eventDistributionTask;

    public NotificationSender(List<NotificationSendingModule> notificationSendingModules, int threadPoolSize) {
        this.eventDistributionTask = new EventDistributionTask(notificationSendingModules, threadPoolSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting event distribution task from Notification Management component");
        }
        new Thread(this.eventDistributionTask).start();
    }

    public void invoke(PublisherEvent event) throws NotificationManagementException {
        if (event == null) {
            throw new NotificationManagementException("No publisher event found to send notification");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding event to the event queue " + event.getEventName()));
        }
        this.eventDistributionTask.addEventToQueue(event);
    }

    public void stopService() {
        this.eventDistributionTask.shutdown();
    }
}

