/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.notification.mgt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementUtils;
import org.wso2.carbon.identity.notification.mgt.bean.ModuleConfiguration;
import org.wso2.carbon.identity.notification.mgt.bean.Subscription;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class NotificationMgtConfigBuilder {
    private static final Log log = LogFactory.getLog(NotificationMgtConfigBuilder.class);
    private Properties notificationMgtConfigProperties;
    private Map<String, ModuleConfiguration> moduleConfiguration;
    private String threadPoolSize;

    public NotificationMgtConfigBuilder(BundleContext bundleContext) throws NotificationManagementException {
        this.notificationMgtConfigProperties = this.loadProperties(bundleContext);
        this.setThreadPoolSize();
        this.resolveSecrets();
        this.moduleConfiguration = new HashMap<String, ModuleConfiguration>();
        this.build();
    }

    private void setThreadPoolSize() {
        this.threadPoolSize = (String)this.notificationMgtConfigProperties.remove("threadPool.size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(BundleContext bundleContext) throws NotificationManagementException {
        Properties properties = new Properties();
        InputStream inStream = null;
        File MessageMgtPropertyFile = new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "identity" + File.separator, "msg-mgt.properties");
        try {
            URL url;
            if (MessageMgtPropertyFile.exists()) {
                inStream = new FileInputStream(MessageMgtPropertyFile);
            } else if (bundleContext != null) {
                url = bundleContext.getBundle().getResource("msg-mgt.properties");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    log.warn((Object)"Bundle context could not find resource msg-mgt.properties");
                }
            } else {
                url = this.getClass().getClassLoader().getResource("msg-mgt.properties");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    log.warn((Object)"Class resource loader could not find resource msg-mgt.properties");
                }
            }
            if (inStream != null) {
                properties.load(inStream);
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"Could not find configuration file for Message Sending module", (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)"Error while opening input stream for property file", (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream ", (Throwable)e);
            }
        }
        return properties;
    }

    private void build() {
        Properties moduleNames = NotificationManagementUtils.getSubProperties("module.name", this.notificationMgtConfigProperties);
        Enumeration<?> propertyNames = moduleNames.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            String moduleName = (String)moduleNames.remove(key);
            this.moduleConfiguration.put(moduleName, this.buildModuleConfigurations(moduleName));
        }
    }

    private ModuleConfiguration buildModuleConfigurations(String moduleName) {
        Properties moduleProperties = this.getModuleProperties(moduleName);
        List<Subscription> subscriptionList = this.buildSubscriptionList(moduleName, moduleProperties);
        return new ModuleConfiguration(this.getModuleProperties(moduleName), subscriptionList);
    }

    private List<Subscription> buildSubscriptionList(String moduleName, Properties moduleProperties) {
        Properties subscriptions = NotificationManagementUtils.getSubProperties(moduleName + "." + "subscription", moduleProperties);
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
        Enumeration<?> propertyNames = subscriptions.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            String subscriptionName = (String)subscriptions.remove(key);
            Properties subscriptionProperties = NotificationManagementUtils.getPropertiesWithPrefix(moduleName + "." + "subscription" + "." + subscriptionName, moduleProperties);
            Subscription subscription = new Subscription(subscriptionName, subscriptionProperties);
            subscriptionList.add(subscription);
        }
        return subscriptionList;
    }

    private Properties getModuleProperties(String moduleName) {
        return NotificationManagementUtils.getPropertiesWithPrefix(moduleName, this.notificationMgtConfigProperties);
    }

    public ModuleConfiguration getModuleConfigurations(String moduleName) {
        return this.moduleConfiguration.get(moduleName);
    }

    public String getThreadPoolSize() {
        return this.threadPoolSize;
    }

    private void resolveSecrets() {
        SecretResolver secretResolver = SecretResolverFactory.create((Properties)this.notificationMgtConfigProperties);
        Enumeration<?> propertyNames = this.notificationMgtConfigProperties.propertyNames();
        if (secretResolver != null && secretResolver.isInitialized()) {
            for (Map.Entry<Object, Object> entry : this.notificationMgtConfigProperties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (value != null) {
                    value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                this.notificationMgtConfigProperties.put(key, value);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Secret Resolver is not present. Will not resolve encryptions in config file");
        }
    }
}

