/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.notification.mgt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.notification.mgt.NotificationMgtConfigBuilder;

public class NotificationManagementUtils {
    private static final Log log = LogFactory.getLog(NotificationMgtConfigBuilder.class);

    private NotificationManagementUtils() {
    }

    public static Properties getPropertiesWithPrefix(String prefix, Properties properties) {
        if (StringUtils.isEmpty((String)prefix) || properties == null) {
            throw new IllegalArgumentException("Prefix and properties should not be null to extract properties with certain prefix");
        }
        Properties subProperties = new Properties();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!key.startsWith(prefix)) continue;
            subProperties.setProperty(key, (String)properties.remove(key));
        }
        return subProperties;
    }

    public static Properties getSubProperties(String prefix, Properties properties) {
        if (StringUtils.isEmpty((String)prefix) || properties == null) {
            throw new IllegalArgumentException("Prefix and Properties should not be null to get sub properties");
        }
        int i = 1;
        Properties subProperties = new Properties();
        while (properties.getProperty(prefix + "." + i) != null) {
            subProperties.put(prefix + "." + i, properties.remove(prefix + "." + i++));
        }
        return subProperties;
    }

    public static Properties buildSingleWordKeyProperties(String prefix, Properties propertiesWithFullKeys) {
        if (StringUtils.isEmpty((String)prefix) || propertiesWithFullKeys == null) {
            throw new IllegalArgumentException("Prefix and properties should not be null to get  properties with single word keys.");
        }
        propertiesWithFullKeys = NotificationManagementUtils.getPropertiesWithPrefix(prefix, propertiesWithFullKeys);
        Properties properties = new Properties();
        Enumeration<?> propertyNames = propertiesWithFullKeys.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            String newKey = key.substring(key.lastIndexOf(".") + 1, key.length());
            if (newKey.trim().isEmpty()) continue;
            properties.put(newKey, propertiesWithFullKeys.remove(key));
        }
        return properties;
    }

    public static String replacePlaceHolders(String content, String replaceRegexStartsWith, String replaceRegexEndsWith, Properties properties) {
        if (properties == null || StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)replaceRegexEndsWith) || StringUtils.isEmpty((String)replaceRegexStartsWith)) {
            throw new IllegalArgumentException("Missing required arguments for replacing place holders");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Place holders starting regex : " + replaceRegexStartsWith + ". End regex with : " + replaceRegexEndsWith));
            log.debug((Object)("Replacing place holders of String " + content));
        }
        for (String key : properties.stringPropertyNames()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replacing place holder with property key :" + key + " from value :" + properties.getProperty(key)));
            }
            content = content.replaceAll(replaceRegexStartsWith + key + replaceRegexEndsWith, properties.getProperty(key));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Place holders replaced String " + content));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readMessageTemplate(String filePath) {
        BufferedReader bufferedReader = null;
        String template = null;
        if (StringUtils.isEmpty((String)filePath)) {
            throw new IllegalArgumentException("File path should not be empty");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading template file in " + filePath));
        }
        try {
            String currentLine;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            StringBuilder templateBuilder = new StringBuilder();
            while ((currentLine = bufferedReader.readLine()) != null) {
                templateBuilder.append(currentLine);
                templateBuilder.append(System.getProperty("line.separator"));
            }
            template = templateBuilder.toString();
        }
        catch (IOException e) {
            log.error((Object)("Error while reading email template from location " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error while closing buffered reader after reading file " + filePath), (Throwable)e);
            }
        }
        return template;
    }
}

