/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.notification.mgt;

import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.identity.notification.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.notification.mgt.bean.PublisherEvent;
import org.wso2.carbon.identity.notification.mgt.internal.NotificationManagementServiceDataHolder;

public class EventDistributionTask
implements Runnable {
    private static final Log log = LogFactory.getLog(NotificationSender.class);
    private BlockingDeque<PublisherEvent> eventQueue;
    private List<NotificationSendingModule> notificationSendingModules;
    private volatile boolean running;

    public EventDistributionTask(List<NotificationSendingModule> notificationSendingModules, int threadPoolSize) {
        this.notificationSendingModules = notificationSendingModules;
        this.eventQueue = new LinkedBlockingDeque<PublisherEvent>();
        NotificationManagementServiceDataHolder.getInstance().setThreadPool(Executors.newFixedThreadPool(threadPoolSize));
    }

    public void addEventToQueue(PublisherEvent publisherEvent) {
        this.eventQueue.add(publisherEvent);
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                final PublisherEvent event = this.eventQueue.take();
                for (final NotificationSendingModule module : this.notificationSendingModules) {
                    try {
                        if (!module.isSubscribed(event)) continue;
                        Runnable msgSender = new Runnable(){

                            @Override
                            public void run() {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Executing " + module.getModuleName() + " on event" + event.getEventName()));
                                }
                                try {
                                    module.sendMessage(event);
                                }
                                catch (NotificationManagementException e) {
                                    log.error((Object)("Error while invoking notification sending module " + module.getModuleName()), (Throwable)((Object)e));
                                }
                            }
                        };
                        NotificationManagementServiceDataHolder.getInstance().getThreadPool().submit(msgSender);
                    }
                    catch (NotificationManagementException e) {
                        log.error((Object)("Error while getting subscription status from notification module " + module.getModuleName()), (Throwable)((Object)e));
                    }
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while picking up event from event queue", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }
}

