/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.common.factory.SequenceInfoFactory;
import org.wso2.carbon.sequences.common.to.ConfigurationObject;
import org.wso2.carbon.sequences.common.to.SequenceInfo;
import org.wso2.carbon.sequences.internal.ConfigHolder;

public class SequenceAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(SequenceAdmin.class);
    private boolean saveRuntimeArtifacts = SynapsePropertiesLoader.getBooleanProperty((String)"synapse.artifacts.file.storage.enabled", (Boolean)true);
    public static final String WSO2_SEQUENCE_MEDIA_TYPE = "application/vnd.wso2.sequence";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceInfo[] getSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        Lock lock = this.getLock();
        Collection sequences = null;
        try {
            lock.lock();
            sequences = this.getSynapseConfiguration().getDefinedSequences().values();
            SequenceInfo[] info = SequenceInfoFactory.getSortedSequenceInfoArray(sequences);
            if (info != null && info.length > 0) {
                for (SequenceInfo seqInfo : info) {
                    SequenceMediator seq = (SequenceMediator)this.getSynapseConfiguration().getDefinedSequences().get(seqInfo.getName());
                    if (seq.getArtifactContainerName() != null) {
                        seqInfo.setArtifactContainerName(seq.getArtifactContainerName());
                    }
                    if (!seq.isEdited()) continue;
                    seqInfo.setIsEdited(true);
                }
            }
            SequenceInfo[] ret = info.length >= sequencePerPage * pageNumber + sequencePerPage ? new SequenceInfo[sequencePerPage] : new SequenceInfo[info.length - sequencePerPage * pageNumber];
            for (int i = 0; i < sequencePerPage; ++i) {
                if (ret.length <= i) continue;
                ret[i] = info[sequencePerPage * pageNumber + i];
            }
            SequenceInfo[] sequenceInfoArray = ret;
            return sequenceInfoArray;
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available sequences", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public int getSequencesCount() throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int n = this.getSynapseConfiguration().getDefinedSequences().values().size();
            return n;
        }
        catch (Exception e) {
            this.handleException("Couldn't get the Synapse Configuration to get Sequence count", e);
        }
        finally {
            lock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceInfo[] getDynamicSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        SequenceInfo[] ret;
        Lock lock = this.getLock();
        try {
            lock.lock();
            String[] configInfo = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            String[] govInfo = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            Object[] info = new String[(configInfo != null ? configInfo.length : 0) + (govInfo != null ? govInfo.length : 0)];
            int ptr = 0;
            for (String aConfigInfo : configInfo) {
                info[ptr] = "conf:" + aConfigInfo;
                ++ptr;
            }
            for (String aGovInfo : govInfo) {
                info[ptr] = "gov:" + aGovInfo;
                ++ptr;
            }
            Arrays.sort(info);
            ret = info.length >= sequencePerPage * pageNumber + sequencePerPage ? new SequenceInfo[sequencePerPage] : new SequenceInfo[info.length - sequencePerPage * pageNumber];
            for (int i = 0; i < sequencePerPage; ++i) {
                if (ret.length <= i) continue;
                SequenceInfo seq = new SequenceInfo();
                seq.setName((String)info[sequencePerPage * pageNumber + i]);
                ret[i] = seq;
            }
        }
        catch (Exception e) {
            this.handleException("Unable to get Dynamic Sequence Info", e);
            SequenceInfo[] sequenceInfoArray = null;
            return sequenceInfoArray;
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int getDynamicSequenceCount() throws SequenceEditorException {
        try {
            String[] govList = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            String[] confList = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            return (confList != null ? confList.length : 0) + (govList != null ? govList.length : 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String[] getMimeTypeResult(org.wso2.carbon.registry.core.Registry targetRegistry) throws Exception {
        String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", sql);
        parameters.put("1", WSO2_SEQUENCE_MEDIA_TYPE);
        org.wso2.carbon.registry.core.Collection result = targetRegistry.executeQuery(null, parameters);
        return (String[])result.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            SequenceMediator sequence = (SequenceMediator)synCfg.getDefinedSequences().get(sequenceName);
            if (sequence != null && sequence.getArtifactContainerName() == null) {
                synCfg.removeSequence(sequenceName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    pm.deleteItem(sequenceName, sequence.getFileName(), 1);
                }
            } else {
                this.handleException("No defined sequence with name " + sequenceName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequenceForTenant(String sequenceName, String tenantDomain) throws SequenceEditorException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            this.deleteSequence(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Issue is in deleting the sequence definition");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedSequence(String[] sequenceNames) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            ArrayList list = new ArrayList();
            Collections.addAll(list, sequenceNames);
            list.remove("main");
            list.remove("fault");
            for (String sequenceName : sequenceNames = list.toArray(new String[list.size()])) {
                SequenceMediator sequence = (SequenceMediator)synCfg.getDefinedSequences().get(sequenceName);
                if (sequence == null || sequence.getArtifactContainerName() != null) continue;
                synCfg.removeSequence(sequenceName);
                if (Boolean.parseBoolean(System.getProperty("NonRegistryMode")) || !this.saveRuntimeArtifacts) continue;
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(sequenceName, sequence.getFileName(), 1);
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSequence() throws SequenceEditorException {
        Lock lock = this.getLock();
        Collection sequences = null;
        try {
            lock.lock();
            sequences = this.getSynapseConfiguration().getDefinedSequences().values();
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            for (SequenceMediator sequence : sequences) {
                if (sequence == null || sequence.getName().equals("main") || sequence.getName().equals("fault") || sequence.getArtifactContainerName() != null) continue;
                synCfg.removeSequence(sequence.getName());
                if (Boolean.parseBoolean(System.getProperty("NonRegistryMode")) || !this.saveRuntimeArtifacts) continue;
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(sequence.getName(), sequence.getFileName(), 1);
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to delete entire sequences in the synapse configuration", fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getSequence(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            if (synapseConfiguration.getSequence(sequenceName) != null) {
                OMElement oMElement = MediatorSerializerFinder.getInstance().getSerializer(synapseConfiguration.getSequence(sequenceName)).serializeMediator(null, synapseConfiguration.getSequence(sequenceName));
                return oMElement;
            }
            this.handleException("Sequence with the name " + sequenceName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + sequenceName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the sequence", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getSequenceForTenant(String sequenceName, String tenantDomain) throws SequenceEditorException {
        try {
            OMElement seq;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            OMElement oMElement = seq = this.getSequence(sequenceName);
            return oMElement;
        }
        catch (Exception e) {
            this.handleException("Issue is in getting the sequence definition");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return null;
    }

    public void addSequence(OMElement sequenceElement) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                if ("".equals(sequenceName) || null == sequenceName) {
                    this.handleException("sequence name is required.");
                }
                SynapseConfiguration config = this.getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding sequence : " + sequenceName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(sequenceName) != null) {
                    this.handleException("The name '" + sequenceName + "' is already used within the configuration - a sequence or local entry with this name already exists");
                } else {
                    SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)config, (OMElement)sequenceElement, (Properties)this.getSynapseConfiguration().getProperties());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added sequence : " + sequenceName + " to the configuration"));
                    }
                    SequenceMediator seq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    seq.setFileName(ServiceBusUtils.generateFileName((String)sequenceName));
                    seq.init(this.getSynapseEnvironment());
                    this.persistSequence(seq);
                }
            } else {
                this.handleException("Invalid sequence definition");
            }
        }
        catch (Exception fault) {
            throw new SequenceEditorException("Error adding sequence : " + fault.getMessage(), (Throwable)fault);
        }
        catch (Error error) {
            throw new SequenceEditorException("Unexpected error occured while adding the sequence : " + error.getMessage(), (Throwable)error);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequenceForTenant(OMElement sequenceElement, String tenantDomain) throws SequenceEditorException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            this.addSequence(sequenceElement);
        }
        catch (Exception e) {
            this.handleException("Issue in deploying the sequence definition");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public boolean isExistingSequence(String sequenceName) {
        SynapseConfiguration config = this.getSynapseConfiguration();
        return config.getLocalRegistry().get(sequenceName) != null;
    }

    public boolean isExistingSequenceForTenant(String sequenceName, String tenantDomain) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
        return this.isExistingSequence(sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSequence(OMElement sequenceElement) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            sequenceElement.detach();
            if (sequenceElement != null && sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                log.debug((Object)("Saving sequence : " + sequenceName));
                SequenceMediator preSeq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                if (preSeq == null) {
                    this.handleException("Unable to save sequence " + sequenceName + ". Does not exist");
                } else {
                    Mediator mediator = MediatorFactoryFinder.getInstance().getMediator(sequenceElement, this.getSynapseConfiguration().getProperties(), this.getSynapseConfiguration());
                    boolean statisticsEnable = preSeq.isStatisticsEnable();
                    config.removeSequence(sequenceName);
                    if (mediator instanceof SequenceMediator) {
                        if (statisticsEnable) {
                            ((SequenceMediator)mediator).enableStatistics();
                        }
                        ((SequenceMediator)mediator).setFileName(preSeq.getFileName());
                    }
                    config.addSequence(sequenceName, mediator);
                    log.debug((Object)("Saved sequence : " + sequenceName + " to the configuration"));
                    SequenceMediator seq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    if (seq != null) {
                        seq.init(this.getSynapseEnvironment());
                        if (preSeq.getArtifactContainerName() != null) {
                            seq.setArtifactContainerName(preSeq.getArtifactContainerName());
                            seq.setIsEdited(true);
                            ArrayList<SequenceMediator> sequenceMediators = new ArrayList<SequenceMediator>();
                            sequenceMediators.add(seq);
                            SequenceInfo[] sequenceInfoTemp = SequenceInfoFactory.getSortedSequenceInfoArray(sequenceMediators);
                            sequenceInfoTemp[0].setIsEdited(true);
                            sequenceInfoTemp[0].setArtifactContainerName(preSeq.getArtifactContainerName());
                        } else {
                            this.persistSequence(seq);
                        }
                    }
                }
            } else {
                this.handleException("Unable to save sequence. Invalid definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to save the Sequence : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableStatistics(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.enableStatistics();
                if (sequence.getArtifactContainerName() == null) {
                    this.persistSequence(sequence);
                }
                String string = sequenceName;
                return string;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableStatistics(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.disableStatistics();
                if (sequence.getArtifactContainerName() == null) {
                    this.persistSequence(sequence);
                }
                String string = sequenceName;
                return string;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableTracing(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.enableTracing();
                sequence.enableStatistics();
                if (sequence.getArtifactContainerName() == null) {
                    this.persistSequence(sequence);
                }
                String string = sequenceName;
                return string;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableTracing(String sequenceName) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.disableTracing();
                if (sequence.getArtifactContainerName() == null) {
                    this.persistSequence(sequence);
                }
                String string = sequenceName;
                return string;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws SequenceEditorException {
        log.error((Object)message, cause);
        throw new SequenceEditorException(message, cause);
    }

    private void handleException(String message) throws SequenceEditorException {
        log.error((Object)message);
        throw new SequenceEditorException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntryNamesString() throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map globalEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> endpointList = new ArrayList<String>();
            ArrayList<String> entryList = new ArrayList<String>();
            StringBuffer entrySb = new StringBuffer();
            StringBuffer endpointSb = new StringBuffer();
            StringBuffer sequenceSb = new StringBuffer();
            for (Object entryValue : globalEntriesMap.values()) {
                String key;
                Entry entry;
                String name;
                if (entryValue instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)entryValue;
                    name = endpoint.getName();
                    if (name == null) continue;
                    endpointList.add(name);
                    continue;
                }
                if (entryValue instanceof SequenceMediator) {
                    SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                    name = sequenceMediator.getName();
                    if (name == null) continue;
                    sequenceList.add(name);
                    continue;
                }
                if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || "SERVER_IP".equals(key = entry.getKey()) || "SERVER_HOST".equals(key)) continue;
                entryList.add(key);
            }
            if (!sequenceList.isEmpty()) {
                Collections.sort(sequenceList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : sequenceList) {
                    if (name == null) continue;
                    sequenceSb.append("[Sequence]-").append(name).append(" ");
                }
            }
            if (!entryList.isEmpty()) {
                Collections.sort(entryList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : entryList) {
                    if (name == null) continue;
                    entrySb.append("[Entry]-").append(name).append(" ");
                }
            }
            if (!endpointList.isEmpty()) {
                Collections.sort(endpointList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : endpointList) {
                    if (name == null) continue;
                    endpointSb.append("[Endpoint]-").append(name).append(" ");
                }
            }
            String string = endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
            return string;
        }
        catch (Exception axisFault) {
            this.handleException("Error during retrieving local registry", axisFault);
        }
        finally {
            lock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDynamicSequence(String key, OMElement omElement) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.deleteDynamicSequence(key);
            this.addDynamicSequence(key, omElement);
        }
        finally {
            lock.unlock();
        }
    }

    public void deleteDynamicSequence(String key) throws SequenceEditorException {
        SynapseConfiguration synConfig = this.getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("The key '" + key + "' cannot be found within the configuration");
            } else {
                registry.delete(key);
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public void addDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.reset();
        try {
            XMLPrettyPrinter.prettify((OMElement)sequence, (OutputStream)stream);
        }
        catch (Exception e) {
            this.handleException("Unable to pretty print configuration", e);
        }
        try {
            org.wso2.carbon.registry.core.Registry registry;
            if (key.startsWith("conf:")) {
                registry = this.getConfigSystemRegistry();
                key = key.replace("conf:", "");
            } else {
                registry = this.getGovernanceRegistry();
                key = key.replace("gov:", "");
            }
            if (registry.resourceExists(key)) {
                this.handleException("Resource is already exists");
            }
            Resource resource = registry.newResource();
            resource.setMediaType(WSO2_SEQUENCE_MEDIA_TYPE);
            resource.setContent((Object)new String(stream.toByteArray()).trim());
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getDynamicSequence(String key) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleException("No resource is available by the key '" + key + "'");
                }
                OMElement oMElement = (OMElement)registry.getResource(new Entry(key), this.getSynapseConfiguration().getProperties());
                return oMElement;
            }
            this.handleException("Unable to access the registry instance for the ESB");
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleException("Unable to save the sequence. No resource is available by the key '" + key + "'");
                }
                registry.updateResource(key, (Object)sequence);
            } else {
                this.handleException("Unable to access the registry instance for the ESB");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public ConfigurationObject[] getDependents(String sequence) {
        org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject[] tempDependents;
        DependencyManagementService dependencyMgr = ConfigHolder.getInstance().getDependencyManager();
        if (dependencyMgr != null && (tempDependents = dependencyMgr.getDependents(1, sequence)) != null && tempDependents.length > 0) {
            ArrayList<ConfigurationObject> dependents = new ArrayList<ConfigurationObject>();
            for (int i = 0; i < tempDependents.length; ++i) {
                if (tempDependents[i].getType() == 6) continue;
                dependents.add(new ConfigurationObject(tempDependents[i].getType(), tempDependents[i].getId()));
            }
            if (dependents.size() > 0) {
                return dependents.toArray(new ConfigurationObject[dependents.size()]);
            }
        }
        return null;
    }

    private void persistSequence(SequenceMediator sequence) throws SequenceEditorException {
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            if (pm == null) {
                this.handleException("Cannot Persist sequence because persistence manager is null, probably persistence is disabled");
            }
            pm.saveItem(sequence.getName(), 1);
        }
    }

    protected AxisConfiguration getAxisConfig() {
        return this.axisConfig != null ? this.axisConfig : this.getConfigContext().getAxisConfiguration();
    }

    protected ConfigurationContext getConfigContext() {
        if (this.configurationContext != null) {
            return this.configurationContext;
        }
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null) {
            ConfigurationContext mainConfigContext = msgContext.getConfigurationContext();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            String domain = carbonContext.getTenantDomain();
            if (domain != null && !"carbon.super".equals(domain)) {
                return TenantAxisUtils.getTenantConfigurationContext((String)domain, (ConfigurationContext)mainConfigContext);
            }
            if (carbonContext.getTenantId() == -1234) {
                return mainConfigContext;
            }
            throw new UnsupportedOperationException("Tenant domain unidentified. Upstream code needs to identify & set the tenant domain & tenant ID.  The TenantDomain SOAP header could be set by the clients or tenant authentication should be carried out.");
        }
        return CarbonConfigurationContextFactory.getConfigurationContext();
    }

    private boolean isServiceSatisfySearchString(String searchString, String sequenceName) {
        if (searchString != null) {
            String regex = searchString.toLowerCase().replace("..?", ".?").replace("..*", ".*").replaceAll("\\?", ".?").replaceAll("\\*", ".*?");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sequenceName.toLowerCase());
            return regex.trim().length() == 0 || matcher.find();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceInfo[] getSequencesSearch(String searchText) throws SequenceEditorException {
        Lock lock = this.getLock();
        Collection sequences = null;
        ArrayList<SequenceInfo> searchedSequenceInfo = null;
        try {
            lock.lock();
            sequences = this.getSynapseConfiguration().getDefinedSequences().values();
            SequenceInfo[] info = SequenceInfoFactory.getSortedSequenceInfoArray(sequences);
            if (info != null && info.length > 0) {
                searchedSequenceInfo = new ArrayList<SequenceInfo>();
                for (SequenceInfo infoTemp : info) {
                    SequenceInfo seqInfo = new SequenceInfo();
                    seqInfo.setEnableStatistics(infoTemp.isEnableTracing());
                    seqInfo.setEnableTracing(infoTemp.isEnableTracing());
                    seqInfo.setName(infoTemp.getName());
                    seqInfo.setDescription(infoTemp.getDescription());
                    if (!this.isServiceSatisfySearchString(searchText, seqInfo.getName())) continue;
                    searchedSequenceInfo.add(seqInfo);
                }
            }
            if (searchedSequenceInfo != null && searchedSequenceInfo.size() > 0) {
                SequenceInfo[] sequenceInfoArray = searchedSequenceInfo.toArray(new SequenceInfo[searchedSequenceInfo.size()]);
                return sequenceInfoArray;
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to search sequences", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }
}

