/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.impl.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.crypto.api.ExternalCryptoProvider;
import org.wso2.carbon.crypto.api.InternalCryptoProvider;
import org.wso2.carbon.crypto.api.KeyResolver;
import org.wso2.carbon.crypto.api.PrivateKeyRetriever;
import org.wso2.carbon.crypto.impl.DefaultCryptoService;

@Component(name="org.wso2.carbon.crypto.impl", immediate=true)
public class CryptoImplComponent {
    private static final Log log = LogFactory.getLog(CryptoImplComponent.class);
    private ServiceRegistration<CryptoService> cryptoServiceRegistration;
    private DefaultCryptoService defaultCryptoService = new DefaultCryptoService();
    private ServiceRegistration<PrivateKeyRetriever> privateKeyRetrieverRegistration;
    private Map<String, Integer> keyResolverPriorities = new HashMap<String, Integer>();

    @Activate
    public void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            this.cryptoServiceRegistration = bundleContext.registerService(CryptoService.class, (Object)this.defaultCryptoService, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("'%s' has been registered as an implementation of '%s'", this.defaultCryptoService.getClass().getCanonicalName(), CryptoService.class.getCanonicalName()));
            }
            this.privateKeyRetrieverRegistration = bundleContext.registerService(PrivateKeyRetriever.class, (Object)this.defaultCryptoService, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("'%s' has been registered as an implementation of '%s'", this.defaultCryptoService.getClass().getCanonicalName(), PrivateKeyRetriever.class.getCanonicalName()));
                log.debug((Object)"'org.wso2.carbon.crypto.impl' bundle has been activated.");
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while activating org.wso2.carbon.crypto.impl component";
            log.error((Object)errorMessage, (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.cryptoServiceRegistration.unregister();
        this.privateKeyRetrieverRegistration.unregister();
    }

    @Reference(name="serverConfigurationService", service=ServerConfigurationService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, unbind="unsetServerConfigurationService")
    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.defaultCryptoService.setInternalCryptoProviderClassName(serverConfigurationService.getFirstProperty("CryptoService.InternalCryptoProviderClassName"));
        this.defaultCryptoService.setExternalCryptoProviderClassName(serverConfigurationService.getFirstProperty("CryptoService.ExternalCryptoProviderClassName"));
        this.readAndOverrideKeyResolverPriorities(serverConfigurationService.getDocumentElement());
    }

    private void readAndOverrideKeyResolverPriorities(Element configurationRoot) {
        NodeList keyResolversNodesCandidates = configurationRoot.getElementsByTagName("KeyResolvers");
        if (keyResolversNodesCandidates != null) {
            Node keyResolversNode = keyResolversNodesCandidates.item(0);
            NodeList childNodes = keyResolversNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childElement = childNodes.item(i);
                if (childElement.getNodeType() != 1 || !"KeyResolver".equals(childElement.getNodeName())) continue;
                NamedNodeMap attributes = childElement.getAttributes();
                String keyResolverClassName = attributes.getNamedItem("className").getTextContent();
                int keyResolverPriority = Integer.parseInt(attributes.getNamedItem("priority").getTextContent());
                this.keyResolverPriorities.put(keyResolverClassName, keyResolverPriority);
            }
        }
        this.overrideKeyResolverPriorities();
    }

    private void overrideKeyResolverPriorities() {
        for (Map.Entry<String, Integer> priorityMapping : this.keyResolverPriorities.entrySet()) {
            this.defaultCryptoService.overrideKeyResolverPriority(priorityMapping.getKey(), priorityMapping.getValue());
        }
    }

    public void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
    }

    @Reference(name="keyResolver", service=KeyResolver.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetKeyResolver")
    public void setKeyResolver(KeyResolver keyResolver) {
        this.defaultCryptoService.registerKeyResolver(keyResolver);
        this.overrideKeyResolverPriorities();
    }

    public void unsetKeyResolver(KeyResolver keyResolver) {
        this.defaultCryptoService.unregisterKeyResolver(keyResolver);
    }

    @Reference(name="internalCryptoProvider", service=InternalCryptoProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetInternalCryptoProvider")
    public void setInternalCryptoProvider(InternalCryptoProvider internalCryptoProvider) {
        this.defaultCryptoService.registerInternalCryptoProvider(internalCryptoProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("'%s' has been injected as an internal crypto provider.", internalCryptoProvider.getClass().getCanonicalName()));
        }
    }

    public void unsetInternalCryptoProvider(InternalCryptoProvider internalCryptoProvider) {
        this.defaultCryptoService.unregisterInternalCryptoProvider(internalCryptoProvider);
    }

    @Reference(name="externalCryptoProvider", service=ExternalCryptoProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetExternalCryptoProvider")
    public void setExternalCryptoProvider(ExternalCryptoProvider externalCryptoProvider) {
        this.defaultCryptoService.registerExternalCryptoProvider(externalCryptoProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("'%s' has been injected as an external crypto provider.", externalCryptoProvider.getClass().getCanonicalName()));
        }
    }

    public void unsetExternalCryptoProvider(ExternalCryptoProvider externalCryptoProvider) {
        this.defaultCryptoService.unregisterExternalCryptoProvider(externalCryptoProvider);
    }
}

